/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.web;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tentackle.app.ServerApplication;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;

public class ApplicationServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationServlet.class);
    private static final long serialVersionUID = -746056612270951056L;
    private static final RMICommandHandler[] COMMANDS = new RMICommandHandler[]{new ServletForwardCommand(), new ServletGethostnameCommand(), new ServletPingCommand(), new ServletTryHostnameCommand()};
    private static final Map<String, RMICommandHandler> COMMAND_LOOKUP = new HashMap<String, RMICommandHandler>();

    protected Logger createLogger() {
        return LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Properties props = new Properties();
            try {
                Context env = (Context)new InitialContext().lookup("java:comp/env");
                String filename = (String)env.lookup("tentackle.properties");
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
                    Properties extraProps = new Properties();
                    extraProps.load(is);
                    for (String key : extraProps.stringPropertyNames()) {
                        props.setProperty(key, extraProps.getProperty(key));
                    }
                }
            }
            catch (Exception env) {
                // empty catch block
            }
            Enumeration keys = config.getInitParameterNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                props.setProperty(key, config.getInitParameter(key));
            }
            String serverClassName = props.getProperty("applicationServer");
            if (serverClassName != null) {
                Class<?> serverClass = Class.forName(serverClassName);
                try {
                    ServerApplication server = (ServerApplication)serverClass.newInstance();
                    server.setProperties(props);
                    server.start();
                    LOGGER.info("Tentackle application server started", new Object[0]);
                }
                catch (Exception ex) {
                    LOGGER.logStacktrace((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.logStacktrace((Throwable)ex);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String param;
            String command;
            String queryString = req.getQueryString();
            int delim = queryString.indexOf(61);
            if (delim == -1) {
                command = queryString;
                param = "";
            } else {
                command = queryString.substring(0, delim);
                param = queryString.substring(delim + 1);
            }
            LOGGER.info("command: {0}, param: {1}", new Object[]{command, param});
            RMICommandHandler handler = COMMAND_LOOKUP.get(command);
            if (handler != null) {
                try {
                    handler.execute(req, res, param);
                }
                catch (ServletClientException e) {
                    this.returnClientError(res, "client error: " + e.getMessage());
                    LOGGER.logStacktrace((Throwable)e);
                }
                catch (ServletServerException e) {
                    this.returnServerError(res, "internal server error: " + e.getMessage());
                    LOGGER.logStacktrace((Throwable)e);
                }
            } else {
                this.returnClientError(res, "invalid command: " + command);
            }
        }
        catch (Exception e) {
            this.returnServerError(res, "internal error: " + e.getMessage());
            LOGGER.logStacktrace((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.returnClientError(res, "GET Operation not supported: Can only forward POST requests.");
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.returnClientError(res, "PUT Operation not supported: Can only forward POST requests.");
    }

    public String getServletInfo() {
        return "RMI Call Forwarding Servlet Servlet.<br>\n";
    }

    private void returnClientError(HttpServletResponse res, String message) throws IOException {
        res.sendError(400, "<HTML><HEAD><TITLE>Java RMI Client Error</TITLE></HEAD><BODY><H1>Java RMI Client Error</H1>" + message + "</BODY></HTML>");
        LOGGER.severe("400Java RMI Client Error" + message, new Object[0]);
    }

    private void returnServerError(HttpServletResponse res, String message) throws IOException {
        res.sendError(500, "<HTML><HEAD><TITLE>Java RMI Server Error</TITLE></HEAD><BODY><H1>Java RMI Server Error</H1>" + message + "</BODY></HTML>");
        LOGGER.severe("500Java RMI Server Error: " + message, new Object[0]);
    }

    static {
        for (RMICommandHandler command : COMMANDS) {
            COMMAND_LOOKUP.put(command.getName(), command);
        }
    }

    private static class ServletServerException
    extends Exception {
        private static final long serialVersionUID = 4055847163720192584L;

        public ServletServerException(String s) {
            super(s);
        }
    }

    private static class ServletClientException
    extends Exception {
        private static final long serialVersionUID = -8749500232249233431L;

        public ServletClientException(String s) {
            super(s);
        }
    }

    private static class ServletTryHostnameCommand
    implements RMICommandHandler {
        private ServletTryHostnameCommand() {
        }

        @Override
        public String getName() {
            return "hostname";
        }

        @Override
        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws ServletClientException, ServletServerException, IOException {
            PrintWriter pw = res.getWriter();
            pw.println("");
            pw.println("<HTML><HEAD><TITLE>Java RMI Server Hostname Info</TITLE></HEAD><BODY>");
            pw.println("<H1>Java RMI Server Hostname Info</H1>");
            pw.println("<H2>Local host name available to Java VM:</H2>");
            pw.print("<P>InetAddress.getLocalHost().getHostName()");
            try {
                String localHostName = InetAddress.getLocalHost().getHostName();
                pw.println(" = " + localHostName);
            }
            catch (UnknownHostException e) {
                pw.println(" threw java.net.UnknownHostException");
            }
            pw.println("<H2>Server host information obtained through Servlet interface from HTTP server:</H2>");
            pw.println("<P>SERVER_NAME = " + req.getServerName());
            pw.println("<P>SERVER_PORT = " + req.getServerPort());
            pw.println("</BODY></HTML>");
        }
    }

    private static class ServletPingCommand
    implements RMICommandHandler {
        private ServletPingCommand() {
        }

        @Override
        public String getName() {
            return "ping";
        }

        @Override
        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws ServletClientException, ServletServerException, IOException {
            res.setStatus(200);
            res.setContentType("application/octet-stream");
            res.setContentLength(0);
        }
    }

    private static class ServletGethostnameCommand
    implements RMICommandHandler {
        private ServletGethostnameCommand() {
        }

        @Override
        public String getName() {
            return "gethostname";
        }

        @Override
        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws ServletClientException, ServletServerException, IOException {
            byte[] getHostStringBytes = req.getServerName().getBytes();
            res.setStatus(200);
            res.setContentType("application/octet-stream");
            res.setContentLength(getHostStringBytes.length);
            ServletOutputStream out = res.getOutputStream();
            out.write(getHostStringBytes);
            out.flush();
        }
    }

    private static class ServletForwardCommand
    implements RMICommandHandler {
        private ServletForwardCommand() {
        }

        @Override
        public String getName() {
            return "forward";
        }

        @Override
        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws ServletClientException, ServletServerException, IOException {
            String line;
            DataInputStream socketIn;
            DataOutputStream socketOut;
            Socket socket;
            int port;
            try {
                port = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                throw new ServletClientException("invalid port number: " + param);
            }
            if (port <= 0 || port > 65535) {
                throw new ServletClientException("invalid port: " + port);
            }
            if (port < 1024) {
                throw new ServletClientException("permission denied for port: " + port);
            }
            try {
                socket = new Socket(InetAddress.getLocalHost(), port);
            }
            catch (IOException e) {
                throw new ServletServerException("could not connect to local port");
            }
            DataInputStream clientIn = new DataInputStream((InputStream)req.getInputStream());
            byte[] buffer = new byte[req.getContentLength()];
            try {
                clientIn.readFully(buffer);
            }
            catch (EOFException e) {
                throw new ServletClientException("unexpected EOF reading request body");
            }
            catch (IOException e) {
                throw new ServletClientException("error reading request body");
            }
            try {
                socketOut = new DataOutputStream(socket.getOutputStream());
                socketOut.writeBytes("POST / HTTP/1.0\r\n");
                socketOut.writeBytes("Content-length: " + req.getContentLength() + "\r\n\r\n");
                socketOut.write(buffer);
                socketOut.flush();
            }
            catch (IOException e) {
                throw new ServletServerException("error writing to server");
            }
            try {
                socketIn = new DataInputStream(socket.getInputStream());
            }
            catch (IOException e) {
                throw new ServletServerException("error reading from server");
            }
            String key = "Content-length:".toLowerCase();
            boolean contentLengthFound = false;
            int responseContentLength = -1;
            do {
                try {
                    line = socketIn.readLine();
                }
                catch (IOException e) {
                    throw new ServletServerException("error reading from server");
                }
                if (line == null) {
                    throw new ServletServerException("unexpected EOF reading server response");
                }
                if (!line.toLowerCase().startsWith(key)) continue;
                responseContentLength = Integer.parseInt(line.substring(key.length()).trim());
                contentLengthFound = true;
            } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
            if (!contentLengthFound || responseContentLength < 0) {
                throw new ServletServerException("missing or invalid content length in server response");
            }
            buffer = new byte[responseContentLength];
            try {
                socketIn.readFully(buffer);
            }
            catch (EOFException e) {
                throw new ServletServerException("unexpected EOF reading server response");
            }
            catch (IOException e) {
                throw new ServletServerException("error reading from server");
            }
            res.setStatus(200);
            res.setContentType("application/octet-stream");
            res.setContentLength(buffer.length);
            try {
                ServletOutputStream out = res.getOutputStream();
                out.write(buffer);
                out.flush();
            }
            catch (IOException e) {
                throw new ServletServerException("error writing response");
            }
            finally {
                socketOut.close();
                socketIn.close();
            }
        }
    }

    private static interface RMICommandHandler {
        public String getName();

        public void execute(HttpServletRequest var1, HttpServletResponse var2, String var3) throws ServletClientException, ServletServerException, IOException;
    }
}

