/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.web.app;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.StringHelper;
import org.tentackle.dbms.ConnectionManager;
import org.tentackle.dbms.ConnectionManagerProvider;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.DefaultDbPool;
import org.tentackle.dbms.MpxConnectionManager;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.misc.ApplicationException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionPoolProvider;
import org.tentackle.web.app.WebSessionKeyCache;

public abstract class WebApplication<T>
extends AbstractApplication
implements SessionPoolProvider,
ConnectionManagerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplication.class);
    private WebSessionKeyCache<T> sessionCache;
    private ConnectionManager connectionManager;
    private Db serverDb;
    private SessionPool sessionPool;

    public static <T> WebApplication<T> getWebApplication() {
        return (WebApplication)WebApplication.getRunningApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> WebApplication<T> getInstance(Class<? extends WebApplication<T>> clazz, Properties props) throws ApplicationException {
        Class<AbstractApplication> clazz2 = AbstractApplication.class;
        synchronized (AbstractApplication.class) {
            WebApplication<T> app = WebApplication.getWebApplication();
            if (app == null) {
                try {
                    app = clazz.newInstance();
                    if (app.isRunningInContainer()) {
                        Context env = (Context)new InitialContext().lookup("java:comp/env");
                        try {
                            String filename = (String)env.lookup("tentackle.properties");
                            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
                                Properties extraProps = new Properties();
                                extraProps.load(is);
                                for (String key : extraProps.stringPropertyNames()) {
                                    props.setProperty(key, extraProps.getProperty(key));
                                }
                            }
                        }
                        catch (IOException | NamingException exception) {
                            // empty catch block
                        }
                    }
                    app.start(props);
                }
                catch (IllegalAccessException | InstantiationException | NamingException | ApplicationException ex) {
                    LOGGER.logStacktrace(ex);
                    if (ex instanceof ApplicationException) {
                        throw (ApplicationException)ex;
                    }
                    if (app != null) {
                        app.doStop(4);
                    }
                    throw new ApplicationException("creating application instance failed: " + ex.getMessage(), ex);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return app;
        }
    }

    public WebApplication(String name) {
        super(name);
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            throw new NullPointerException("userinfo must not be null");
        }
        if (this.getSessionInfo() != null) {
            throw new PersistenceException("userinfo already set, cannot be changed in a running server");
        }
        sessionInfo.setImmutable(true);
        super.setSessionInfo(sessionInfo);
    }

    public boolean isServer() {
        return true;
    }

    protected void configurePreferences() {
        super.configurePreferences();
        PersistedPreferencesFactory.getInstance().setSystemOnly(true);
    }

    public void addWebSession(T sessionKey, SessionInfo userInfo) {
        this.sessionCache.addSession(sessionKey, userInfo);
    }

    public void removeWebSession(T sessionKey) {
        this.sessionCache.removeSession(sessionKey);
    }

    public Collection<T> getSessionKeys(SessionInfo sessionInfo) {
        return this.sessionCache.getSessionKeys(sessionInfo);
    }

    public Session getSession(T sessionKey) {
        SessionInfo sessionInfo = this.sessionCache.getSession(sessionKey);
        if (sessionInfo != null) {
            Db db = (Db)this.sessionPool.getSession();
            db.setSessionInfo(sessionInfo);
            return db;
        }
        return null;
    }

    public void putSession(Session session) {
        ((Db)session).setSessionInfo(null);
        this.sessionPool.putSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Properties props) throws ApplicationException {
        WebApplication webApplication = this;
        synchronized (webApplication) {
            this.sessionCache = new WebSessionKeyCache();
            this.setProperties(props);
            LOGGER.fine("register application", new Object[0]);
            this.register();
            LOGGER.fine("initialize application", new Object[0]);
            this.doInitialize();
            LOGGER.fine("login to backend", new Object[0]);
            this.doLogin();
            LOGGER.fine("configure application", new Object[0]);
            this.doConfigureApplication();
            LOGGER.fine("finish startup", new Object[0]);
            this.doFinishStartup();
        }
    }

    public void stop() throws ApplicationException {
        this.unregister();
        this.doStop(0);
    }

    public ConnectionManager createConnectionManager() {
        return new MpxConnectionManager("webmpx-mgr", this.serverDb.getBackendInfo(), 100, this.serverDb.getSessionId() + 1, 1, 1, 1, 100, 720, 2160);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public SessionPool createSessionPool() {
        return new DefaultDbPool("web-pool", this.connectionManager, this.getSessionInfo(), 2, 1, 2, this.connectionManager.getMaxSessions(), 60L, 1440L);
    }

    public SessionPool getSessionPool() {
        return this.sessionPool;
    }

    protected void configureSessionInfo(SessionInfo sessionInfo) {
        Properties sessionProps = null;
        try {
            sessionProps = sessionInfo.getProperties();
        }
        catch (PersistenceException e1) {
            sessionInfo.setProperties(this.getProperties());
        }
        if (sessionProps != null) {
            for (String key : this.getProperties().stringPropertyNames()) {
                sessionProps.setProperty(key, this.getProperties().getProperty(key));
            }
            sessionInfo.setProperties(sessionProps);
        }
        if (sessionInfo.getApplicationName() == null) {
            sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)this)).getClass()));
        }
        sessionInfo.applyProperties();
    }

    protected void doLogin() throws ApplicationException {
        char[] passwd;
        String username = this.getProperty("user");
        char[] password = StringHelper.toCharArray((String)this.getProperty("password"));
        String sessionPropertiesName = this.getProperty("backend");
        SessionInfo sessionInfo = this.createSessionInfo(username, password, sessionPropertiesName);
        this.configureSessionInfo(sessionInfo);
        this.setSessionInfo(sessionInfo);
        if (this.serverDb != null) {
            throw new ApplicationException("only one server application instance allowed");
        }
        this.serverDb = (Db)this.createSession(sessionInfo);
        username = this.serverDb.getBackendInfo().getUser();
        if (username != null) {
            sessionInfo.setUserName(username);
        }
        if ((passwd = this.serverDb.getBackendInfo().getPassword()) != null && passwd.length > 0 && passwd[0] != '\u0000') {
            sessionInfo.setPassword(passwd);
        }
        this.serverDb.open();
        DomainContext context = this.createDomainContext((Session)this.serverDb);
        if (context == null) {
            throw new ApplicationException("creating the database context failed");
        }
        this.setDomainContext(context);
        this.updateSessionInfoAfterLogin();
    }

    protected void doFinishStartup() throws ApplicationException {
        super.doFinishStartup();
        ModificationTracker.getInstance().addShutdownRunnable(() -> {
            LOGGER.severe("*** emergency shutdown ***", new Object[0]);
            this.doStop(5);
        });
        this.connectionManager = this.createConnectionManager();
        this.sessionPool = this.createSessionPool();
        this.sessionCache.startup(300000L);
    }

    protected void doStop(int exitValue, Exception ex) {
        if (exitValue != 0 || ex != null) {
            LOGGER.warning("web server abnormally terminated with exit code " + exitValue, new Object[0]);
            if (ex != null) {
                LoggerOutputStream.logException((Exception)ex, (Logger)LOGGER);
            }
        } else {
            LOGGER.info("web server terminated", new Object[0]);
        }
        try {
            Pdo.terminateHelperThreads();
            if (this.sessionCache != null) {
                this.sessionCache.terminate();
                this.sessionCache = null;
            }
            if (this.sessionPool != null) {
                this.sessionPool.shutdown();
                this.sessionPool = null;
            }
            if (this.serverDb != null) {
                this.serverDb.close();
                this.serverDb = null;
            }
            this.connectionManager.shutdown();
            this.connectionManager = null;
            if (this.isRunningInContainer()) {
                this.deregisterJdbcDrivers(Thread.currentThread().getContextClassLoader());
            }
        }
        catch (Exception anyEx) {
            LOGGER.severe("web server stopped ungracefully", (Throwable)anyEx);
        }
        if (!this.isRunningInContainer()) {
            System.exit(exitValue);
        }
    }

    protected void doStop(int exitValue) {
        this.doStop(exitValue, null);
    }
}

