// wurblet generated by Wurbelizer 11.2.2.1, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the database column names.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ColumnNames
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class ColumnNames extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() {
    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoConstant() && !attr.getOptions().isFromSuper()) {
        String name = attr.getName().toUpperCase();
        if (!attr.getOptions().isNoDeclare() || attr.getOptions().isFromSuper())    {
          for (DataType.SqlTypeWithPostfix sp: attr.getDataType().getSqlTypesWithPostfix()) {
            out.print(source[0]); // 17:2 = "  /** database column name for '"
            out.print(attr);
            out.print(source[1]); // 19:40 = "'. */  public static final String CN_"
            out.print(name);
            out.print(sp.getPostfix());
            out.print(source[2]); // 20:59 = " = ""
            out.print(attr.getColumnName());
            out.print(sp.getPostfix());
            out.print(source[3]); // 20:106 = "";"
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
