// wurblet generated by Wurbelizer 11.2.3.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate relation method definitions of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Relations
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class Relations extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {

    for (Relation rel: getEntity().getRelations()) {

      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }

      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String firstArg = rel.getMethodArgs().get(0).getMethodArgument();
      boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        // take from attribute
        hidden |= attr.isHidden();
        createGetter &= !attr.getOptions().isWriteOnly() && !hidden;
        createSetter &= !attr.getOptions().isReadOnly() && !hidden;
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      Relation oppRel = rel.getForeignRelation();

      // getter

      if (createGetter)  {
        String checkNull = firstArg + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = firstArg + " == null || " + checkNull;
        }
        out.print(source[0]); // 58:2 = "  /**   * Gets "
        out.print(rel);
        out.print(source[1]); // 61:17 = ".   *   * @return "
        out.print(var);
        out.print(source[2]); // 63:21 = " "
        out.print(rel.getComment());
        out.print(source[3]); // 63:42 = "   */  @Bindable"
        if (rel.isComposite()) {
          out.print(source[4]); // 68:2 = "  @Persistent(ordinal="
          out.print(rel.getOrdinal());
          out.print(source[5]); // 69:43 = ", comment="
          out.print(StringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[6]); // 69:102 = ")"
        }
        else {
          if (oppRel != null && oppRel.isComposite()) {
            out.print(source[7]); // 74:2 = "  @Persistent(ordinal="
            out.print(rel.getOrdinal());
            out.print(source[8]); // 75:43 = ", comment="
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[9]); // 75:102 = ", component=false, parent=true)"
          }
          else {
            out.print(source[10]); // 79:2 = "  @Persistent(ordinal="
            out.print(rel.getOrdinal());
            out.print(source[11]); // 80:43 = ", comment="
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[12]); // 80:102 = ", component=false)"
          }
        }
        for (String annotation: rel.getAnnotations()) {
          out.print(source[13]); // 85:2 = "  "
          out.print(annotation);
          out.print(source[14]); // 86:16 = ""
        }
        out.print(source[15]); // 89:2 = "  "
        out.print(type);
        out.print(source[16]); // 90:10 = " "
        out.print(rel.getGetterName());
        out.print(source[17]); // 90:34 = "();"
        if (nmRel != null) {
          out.print(source[18]); // 93:2 = "  /**   * Gets list of "
          out.print(nmRel.getDeclaredJavaType(false));
          out.print(source[19]); // 96:54 = " joined via "
          out.print(rel);
          out.print(source[20]); // 96:73 = ".   *   * @return list of "
          out.print(nmRel.getVariableName());
          out.print(source[21]); // 98:49 = "   */  @Bindable  @Persistent(ordinal..."
          out.print(rel.getOrdinal());
          out.print(source[22]); // 101:43 = ", comment="
          out.print(StringHelper.toDoubleQuotes(nmVar));
          out.print(source[23]); // 101:91 = ", component=false)  TrackedList<"
          out.print(nmRel.getDeclaredJavaType(false));
          out.print(source[24]); // 102:50 = "> get"
          out.print(nmName);
          out.print(source[25]); // 102:65 = "();"
        }

        if (rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
              out.print(source[26]); // 108:2 = "  /**   * Returns whether "
              out.print(rel.getName());
              out.print(source[27]); // 111:38 = " is loaded.   *   * @return true if "
              out.print(rel.getGetterName());
              out.print(source[28]); // 113:45 = "() invoked at least once   */  @Bindab..."
              out.print(StringHelper.firstToUpper(var));
              out.print(source[29]); // 116:46 = "Loaded();"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        boolean linkMethodIndexed = rel.getForeignRelation() != null ?
            rel.getForeignRelation().getLinkMethodIndex() != null : false;

            out.print(source[30]); // 127:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[31]); // 130:17 = ".   *   * @param "
            out.print(var);
            out.print(source[32]); // 132:20 = " "
            out.print(rel.getComment());
            out.print(source[33]); // 132:41 = ""
        if (linkMethodIndexed) {
          out.print(source[34]); // 135:2 = "   * @param index the index starting at ..."
        }
        out.print(source[35]); // 139:2 = "   */"
        if (attr != null && attr.getOptions().isBind()) {
          out.print(source[36]); // 143:2 = "  "
          out.print(attr.getBindableAnnotation());
          out.print(source[37]); // 144:34 = ""
        }
        if (linkMethodIndexed) {
          out.print(source[38]); // 148:2 = "  void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[39]); // 149:55 = "("
          out.print(type);
          out.print(source[40]); // 149:64 = " "
          out.print(var);
          out.print(source[41]); // 149:72 = ", int index);"
        }
        else {
          out.print(source[42]); // 153:2 = "  void "
          out.print(rel.getSetterName());
          out.print(source[43]); // 154:30 = "("
          out.print(type);
          out.print(source[44]); // 154:39 = " "
          out.print(var);
          out.print(source[45]); // 154:47 = ");"
        }
      }
    }

    // creates the select- and delete-methods for list relations in foreign entities
    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());
    Set<String> declaredArgSet = new HashSet<>();   // to avoid duplicates if args= is used

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }
      if (rel.getRelationType() == RelationType.LIST) {
        Attribute attribute = rel.getForeignAttribute();
        if (attribute != null) {
          String declaredArgs = createDeclaredArgsForSelectOrDeleteMethod(rel);
          if (declaredArgSet.add(declaredArgs)) {
            out.print(source[46]); // 174:2 = "  /**   * Selects "
            out.print(rel);
            out.print(source[47]); // 177:20 = ".   *"
            for (MethodArgument arg : rel.getMethodArgs()) {
              Attribute attr = arg.getForeignAttribute();
              out.print(source[48]); // 182:2 = "   * @param "
              out.print(attr.getName());
              out.print(source[49]); // 183:31 = " "
              out.print(attr.getOptions().getComment());
              out.print(source[50]); // 183:66 = ""
            }
            out.print(source[51]); // 186:2 = "   * @return "
            out.print(rel.getComment());
            out.print(source[52]); // 187:34 = "   */  "
            out.print(rel.getDeclaredJavaType(true));
            out.print(source[53]); // 189:35 = " "
            out.print(createRelationSelectMethodName(rel));
            out.print(source[54]); // 189:75 = "("
            out.print(declaredArgs);
            out.print(source[55]); // 189:92 = ");"
            if (rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
              out.print(source[56]); // 192:2 = "  /**   * Deletes "
              out.print(rel);
              out.print(source[57]); // 195:20 = ".   *"
              for (MethodArgument arg : rel.getMethodArgs()) {
                Attribute attr = arg.getForeignAttribute();
                out.print(source[58]); // 200:2 = "   * @param "
                out.print(attr.getName());
                out.print(source[59]); // 201:31 = " "
                out.print(attr.getOptions().getComment());
                out.print(source[60]); // 201:66 = ""
              }
              out.print(source[61]); // 204:2 = "   * @return "
              out.print(rel.getComment());
              out.print(source[62]); // 205:34 = "   */  int "
              out.print(createListRelationDeleteMethodName(rel));
              out.print(source[63]); // 207:49 = "("
              out.print(declaredArgs);
              out.print(source[64]); // 207:66 = ");"
            }
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
