// wurblet generated by Wurbelizer 11.3.0.1, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> option to generate code according to the builder pattern.</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=", the property is mutable and a setter is generated.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Example:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed with "!" are considered as required and a TentackleRuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        if (property.isMutable()) {
          out.print(source[0]); // 70:2 = "  private "
          out.print(property.getType());
          out.print(source[1]); // 71:32 = " "
          out.print(property.getName());
          out.print(source[2]); // 71:55 = ";  // "
          out.print(property.getComment());
          out.print(source[3]); // 71:86 = ""
        }
        else {
          out.print(source[4]); // 75:2 = "  private final "
          out.print(property.getType());
          out.print(source[5]); // 76:38 = " "
          out.print(property.getName());
          out.print(source[6]); // 76:61 = ";  // "
          out.print(property.getComment());
          out.print(source[7]); // 76:92 = ""
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[8]); // 84:2 = ""
      if (!withBuilder) {
        out.print(source[9]); // 88:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[10]); // 90:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[11]); // 95:2 = "   * @param "
            out.print(property.getName());
            out.print(source[12]); // 96:35 = " "
            out.print(property.getComment());
            out.print(source[13]); // 96:61 = ""
          }
        }
        out.print(source[14]); // 100:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[15]); // 127:2 = "  protected "
        out.print(getClassName());
        out.print(source[16]); // 128:30 = "(Builder builder) {"
        if (extendsWithBuilder != null) {
          out.print(source[17]); // 131:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            if (property.isRequired()) {
              out.print(source[18]); // 138:2 = "    if (!builder."
              out.print(property.getName());
              out.print(source[19]); // 139:39 = "Provided) {      throw new TentackleRun..."
              out.print(property.getName());
              out.print(source[20]); // 140:65 = " is required");    }"
            }
            out.print(source[21]); // 144:2 = "    this."
            out.print(property.getName());
            out.print(source[22]); // 145:31 = " = builder."
            out.print(property.getName());
            out.print(source[23]); // 145:64 = ";"
          }
        }
        out.print(source[24]); // 149:2 = "  }"
      }
      else {
        out.print(source[25]); // 154:2 = "  public "
        out.print(getClassName());
        out.print(source[26]); // 155:27 = "("
        out.print(args.toString());
        out.print(source[27]); // 155:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[28]); // 158:2 = "    super("
          out.print(superArgs);
          out.print(source[29]); // 159:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[30]); // 164:2 = "    this."
            out.print(property.getName());
            out.print(source[31]); // 165:31 = " = "
            out.print(property.getName());
            out.print(source[32]); // 165:56 = ";"
          }
        }
        out.print(source[33]); // 169:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[34]); // 178:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[35]); // 181:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[36]); // 183:39 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[37]); // 187:2 = "  "
          out.print(anno);
          out.print(source[38]); // 188:10 = ""
        }
        out.print(source[39]); // 191:2 = "  public "
        out.print(property.getType());
        out.print(source[40]); // 192:31 = " "
        out.print(property.getGetterName());
        out.print(source[41]); // 192:60 = "() {    return "
        out.print(property.getName());
        out.print(source[42]); // 193:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[43]); // 202:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[44]); // 205:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[45]); // 207:35 = " "
        out.print(property.getComment());
        out.print(source[46]); // 207:61 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[47]); // 211:2 = "  "
          out.print(anno);
          out.print(source[48]); // 212:10 = ""
        }
        out.print(source[49]); // 215:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[50]); // 216:42 = "("
        out.print(property.getType());
        out.print(source[51]); // 216:65 = " "
        out.print(property.getName());
        out.print(source[52]); // 216:88 = ") {    this."
        out.print(property.getName());
        out.print(source[53]); // 217:31 = " = "
        out.print(property.getName());
        out.print(source[54]); // 217:56 = ";  }"
      }
    }

    if (withBuilder) {
      String extendsStr = "";
      if (extendsWithBuilder != null) {
        extendsStr = "extends " + extendsWithBuilder + ".Builder ";
      }
      out.print(source[55]); // 228:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[56]); // 232:33 = " builder.   *   * @return the builder..."
      out.print(getClassName());
      out.print(source[57]); // 241:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[58]); // 243:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[59]); // 248:2 = "    private "
          out.print(property.getType());
          out.print(source[60]); // 249:34 = " "
          out.print(property.getName());
          out.print(source[61]); // 249:57 = ";  // "
          out.print(property.getComment());
          out.print(source[62]); // 249:88 = ""
          if (property.isRequired()) {
            out.print(source[63]); // 252:2 = "    private boolean "
            out.print(property.getName());
            out.print(source[64]); // 253:42 = "Provided;  // true if "
            out.print(property.getComment());
            out.print(source[65]); // 253:89 = " was provided"
          }
        }
      }
      out.print(source[66]); // 258:2 = "    protected Builder() {}"
      if (!isAbstract()) {
        out.print(source[67]); // 264:2 = "    /**     * Builds a "
        out.print(getClassName());
        out.print(source[68]); // 267:34 = ".     *     * @return the "
        out.print(getClassName());
        out.print(source[69]); // 269:38 = "     */    public "
        out.print(getClassName());
        out.print(source[70]); // 271:29 = " build() {      return new "
        out.print(getClassName());
        out.print(source[71]); // 272:35 = "(this);    }"
      }

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[72]); // 280:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[73]); // 283:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[74]); // 285:37 = " "
          out.print(property.getComment());
          out.print(source[75]); // 285:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[76]); // 288:41 = "("
          out.print(property.getType());
          out.print(source[77]); // 288:64 = " "
          out.print(property.getName());
          out.print(source[78]); // 288:87 = ") {      this."
          out.print(property.getName());
          out.print(source[79]); // 289:33 = " = "
          out.print(property.getName());
          out.print(source[80]); // 289:58 = ";"
        if (property.isRequired()) {
          out.print(source[81]); // 292:2 = "      "
          out.print(property.getName());
          out.print(source[82]); // 293:28 = "Provided = true;"
        }
        out.print(source[83]); // 296:2 = "      return this;    }"
        }
      }
      out.print(source[84]); // 302:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
