// wurblet generated by Wurbelizer 11.3.0.1, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> option to generate code according to the builder pattern.</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed with "!" are considered as required and a TentackleRuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be rmoved from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        String decl = "private";
        if (!property.isMutable()) {
          decl += " final";
        }
        else if (property.isTransient()) {
          decl += " transient";
        }
        out.print(source[0]); // 79:2 = "  "
        out.print(decl);
        out.print(source[1]); // 80:10 = " "
        out.print(property.getType());
        out.print(source[2]); // 80:33 = " "
        out.print(property.getName());
        out.print(source[3]); // 80:56 = ";  // "
        out.print(property.getComment());
        out.print(source[4]); // 80:87 = ""
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[5]); // 87:2 = ""
      if (!withBuilder) {
        out.print(source[6]); // 91:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[7]); // 93:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[8]); // 98:2 = "   * @param "
            out.print(property.getName());
            out.print(source[9]); // 99:35 = " "
            out.print(property.getComment());
            out.print(source[10]); // 99:61 = ""
          }
        }
        out.print(source[11]); // 103:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[12]); // 130:2 = "  protected "
        out.print(getClassName());
        out.print(source[13]); // 131:30 = "(Builder builder) {"
        if (extendsWithBuilder != null) {
          out.print(source[14]); // 134:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            if (property.isRequired()) {
              out.print(source[15]); // 141:2 = "    if (!builder."
              out.print(property.getName());
              out.print(source[16]); // 142:39 = "Provided) {      throw new TentackleRun..."
              out.print(property.getName());
              out.print(source[17]); // 143:65 = " is required");    }"
            }
            out.print(source[18]); // 147:2 = "    this."
            out.print(property.getName());
            out.print(source[19]); // 148:31 = " = builder."
            out.print(property.getName());
            out.print(source[20]); // 148:64 = ";"
          }
        }
        out.print(source[21]); // 152:2 = "  }"
      }
      else {
        out.print(source[22]); // 157:2 = "  public "
        out.print(getClassName());
        out.print(source[23]); // 158:27 = "("
        out.print(args.toString());
        out.print(source[24]); // 158:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[25]); // 161:2 = "    super("
          out.print(superArgs);
          out.print(source[26]); // 162:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[27]); // 167:2 = "    this."
            out.print(property.getName());
            out.print(source[28]); // 168:31 = " = "
            out.print(property.getName());
            out.print(source[29]); // 168:56 = ";"
          }
        }
        out.print(source[30]); // 172:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[31]); // 181:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[32]); // 184:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[33]); // 186:39 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[34]); // 190:2 = "  "
          out.print(anno);
          out.print(source[35]); // 191:10 = ""
        }
        out.print(source[36]); // 194:2 = "  public "
        out.print(property.getType());
        out.print(source[37]); // 195:31 = " "
        out.print(property.getGetterName());
        out.print(source[38]); // 195:60 = "() {    return "
        out.print(property.getName());
        out.print(source[39]); // 196:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[40]); // 205:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[41]); // 208:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[42]); // 210:35 = " "
        out.print(property.getComment());
        out.print(source[43]); // 210:61 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[44]); // 214:2 = "  "
          out.print(anno);
          out.print(source[45]); // 215:10 = ""
        }
        out.print(source[46]); // 218:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[47]); // 219:42 = "("
        out.print(property.getType());
        out.print(source[48]); // 219:65 = " "
        out.print(property.getName());
        out.print(source[49]); // 219:88 = ") {    this."
        out.print(property.getName());
        out.print(source[50]); // 220:31 = " = "
        out.print(property.getName());
        out.print(source[51]); // 220:56 = ";  }"
      }
    }

    if (withBuilder) {
      String extendsStr = "";
      if (extendsWithBuilder != null) {
        extendsStr = "extends " + extendsWithBuilder + ".Builder ";
      }
      out.print(source[52]); // 231:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[53]); // 235:33 = " builder.   *   * @return the builder..."
      out.print(getClassName());
      out.print(source[54]); // 244:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[55]); // 246:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[56]); // 251:2 = "    private "
          out.print(property.getType());
          out.print(source[57]); // 252:34 = " "
          out.print(property.getName());
          out.print(source[58]); // 252:57 = ";  // "
          out.print(property.getComment());
          out.print(source[59]); // 252:88 = ""
          if (property.isRequired()) {
            out.print(source[60]); // 255:2 = "    private boolean "
            out.print(property.getName());
            out.print(source[61]); // 256:42 = "Provided;  // true if "
            out.print(property.getComment());
            out.print(source[62]); // 256:89 = " was provided"
          }
        }
      }
      out.print(source[63]); // 261:2 = "    protected Builder() {}"
      if (!isAbstract()) {
        out.print(source[64]); // 267:2 = "    /**     * Builds a "
        out.print(getClassName());
        out.print(source[65]); // 270:34 = ".     *     * @return the "
        out.print(getClassName());
        out.print(source[66]); // 272:38 = "     */    public "
        out.print(getClassName());
        out.print(source[67]); // 274:29 = " build() {      return new "
        out.print(getClassName());
        out.print(source[68]); // 275:35 = "(this);    }"
      }

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[69]); // 283:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[70]); // 286:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[71]); // 288:37 = " "
          out.print(property.getComment());
          out.print(source[72]); // 288:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[73]); // 291:41 = "("
          out.print(property.getType());
          out.print(source[74]); // 291:64 = " "
          out.print(property.getName());
          out.print(source[75]); // 291:87 = ") {      this."
          out.print(property.getName());
          out.print(source[76]); // 292:33 = " = "
          out.print(property.getName());
          out.print(source[77]); // 292:58 = ";"
        if (property.isRequired()) {
          out.print(source[78]); // 295:2 = "      "
          out.print(property.getName());
          out.print(source[79]); // 296:28 = "Provided = true;"
        }
        out.print(source[80]); // 299:2 = "      return this;    }"
        }
      }
      out.print(source[81]); // 305:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
