// wurblet generated by Wurbelizer 11.3.1.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the database column names.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ColumnNames
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class ColumnNames extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {
    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoConstant() && !attr.getOptions().isFromSuper()) {
        if (!attr.getOptions().isNoDeclare() || attr.getOptions().isFromSuper())    {
          for (int columnIndex = 0; columnIndex < getEffectiveDataType(attr).getColumnCount(); columnIndex++) {
            out.print(source[0]); // 16:2 = "  /** database column name for '"
            out.print(attr);
            out.print(source[1]); // 18:40 = "'. */  public static final String "
            out.print(getColumnNameConstant(attr, columnIndex));
            out.print(source[2]); // 19:73 = " = "
            out.print(StringHelper.toDoubleQuotes(getColumnName(attr, columnIndex)));
            out.print(source[3]); // 19:141 = ";"
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
