// wurblet generated by Wurbelizer 11.3.1.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder [--from]] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> option to generate code according to the builder pattern.</li>
 * <li><em>--equals:</em> option to generate the equals method.</li>
 * <li><em>--hashCode:</em> option to generate the hashCode method.</li>
 * <li><em>--from:</em> only if --builder set: generate method to create a builder from instance. This will automatically
 * happen if the '+' option at set for at least one property.</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed with "!" are considered as required and a TentackleRuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * For lines prefixed with "+" a from-Method is generated that creates a new DTO from the current one by replacing the given property.
 * <pre>
 * +String name   the name
 * </pre>
 * This would create an instance method "fromName(String name)" that returns a new DTO instance.
 * <p>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be rmoved from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 * <p>
 * Important: if <code>--equals</code> or <code>--hashCode</code> is given in a subclass, all superclasses must
 * get those options as well!
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        String decl = "private";
        if (!property.isMutable()) {
          decl += " final";
        }
        else if (property.isTransient()) {
          decl += " transient";
        }
        out.print(source[0]); // 92:2 = "  "
        out.print(decl);
        out.print(source[1]); // 93:10 = " "
        out.print(property.getType());
        out.print(source[2]); // 93:33 = " "
        out.print(property.getName());
        out.print(source[3]); // 93:56 = ";  // "
        out.print(property.getComment());
        out.print(source[4]); // 93:87 = ""
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[5]); // 100:2 = ""
      if (!withBuilder) {
        out.print(source[6]); // 104:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[7]); // 106:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[8]); // 111:2 = "   * @param "
            out.print(property.getName());
            out.print(source[9]); // 112:35 = " "
            out.print(property.getComment());
            out.print(source[10]); // 112:61 = ""
          }
        }
        out.print(source[11]); // 116:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[12]); // 143:2 = "  protected "
        out.print(getClassName());
        out.print(source[13]); // 144:30 = "(Builder builder) {"
        if (superClass != null) {
          out.print(source[14]); // 147:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            if (property.isRequired()) {
              out.print(source[15]); // 154:2 = "    if (!builder."
              out.print(property.getName());
              out.print(source[16]); // 155:39 = "Provided) {      throw new TentackleRun..."
              out.print(property.getName());
              out.print(source[17]); // 156:65 = " is required");    }"
            }
            out.print(source[18]); // 160:2 = "    this."
            out.print(property.getName());
            out.print(source[19]); // 161:31 = " = builder."
            out.print(property.getName());
            out.print(source[20]); // 161:64 = ";"
          }
        }
        out.print(source[21]); // 165:2 = "  }"
      }
      else {
        out.print(source[22]); // 170:2 = "  public "
        out.print(getClassName());
        out.print(source[23]); // 171:27 = "("
        out.print(args.toString());
        out.print(source[24]); // 171:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[25]); // 174:2 = "    super("
          out.print(superArgs);
          out.print(source[26]); // 175:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[27]); // 180:2 = "    this."
            out.print(property.getName());
            out.print(source[28]); // 181:31 = " = "
            out.print(property.getName());
            out.print(source[29]); // 181:56 = ";"
          }
        }
        out.print(source[30]); // 185:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[31]); // 194:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[32]); // 197:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[33]); // 199:39 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[34]); // 203:2 = "  "
          out.print(anno);
          out.print(source[35]); // 204:10 = ""
        }
        out.print(source[36]); // 207:2 = "  public "
        out.print(property.getType());
        out.print(source[37]); // 208:31 = " "
        out.print(property.getGetterName());
        out.print(source[38]); // 208:60 = "() {    return "
        out.print(property.getName());
        out.print(source[39]); // 209:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[40]); // 218:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[41]); // 221:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[42]); // 223:35 = " "
        out.print(property.getComment());
        out.print(source[43]); // 223:61 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[44]); // 227:2 = "  "
          out.print(anno);
          out.print(source[45]); // 228:10 = ""
        }
        out.print(source[46]); // 231:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[47]); // 232:42 = "("
        out.print(property.getType());
        out.print(source[48]); // 232:65 = " "
        out.print(property.getName());
        out.print(source[49]); // 232:88 = ") {    this."
        out.print(property.getName());
        out.print(source[50]); // 233:31 = " = "
        out.print(property.getName());
        out.print(source[51]); // 233:56 = ";  }"
      }
    }

    // create "from" methods
    for (Property property: properties) {
      if (property.isWithFrom()) {
        out.print(source[52]); // 242:2 = "  /**   * Create copy with "
        out.print(property.getComment());
        out.print(source[53]); // 245:47 = " from given "
        out.print(property.getName());
        out.print(source[54]); // 245:81 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[55]); // 247:35 = " "
        out.print(property.getComment());
        out.print(source[56]); // 247:61 = "   * @return the copied "
        out.print(getClassName());
        out.print(source[57]); // 248:43 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[58]); // 252:2 = "  "
          out.print(anno);
          out.print(source[59]); // 253:10 = ""
        }
        out.print(source[60]); // 256:2 = "  public "
        out.print(getClassName());
        out.print(source[61]); // 257:27 = " "
        out.print(property.getFromName());
        out.print(source[62]); // 257:54 = "("
        out.print(property.getType());
        out.print(source[63]); // 257:77 = " "
        out.print(property.getName());
        out.print(source[64]); // 257:100 = ") {"
        if (withBuilder) {
          if (property.isMutable()) {
            out.print(source[65]); // 261:2 = "    "
            out.print(getClassName());
            out.print(source[66]); // 262:22 = " object = createBuilder().build();    o..."
            out.print(property.getSetterName());
            out.print(source[67]); // 263:39 = "("
            out.print(property.getName());
            out.print(source[68]); // 263:62 = ");    return object;"
          }
          else {
            out.print(source[69]); // 268:2 = "    return createBuilder()."
            out.print(property.getName());
            out.print(source[70]); // 269:49 = "("
            out.print(property.getName());
            out.print(source[71]); // 269:72 = ").build();"
          }
        }
        else {
          StringBuilder argBuf = new StringBuilder();
          for (Property prop: properties) {
            if (argBuf.length() > 0) {
              argBuf.append(", ");
            }
            if (prop == property) {
              argBuf.append(prop.getName());
            }
            else {
              if (prop.isInherited()) {
                argBuf.append(prop.getGetterName() + "()");
              }
              else {
                argBuf.append("this." + prop.getName());
              }
            }
          }
          out.print(source[72]); // 291:2 = "    return new "
          out.print(getClassName());
          out.print(source[73]); // 292:33 = "("
          out.print(argBuf);
          out.print(source[74]); // 292:44 = ");"
        }
        out.print(source[75]); // 295:2 = "  }"
      }
    }

    if (withEquals) {
      out.print(source[76]); // 302:2 = "  @Override  public boolean equals(Obj..."
      if (superClass != null) {
        out.print(source[77]); // 317:2 = "    if (!super.equals(obj)) {      retu..."
      }
      out.print(source[78]); // 323:2 = "    "
      out.print(getClassName());
      out.print(source[79]); // 324:22 = " other = ("
      out.print(getClassName());
      out.print(source[80]); // 324:50 = ") obj;"
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[81]); // 329:2 = "    if ("
            out.print(property.getName());
            out.print(source[82]); // 330:30 = " != other."
            out.print(property.getName());
            out.print(source[83]); // 330:62 = ") {      return false;    }"
          }
          else  {
            out.print(source[84]); // 336:2 = "    if (!Objects.equals("
            out.print(property.getName());
            out.print(source[85]); // 337:46 = ", other."
            out.print(property.getName());
            out.print(source[86]); // 337:76 = ")) {      return false;    }"
          }
        }
      }
      out.print(source[87]); // 344:2 = "    return true;  }"
    }


    if (withHashCode) {
      out.print(source[88]); // 352:2 = "  @Override  public int hashCode() {"
      if (superClass != null) {
        out.print(source[89]); // 358:2 = "    int hash = super.hashCode();"
      }
      else {
        out.print(source[90]); // 363:2 = "    int hash = 7;"
      }
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[91]); // 370:2 = "    hash = 79 * hash + "
            out.print(property.getName());
            out.print(source[92]); // 371:45 = ";"
          }
          else  {
            out.print(source[93]); // 375:2 = "    hash = 79 * hash + Objects.hashCode(..."
            out.print(property.getName());
            out.print(source[94]); // 376:62 = ");"
          }
        }
      }
      out.print(source[95]); // 381:2 = "    return hash;  }"
    }

    if (withBuilder) {
      String extendsStr = "";
      if (superClass != null) {
        extendsStr = "extends " + superClass + ".Builder ";
      }
      out.print(source[96]); // 392:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[97]); // 396:33 = " builder.   *   * @return the builder..."
      if (withFrom) {
        out.print(source[98]); // 405:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[99]); // 408:33 = " builder from current object.   *   * ..."
      if (superClass != null) {
        out.print(source[100]); // 414:2 = "  @Override"
      }
      out.print(source[101]); // 418:2 = "  public Builder createBuilder() {    r..."
      }
      out.print(source[102]); // 424:2 = "  /**   * The "
      out.print(getClassName());
      out.print(source[103]); // 427:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[104]); // 429:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[105]); // 434:2 = "    private "
          out.print(property.getType());
          out.print(source[106]); // 435:34 = " "
          out.print(property.getName());
          out.print(source[107]); // 435:57 = ";  // "
          out.print(property.getComment());
          out.print(source[108]); // 435:88 = ""
          if (property.isRequired()) {
            out.print(source[109]); // 438:2 = "    private boolean "
            out.print(property.getName());
            out.print(source[110]); // 439:42 = "Provided;  // true if "
            out.print(property.getComment());
            out.print(source[111]); // 439:89 = " was provided"
          }
        }
      }
      out.print(source[112]); // 444:2 = "    protected Builder() {}"
      if (withFrom) {
        out.print(source[113]); // 449:2 = "    protected Builder("
        out.print(getClassName());
        out.print(source[114]); // 451:40 = " template) {"
        if (superClass != null) {
          out.print(source[115]); // 454:2 = "      super(template);"
        }
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[116]); // 460:2 = "      "
            out.print(property.getName());
            out.print(source[117]); // 461:28 = "(template."
            out.print(property.getGetterName());
            out.print(source[118]); // 461:66 = "());"
          }
        }
        out.print(source[119]); // 465:2 = "    }"
      }

      out.print(source[120]); // 470:2 = "    /**     * Builds a "
      out.print(getClassName());
      out.print(source[121]); // 473:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[122]); // 475:38 = "     */"
      if (superClass != null) {
        out.print(source[123]); // 479:2 = "    @Override"
      }
      out.print(source[124]); // 483:2 = "    public "
      out.print(getClassName());
      out.print(source[125]); // 484:29 = " build() {"
      if (isAbstract()) {
        out.print(source[126]); // 487:2 = "      throw new TentackleRuntimeExceptio..."
        out.print(getClassName());
        out.print(source[127]); // 488:83 = "");"
      }
      else {
        out.print(source[128]); // 492:2 = "      return new "
        out.print(getClassName());
        out.print(source[129]); // 493:35 = "(this);"
      }
      out.print(source[130]); // 496:2 = "    }"

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[131]); // 502:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[132]); // 505:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[133]); // 507:37 = " "
          out.print(property.getComment());
          out.print(source[134]); // 507:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[135]); // 510:41 = "("
          out.print(property.getType());
          out.print(source[136]); // 510:64 = " "
          out.print(property.getName());
          out.print(source[137]); // 510:87 = ") {      this."
          out.print(property.getName());
          out.print(source[138]); // 511:33 = " = "
          out.print(property.getName());
          out.print(source[139]); // 511:58 = ";"
        if (property.isRequired()) {
          out.print(source[140]); // 514:2 = "      "
          out.print(property.getName());
          out.print(source[141]); // 515:28 = "Provided = true;"
        }
        out.print(source[142]); // 518:2 = "      return this;    }"
        }
      }
      out.print(source[143]); // 524:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
