/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tentackle.common.Path;
import org.tentackle.model.Relation;
import org.tentackle.wurblet.Join;

public class JoinPath
implements Path<JoinPath, Join> {
    private List<Join> elements;
    private List<JoinPath> paths;

    public JoinPath(List<Join> elements, List<JoinPath> paths) {
        this.elements = elements;
        this.paths = paths;
    }

    public JoinPath(Join element, List<JoinPath> paths) {
        this.elements = new ArrayList<Join>();
        this.elements.add(element);
        this.paths = paths;
    }

    public List<Join> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<Join>();
        }
        return this.elements;
    }

    public List<JoinPath> getPaths() {
        if (this.paths == null) {
            this.paths = new ArrayList<JoinPath>();
        }
        return this.paths;
    }

    public Join findJoin(List<Relation> relations) {
        return this.findJoinImpl(this, relations);
    }

    private Join findJoinImpl(JoinPath path, List<Relation> relations) {
        Join join;
        block3: {
            JoinPath subPath;
            join = null;
            int depth = 0;
            List<Join> joins = path.getElements();
            int joinCount = joins.size();
            for (Relation relation : relations) {
                join = joins.get(depth);
                if (depth >= joinCount || !relation.equals(join.getRelation())) {
                    return null;
                }
                ++depth;
            }
            if (depth >= relations.size()) break block3;
            relations = relations.subList(depth, relations.size());
            Iterator<Object> iterator = path.getPaths().iterator();
            while (iterator.hasNext() && (join = this.findJoinImpl(subPath = (JoinPath)iterator.next(), relations)) == null) {
            }
        }
        return join;
    }

    public void normalize() {
        int size;
        for (JoinPath subPath : this.getPaths()) {
            subPath.normalize();
        }
        while ((size = this.getElements().size()) > 1) {
            Join last = this.getElements().get(size - 1);
            JoinPath path = new JoinPath(last, new ArrayList<JoinPath>(this.getPaths()));
            this.getElements().remove(size - 1);
            this.getPaths().clear();
            this.getPaths().add(path);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Join join : this.getElements()) {
            buf.append(" * ").append(join);
        }
        for (JoinPath subPath : this.getPaths()) {
            buf.append(" [ ").append(subPath).append(" ]");
        }
        return buf.toString();
    }
}

