// wurblet generated by Wurbelizer 11.3.1.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder [--from]] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> generate code according to the builder pattern.</li>
 * <li><em>--equals:</em> generate the equals method.</li>
 * <li><em>--hashCode:</em> generate the hashCode method.</li>
 * <li><em>--validate[=&lt;code&gt;]:</em> perform validation after construction.
 * Requires that the DTO implements <code>Validateable</code>.
 * If the optional &lt;code&gt; is missing, the default <code>"ValidationUtilities.getInstance().validate(this)"</code> will be used.
 * </li>
 * <li><em>--names:</em> generate the name constants for all properties.</li>
 * <li><em>--from:</em> only if --builder set: generate method to create a builder from instance. This will automatically
 * happen if the '+' option at set for at least one property.</li>
 * <li><em>--nott:</em> generate generic code that does not need any Tentackle dependency (such as TentackleRuntimeException)</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed with "!" are considered as required and a (Tentackle)RuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * For lines prefixed with "+" a from-Method is generated that creates a new DTO from the current one by replacing the given property.
 * <pre>
 * +String name   the name
 * </pre>
 * This would create an instance method "fromName(String name)" that returns a new DTO instance.
 * <p>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * Can also be written as:
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20), &#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be removed from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 * <p>
 * Important: if <code>--equals</code> or <code>--hashCode</code> is given in a subclass, all superclasses must
 * get those options as well!
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String exceptionName = nott ? "RuntimeException" : "TentackleRuntimeException";

    if (withNames) {
      // create name constants
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[0]); // 98:2 = "  /** property name for "
          out.print(property.getComment());
          out.print(source[1]); // 99:49 = ". */  public static final String "
          out.print(property.getConstant());
          out.print(source[2]); // 100:55 = " = ""
          out.print(property.getName());
          out.print(source[3]); // 100:81 = "";"
        }
      }
    }

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        String decl = "private";
        if (!property.isMutable()) {
          decl += " final";
        }
        else if (property.isTransient()) {
          decl += " transient";
        }
        out.print(source[4]); // 117:2 = "  "
        out.print(decl);
        out.print(source[5]); // 118:10 = " "
        out.print(property.getType());
        out.print(source[6]); // 118:33 = " "
        out.print(property.getName());
        out.print(source[7]); // 118:56 = ";  // "
        out.print(property.getComment());
        out.print(source[8]); // 118:87 = ""
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[9]); // 125:2 = ""
      if (!withBuilder) {
        out.print(source[10]); // 129:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[11]); // 131:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[12]); // 136:2 = "   * @param "
            out.print(property.getName());
            out.print(source[13]); // 137:35 = " "
            out.print(property.getComment());
            out.print(source[14]); // 137:61 = ""
          }
        }
        out.print(source[15]); // 141:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[16]); // 168:2 = "  protected "
        out.print(getClassName());
        out.print(source[17]); // 169:30 = "(Builder builder) {"
        if (superClass != null) {
          out.print(source[18]); // 172:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            if (property.isRequired()) {
              out.print(source[19]); // 179:2 = "    if (!builder."
              out.print(property.getName());
              out.print(source[20]); // 180:39 = "Provided) {      throw new "
              out.print(exceptionName);
              out.print(source[21]); // 181:33 = "(""
              out.print(property.getName());
              out.print(source[22]); // 181:57 = " is required");    }"
            }
            out.print(source[23]); // 185:2 = "    this."
            out.print(property.getName());
            out.print(source[24]); // 186:31 = " = builder."
            out.print(property.getName());
            out.print(source[25]); // 186:64 = ";"
          }
        }
        if (validate != null) {
          out.print(source[26]); // 191:2 = "    "
          out.print(validate);
          out.print(source[27]); // 192:16 = ";"
        }
        out.print(source[28]); // 195:2 = "  }"
      }
      else {
        out.print(source[29]); // 200:2 = "  public "
        out.print(getClassName());
        out.print(source[30]); // 201:27 = "("
        out.print(args.toString());
        out.print(source[31]); // 201:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[32]); // 204:2 = "    super("
          out.print(superArgs);
          out.print(source[33]); // 205:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[34]); // 210:2 = "    this."
            out.print(property.getName());
            out.print(source[35]); // 211:31 = " = "
            out.print(property.getName());
            out.print(source[36]); // 211:56 = ";"
          }
        }
        if (validate != null) {
          out.print(source[37]); // 216:2 = "    "
          out.print(validate);
          out.print(source[38]); // 217:16 = ";"
        }
        out.print(source[39]); // 220:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[40]); // 229:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[41]); // 232:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[42]); // 234:39 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[43]); // 238:2 = "  "
          out.print(anno);
          out.print(source[44]); // 239:10 = ""
        }
        out.print(source[45]); // 242:2 = "  public "
        out.print(property.getType());
        out.print(source[46]); // 243:31 = " "
        out.print(property.getGetterName());
        out.print(source[47]); // 243:60 = "() {    return "
        out.print(property.getName());
        out.print(source[48]); // 244:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[49]); // 253:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[50]); // 256:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[51]); // 258:35 = " "
        out.print(property.getComment());
        out.print(source[52]); // 258:61 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[53]); // 262:2 = "  "
          out.print(anno);
          out.print(source[54]); // 263:10 = ""
        }
        out.print(source[55]); // 266:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[56]); // 267:42 = "("
        out.print(property.getType());
        out.print(source[57]); // 267:65 = " "
        out.print(property.getName());
        out.print(source[58]); // 267:88 = ") {    this."
        out.print(property.getName());
        out.print(source[59]); // 268:31 = " = "
        out.print(property.getName());
        out.print(source[60]); // 268:56 = ";  }"
      }
    }

    // create "from" methods
    for (Property property: properties) {
      if (property.isWithFrom()) {
        out.print(source[61]); // 277:2 = "  /**   * Create copy with "
        out.print(property.getComment());
        out.print(source[62]); // 280:47 = " from given "
        out.print(property.getName());
        out.print(source[63]); // 280:81 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[64]); // 282:35 = " "
        out.print(property.getComment());
        out.print(source[65]); // 282:61 = "   * @return the copied "
        out.print(getClassName());
        out.print(source[66]); // 283:43 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[67]); // 287:2 = "  "
          out.print(anno);
          out.print(source[68]); // 288:10 = ""
        }
        out.print(source[69]); // 291:2 = "  public "
        out.print(getClassName());
        out.print(source[70]); // 292:27 = " "
        out.print(property.getFromName());
        out.print(source[71]); // 292:54 = "("
        out.print(property.getType());
        out.print(source[72]); // 292:77 = " "
        out.print(property.getName());
        out.print(source[73]); // 292:100 = ") {"
        if (withBuilder) {
          if (property.isMutable()) {
            out.print(source[74]); // 296:2 = "    "
            out.print(getClassName());
            out.print(source[75]); // 297:22 = " object = toBuilder().build();    objec..."
            out.print(property.getSetterName());
            out.print(source[76]); // 298:39 = "("
            out.print(property.getName());
            out.print(source[77]); // 298:62 = ");    return object;"
          }
          else {
            out.print(source[78]); // 303:2 = "    return toBuilder()."
            out.print(property.getName());
            out.print(source[79]); // 304:45 = "("
            out.print(property.getName());
            out.print(source[80]); // 304:68 = ").build();"
          }
        }
        else {
          StringBuilder argBuf = new StringBuilder();
          for (Property prop: properties) {
            if (argBuf.length() > 0) {
              argBuf.append(", ");
            }
            if (prop == property) {
              argBuf.append(prop.getName());
            }
            else {
              if (prop.isInherited()) {
                argBuf.append(prop.getGetterName() + "()");
              }
              else {
                argBuf.append("this." + prop.getName());
              }
            }
          }
          out.print(source[81]); // 326:2 = "    return new "
          out.print(getClassName());
          out.print(source[82]); // 327:33 = "("
          out.print(argBuf);
          out.print(source[83]); // 327:44 = ");"
        }
        out.print(source[84]); // 330:2 = "  }"
      }
    }

    if (withEquals) {
      out.print(source[85]); // 337:2 = "  @Override  public boolean equals(Obj..."
      if (superClass != null) {
        out.print(source[86]); // 352:2 = "    if (!super.equals(obj)) {      retu..."
      }
      out.print(source[87]); // 358:2 = "    "
      out.print(getClassName());
      out.print(source[88]); // 359:22 = " other = ("
      out.print(getClassName());
      out.print(source[89]); // 359:50 = ") obj;"
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[90]); // 364:2 = "    if ("
            out.print(property.getName());
            out.print(source[91]); // 365:30 = " != other."
            out.print(property.getName());
            out.print(source[92]); // 365:62 = ") {      return false;    }"
          }
          else  {
            out.print(source[93]); // 371:2 = "    if (!Objects.equals("
            out.print(property.getName());
            out.print(source[94]); // 372:46 = ", other."
            out.print(property.getName());
            out.print(source[95]); // 372:76 = ")) {      return false;    }"
          }
        }
      }
      out.print(source[96]); // 379:2 = "    return true;  }"
    }


    if (withHashCode) {
      out.print(source[97]); // 387:2 = "  @Override  public int hashCode() {"
      if (superClass != null) {
        out.print(source[98]); // 393:2 = "    int hash = super.hashCode();"
      }
      else {
        out.print(source[99]); // 398:2 = "    int hash = 7;"
      }
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[100]); // 404:2 = "    hash = 79 * hash + "
          out.print(property.getHashCodeInvocation());
          out.print(source[101]); // 405:59 = ";"
        }
      }
      out.print(source[102]); // 409:2 = "    return hash;  }"
    }

    if (withBuilder) {
      String extendsStr = "";
      if (superClass != null) {
        extendsStr = "extends " + superClass + ".Builder ";
      }
      out.print(source[103]); // 420:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[104]); // 424:33 = " builder.   *   * @return the builder..."
      if (withFrom) {
        out.print(source[105]); // 433:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[106]); // 436:33 = " builder from current object.   *   * ..."
      if (superClass != null) {
        out.print(source[107]); // 442:2 = "  @Override"
      }
      out.print(source[108]); // 446:2 = "  public Builder toBuilder() {    retur..."
      }
      out.print(source[109]); // 452:2 = "  /**   * The "
      out.print(getClassName());
      out.print(source[110]); // 455:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[111]); // 457:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[112]); // 462:2 = "    private "
          out.print(property.getType());
          out.print(source[113]); // 463:34 = " "
          out.print(property.getName());
          out.print(source[114]); // 463:57 = ";  // "
          out.print(property.getComment());
          out.print(source[115]); // 463:88 = ""
          if (property.isRequired()) {
            out.print(source[116]); // 466:2 = "    private boolean "
            out.print(property.getName());
            out.print(source[117]); // 467:42 = "Provided;  // true if "
            out.print(property.getComment());
            out.print(source[118]); // 467:89 = " was provided"
          }
        }
      }
      out.print(source[119]); // 472:2 = "    protected Builder() {}"
      if (withFrom) {
        out.print(source[120]); // 477:2 = "    protected Builder("
        out.print(getClassName());
        out.print(source[121]); // 479:40 = " template) {"
        if (superClass != null) {
          out.print(source[122]); // 482:2 = "      super(template);"
        }
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[123]); // 488:2 = "      "
            out.print(property.getName());
            out.print(source[124]); // 489:28 = "(template."
            out.print(property.getGetterName());
            out.print(source[125]); // 489:66 = "());"
          }
        }
        out.print(source[126]); // 493:2 = "    }"
      }

      out.print(source[127]); // 498:2 = "    /**     * Builds a "
      out.print(getClassName());
      out.print(source[128]); // 501:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[129]); // 503:38 = "     */"
      if (superClass != null) {
        out.print(source[130]); // 507:2 = "    @Override"
      }
      out.print(source[131]); // 511:2 = "    public "
      out.print(getClassName());
      out.print(source[132]); // 512:29 = " build() {"
      if (isAbstract()) {
        out.print(source[133]); // 515:2 = "      throw new "
        out.print(exceptionName);
        out.print(source[134]); // 516:33 = "("cannot build abstract "
        out.print(getClassName());
        out.print(source[135]); // 516:75 = "");"
      }
      else {
        out.print(source[136]); // 520:2 = "      return new "
        out.print(getClassName());
        out.print(source[137]); // 521:35 = "(this);"
      }
      out.print(source[138]); // 524:2 = "    }"

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[139]); // 530:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[140]); // 533:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[141]); // 535:37 = " "
          out.print(property.getComment());
          out.print(source[142]); // 535:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[143]); // 538:41 = "("
          out.print(property.getType());
          out.print(source[144]); // 538:64 = " "
          out.print(property.getName());
          out.print(source[145]); // 538:87 = ") {      this."
          out.print(property.getName());
          out.print(source[146]); // 539:33 = " = "
          out.print(property.getName());
          out.print(source[147]); // 539:58 = ";"
        if (property.isRequired()) {
          out.print(source[148]); // 542:2 = "      "
          out.print(property.getName());
          out.print(source[149]); // 543:28 = "Provided = true;"
        }
        out.print(source[150]); // 546:2 = "      return this;    }"
        }
      }
      out.print(source[151]); // 552:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
