/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

public class AnnotationOption {
    private final String annotation;
    private boolean setterOnly;
    private boolean setterAndGetter;
    private boolean hidden;

    public AnnotationOption(String annotation) {
        Modifier modifier;
        if (((String)annotation).length() > 2 && (modifier = this.toModifier(((String)annotation).charAt(1))) != null) {
            annotation = "@" + ((String)annotation).substring(2);
            this.applyModifier(modifier);
            if (((String)annotation).length() > 2 && (modifier = this.toModifier(((String)annotation).charAt(1))) != null) {
                annotation = "@" + ((String)annotation).substring(2);
                this.applyModifier(modifier);
            }
        }
        this.annotation = annotation;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public boolean isSetterOnly() {
        return this.setterOnly;
    }

    public boolean isSetterAndGetter() {
        return this.setterAndGetter;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private Modifier toModifier(char c) {
        switch (c) {
            case '=': {
                return Modifier.SETTER_ONLY;
            }
            case '+': {
                return Modifier.SETTER_AND_GETTER;
            }
            case '~': {
                return Modifier.HIDDEN;
            }
        }
        return null;
    }

    private void applyModifier(Modifier modifier) {
        switch (modifier) {
            case HIDDEN: {
                this.hidden = true;
                break;
            }
            case SETTER_ONLY: {
                this.setterOnly = true;
                break;
            }
            case SETTER_AND_GETTER: {
                this.setterAndGetter = true;
            }
        }
    }

    private static enum Modifier {
        SETTER_ONLY,
        SETTER_AND_GETTER,
        HIDDEN;

    }
}

