/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendFactory;
import org.tentackle.sql.DataType;
import org.tentackle.wurblet.ComponentInfo;
import org.tentackle.wurblet.TentackleWurbletsModel;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelTerminationException;
import org.wurbelizer.wurblet.AbstractJavaWurblet;

public class ModelWurblet
extends AbstractJavaWurblet {
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\s*([\\w\\.]+)\\.class");
    private String modelDirName;
    private List<String> otherModelDirNames;
    private String modelName;
    private ModelDefaults modelDefaults;
    private Entity entity;
    private List<String> args;
    private List<String> optionArgs;
    private List<String> wurbletArgs;
    private Boolean isPdo;
    private boolean isInterface;
    private boolean remote;
    private String pdoClassName;
    private boolean missingModelOk;
    private Collection<Backend> backends;

    public String getModelDirName() {
        return this.modelDirName;
    }

    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    public String getPdoClassName() throws WurbelException {
        if (this.isPdo == null) {
            int ndx;
            String annotation;
            this.isPdo = false;
            int ndx2 = 0;
            while ((annotation = this.getContainer().getProperty("wurblet", "annotation_" + ndx2)) != null) {
                if (annotation.startsWith("@DomainObjectService") || annotation.startsWith("@PersistentObjectService")) {
                    Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
                    if (matcher.find()) {
                        this.pdoClassName = matcher.group(1);
                        if (this.getContainer().getVerbosity().isDebug()) {
                            this.getContainer().getLogger().info("pdoClassName: " + this.pdoClassName);
                        }
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                    throw new WurbelException("malformed annotation: " + annotation);
                }
                ++ndx2;
            }
            String persistentIface = this.getContainer().getProperty("wurblet", "extends_0");
            if (persistentIface != null && (ndx = persistentIface.indexOf(60)) > 0 && (ndx = (persistentIface = persistentIface.substring(ndx + 1)).lastIndexOf(62)) > 0) {
                this.pdoClassName = persistentIface.substring(0, ndx);
                if (this.pdoClassName.length() > 1 && this.pdoClassName.indexOf(60) < 0) {
                    this.isPdo = true;
                    this.isInterface = true;
                    return this.pdoClassName;
                }
            }
            this.pdoClassName = this.getContainer().getProperty("wurblet", "definition");
            if (this.pdoClassName != null) {
                if (this.getContainer().getVerbosity().isDebug()) {
                    this.getContainer().getLogger().info(this.getContainer().getProperty("wurblet", "classname") + ": definition = '" + this.pdoClassName + "'");
                }
                if ((ndx = this.pdoClassName.indexOf("extends")) >= 0) {
                    int ndx1 = this.pdoClassName.indexOf(60);
                    int ndx22 = this.pdoClassName.indexOf(44);
                    if (ndx1 > ndx && ndx22 > ndx1) {
                        this.pdoClassName = this.pdoClassName.substring(ndx1 + 1, ndx22).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
                if ((ndx = this.pdoClassName.indexOf("T extends")) >= 0) {
                    this.pdoClassName = this.pdoClassName.substring(ndx + 9);
                    ndx = this.pdoClassName.indexOf(60);
                    if (ndx > 0) {
                        this.pdoClassName = this.pdoClassName.substring(0, ndx).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
            }
        }
        if (this.isPdo.booleanValue()) {
            return this.pdoClassName;
        }
        this.pdoClassName = this.getContainer().getProperty("wurblet", "interfacename");
        if (this.pdoClassName != null) {
            return this.pdoClassName;
        }
        throw new WurbelException("cannot determine the pdo-class from the java-source");
    }

    public boolean isPdo() {
        if (this.isPdo == null) {
            try {
                this.getPdoClassName();
            }
            catch (WurbelException wurbelException) {
                // empty catch block
            }
        }
        return this.isPdo;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isPartOfInheritanceHierarchy() {
        return this.isPdo() && this.getEntity().getTopSuperEntity().isAbstract();
    }

    public boolean isGenerified() {
        String definition = this.getContainer().getProperty("wurblet", "definition");
        return definition != null && definition.startsWith("<");
    }

    public String getMethodName() throws WurbelException {
        String methodName = this.getOption("method");
        if (methodName == null) {
            methodName = this.getGuardName();
        }
        return methodName;
    }

    public String getModelName() throws WurbelException {
        if (this.modelName == null) {
            this.modelName = this.getOption("model");
            if (this.modelName == null) {
                this.modelName = this.getPdoClassName();
            }
            if (this.modelName == null) {
                throw new WurbelException("model not specified");
            }
        }
        return this.modelName;
    }

    public String deriveClassNameForEntity(Entity otherEntity) throws WurbelException {
        String entityName;
        String className = this.getClassName();
        int ndx = className.indexOf(entityName = this.getEntity().getName());
        if (ndx < 0) {
            throw new WurbelException(className + " does not contain the entity name '" + entityName + "' substring");
        }
        String lead = className.substring(0, ndx);
        String tail = className.substring(ndx + entityName.length());
        return lead + otherEntity.getName() + tail;
    }

    public List<Entity> orderByInheritanceLevelAndClassId(List<Entity> entities) {
        entities.sort(Comparator.comparingInt(ModelElement::getOrdinal).thenComparingInt(Entity::getClassId));
        return entities;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getOptionArgs() {
        return this.optionArgs;
    }

    public String getOption(String option) {
        int equalsOffset = option.length();
        for (String arg : this.getOptionArgs()) {
            if (arg.equals(option)) {
                return "";
            }
            if (!arg.startsWith(option) || arg.charAt(equalsOffset) != '=') continue;
            return arg.substring(equalsOffset + 1);
        }
        return null;
    }

    public List<String> getWurbletArgs() {
        return this.wurbletArgs;
    }

    public String createRelationSelectMethodName(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("select");
        if (relation.getMethodName() != null) {
            if (relation.getRelationType() == RelationType.LIST) {
                text.append("By");
            }
            text.append(relation.getMethodName());
        } else if (relation.getRelationType() == RelationType.LIST) {
            text.append("By");
            for (MethodArgument arg : relation.getMethodArgs()) {
                text.append(StringHelper.firstToUpper((String)arg.getForeignAttribute().getName()));
            }
        } else if (relation.isSelectionCached()) {
            text.append("Cached");
        }
        return text.toString();
    }

    public String createListRelationDeleteMethodName(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("deleteBy");
        if (relation.getMethodName() != null) {
            text.append(relation.getMethodName());
        } else {
            for (MethodArgument arg : relation.getMethodArgs()) {
                text.append(StringHelper.firstToUpper((String)arg.getForeignAttribute().getName()));
            }
        }
        return text.toString();
    }

    public String createDeclaredArgsForSelectOrDeleteMethod(Relation relation) throws ModelException {
        StringBuilder text = new StringBuilder();
        for (MethodArgument arg : relation.getMethodArgs()) {
            if (text.length() > 0) {
                text.append(", ");
            }
            Attribute attr = arg.getForeignAttribute();
            text.append(attr.getJavaType()).append(' ').append(attr.getName());
        }
        return text.toString();
    }

    public DataType<?> getEffectiveDataType(Attribute attribute) throws WurbelException {
        try {
            return attribute.getEffectiveDataType();
        }
        catch (ModelException e) {
            throw new WurbelException("cannot determine effective datatype for " + attribute, (Throwable)e);
        }
    }

    public String getColumnName(Attribute attribute, int columnIndex) throws WurbelException {
        try {
            return columnIndex < 0 ? attribute.getColumnName() : attribute.getColumnName(columnIndex);
        }
        catch (ModelException e) {
            throw new WurbelException("cannot determine columnname for " + attribute + ", index " + columnIndex, (Throwable)e);
        }
    }

    public String getColumnNameConstant(Attribute attribute, int columnIndex) throws WurbelException {
        return "CN_" + (attribute.getName() + (columnIndex < 0 ? "" : this.getEffectiveDataType(attribute).getColumnSuffix(columnIndex).orElse(""))).toUpperCase();
    }

    public void run() throws WurbelException {
        ModelException mex;
        WurbelException wex;
        Object wex2;
        Model model;
        File modelDir;
        block37: {
            String wurbletOptions = this.getConfiguration();
            if (wurbletOptions != null && wurbletOptions.contains("missingModelOk")) {
                this.missingModelOk = true;
            }
            super.run();
            this.args = Arrays.asList(this.container.getArgs());
            this.wurbletArgs = new ArrayList<String>();
            this.optionArgs = new ArrayList<String>();
            for (String arg : this.args) {
                if (arg == null) continue;
                if (arg.startsWith("--")) {
                    this.optionArgs.add(arg.substring(2));
                    continue;
                }
                this.wurbletArgs.add(arg);
            }
            this.modelDirName = this.getContainer().getProperty("extra", "model");
            if (this.modelDirName == null) {
                throw new WurbelException("missing wurblet property 'model'");
            }
            modelDir = new File(this.modelDirName);
            if (!modelDir.exists()) {
                this.getContainer().getLogger().info("creating " + modelDir);
                modelDir.mkdirs();
            }
            if (!modelDir.isDirectory()) {
                throw new WurbelException(modelDir + " is not a directory");
            }
            String otherModels = this.getContainer().getProperty("extra", "otherModels");
            if (otherModels != null) {
                this.otherModelDirNames = new ArrayList<String>();
                StringTokenizer stok = new StringTokenizer(otherModels, " \t\n\r\f,");
                while (stok.hasMoreTokens()) {
                    this.otherModelDirNames.add(stok.nextToken());
                }
            }
            String backendsProperty = this.getContainer().getProperty("extra", "backends");
            this.backends = new ArrayList<Backend>();
            if (backendsProperty != null) {
                if ("all".equalsIgnoreCase(backendsProperty)) {
                    this.backends.addAll(BackendFactory.getInstance().getAllBackends());
                } else if (!"none".equalsIgnoreCase(backendsProperty)) {
                    for (String backend : backendsProperty.split(",")) {
                        this.backends.add(BackendFactory.getInstance().getBackendByName(backend.trim()));
                    }
                }
                Model.getInstance().getEntityFactory().setBackends(this.backends);
            }
            this.modelDefaults = null;
            String modelDefaultsStr = this.getContainer().getProperty("extra", "modelDefaults");
            if (modelDefaultsStr != null) {
                try {
                    this.modelDefaults = new ModelDefaults(modelDefaultsStr);
                }
                catch (ModelException mex2) {
                    throw new WurbelException(mex2.getMessage(), (Throwable)mex2);
                }
            }
            EntityAliases entityAliases = null;
            String entityAliasesStr = this.getContainer().getProperty("extra", "entityAliases");
            if (entityAliasesStr != null) {
                try {
                    entityAliases = new EntityAliases(entityAliasesStr);
                }
                catch (ModelException mex3) {
                    throw new WurbelException(mex3.getMessage(), (Throwable)mex3);
                }
            }
            model = Model.getInstance();
            try {
                if (this.otherModelDirNames != null) {
                    for (String otherModelDirName : this.otherModelDirNames) {
                        model.loadModel(otherModelDirName, this.modelDefaults, entityAliases);
                    }
                }
                model.loadModel(this.modelDirName, this.modelDefaults, entityAliases);
            }
            catch (ModelException mex4) {
                wex2 = new WurbelTerminationException("errors in model loaded from directory '" + this.modelDirName + "'", true, (Throwable)mex4);
                if (model instanceof TentackleWurbletsModel && mex4.getElement() != null && ((TentackleWurbletsModel)model).getLoadingException() == null) {
                    ((TentackleWurbletsModel)model).setLoadingException((WurbelException)((Object)wex2));
                }
                throw wex2;
            }
            try {
                if (this.getModelName().indexOf(File.separatorChar) >= 0) {
                    try {
                        this.entity = model.loadByFilePath(new File(this.getModelName()).getCanonicalPath(), this.modelDefaults, entityAliases);
                        break block37;
                    }
                    catch (IOException ex) {
                        throw new ModelException("cannot determine canonical path of model " + this.getModelName(), (Throwable)ex);
                    }
                }
                this.entity = model.getByEntityName(this.getModelName());
            }
            catch (ModelException mex5) {
                throw new WurbelTerminationException("errors in model loaded from file '" + this.getModelName() + "'", (Throwable)mex5);
            }
        }
        if (this.entity == null && !this.missingModelOk) {
            Throwable delayedModelException = null;
            if (model instanceof TentackleWurbletsModel && (wex2 = ((TentackleWurbletsModel)model).getLoadingException()) != null) {
                delayedModelException = wex2.getCause();
            }
            throw new WurbelTerminationException("no such entity '" + this.getModelName() + "' in model " + modelDir, delayedModelException);
        }
        if (this.entity != null) {
            this.remote = this.entity.getOptions().isRemote();
        } else if (this.modelDefaults != null && this.modelDefaults.getRemote() != null) {
            this.remote = this.modelDefaults.getRemote();
        }
        if (this.getOption("remote") != null) {
            this.remote = true;
        }
        if (this.getOption("noremote") != null) {
            this.remote = false;
        }
        if (model instanceof TentackleWurbletsModel && this.entity != null && (wex = ((TentackleWurbletsModel)model).getLoadingException()) != null && wex.getCause() instanceof ModelException && (mex = (ModelException)wex.getCause()).isRelatedTo((ModelElement)this.entity)) {
            throw wex;
        }
    }

    public Collection<Backend> getBackends() {
        return this.backends;
    }

    public void assertSupportedByBackends(String feature, Function<Backend, Boolean> backendValidator) throws WurbelException {
        HashMap<Backend, String> result = new HashMap<Backend, String>();
        for (Backend backend : this.getBackends()) {
            try {
                if (!Boolean.FALSE.equals(backendValidator.apply(backend))) continue;
                result.put(backend, "");
            }
            catch (RuntimeException rx) {
                String msg = rx.getMessage();
                result.put(backend, msg == null ? "" : msg);
            }
        }
        if (result.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        StringBuilder detailMsg = new StringBuilder();
        msg.append(feature).append(" not supported by ");
        boolean needComma = false;
        for (Map.Entry entry : result.entrySet()) {
            if (needComma) {
                msg.append(", ");
            } else {
                needComma = true;
            }
            msg.append(entry.getKey());
            if (((String)entry.getValue()).isBlank()) continue;
            detailMsg.append('\n').append(entry.getKey()).append(": ").append((String)entry.getValue());
        }
        msg.append((CharSequence)detailMsg);
        throw new WurbelException(msg.toString());
    }

    public boolean isIdAttribute(Attribute attribute) {
        return attribute.getName().equals("id");
    }

    public boolean isSerialAttribute(Attribute attribute) {
        return attribute.getName().equals("serial");
    }

    public boolean isIdOrSerialAttribute(Attribute attribute) {
        return this.isIdAttribute(attribute) || this.isSerialAttribute(attribute);
    }

    public boolean isAttributeDerived(Attribute attribute) {
        return attribute.getOptions().isFromSuper() || attribute.getEntity() != this.entity;
    }

    public void appendCommaSeparated(StringBuilder builder, String appendStr) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(appendStr);
    }

    public void prependCommaSeparated(StringBuilder builder, String prependStr) {
        if (builder.length() > 0) {
            builder.insert(0, ", ");
        }
        builder.insert(0, prependStr);
    }

    public ComponentInfo createComponentInfo(Entity component) throws WurbelException {
        return new ComponentInfo(this, component);
    }
}

