// wurblet generated by Wurbelizer 11.3.1.1, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [options] &lt;filename&gt;
 * <p>
 * <ul>
 * <li><em>--builder:</em> generate code according to the builder pattern.</li>
 * <li><em>--equals:</em> generate the equals method.</li>
 * <li><em>--hashCode:</em> generate the hashCode method.</li>
 * <li><em>--validate[=&lt;code&gt;]:</em> perform validation after construction.
 * Requires that the DTO implements <code>Validateable</code>.
 * If the optional &lt;code&gt; is missing, the default <code>"ValidationUtilities.getInstance().validate(this)"</code> will be used.
 * </li>
 * <li><em>--names:</em> generate the name constants for all properties.</li>
 * <li><em>--from:</em> only if --builder set: generate method to create a builder from instance. This will automatically
 * happen if the '+' option is set for at least one property.</li>
 * <li><em>--with:</em> same as <code>--from</code>, but the generated methods are prefixed by "with" instead of "from".
 * In TT, the default is to use "frommers" instead of "withers", since builder implementations exist in the wild
 * that use withers for builder methods (which return the builder and not the object to be built!). This may be confusing.
 * TT supports both, though.</li>
 * <li><em>--nott:</em> generate generic code that does not need any Tentackle dependency (such as TentackleRuntimeException)</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed by "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed by "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed by "!" are considered as required and a (Tentackle)RuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * For lines prefixed by "+" a from-Method is generated that creates a new DTO from the current one by replacing the given property.
 * If the option --with is set, the methods are prefixed by <code>with</code> (a.k.a. "withers").
 * <pre>
 * +String name   the name
 * </pre>
 * This would create an instance method "fromName(String name)" that returns a new DTO instance.
 * <p>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * Can also be written as:
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20), &#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be removed from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 * <p>
 * Important: if <code>--equals</code> or <code>--hashCode</code> is given in a subclass, all superclasses must
 * get those options as well!
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String exceptionName = nott ? "RuntimeException" : "TentackleRuntimeException";

    if (withNames) {
      // create name constants
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[0]); // 102:2 = "  /** property name for "
          out.print(property.getComment());
          out.print(source[1]); // 103:49 = ". */  public static final String "
          out.print(property.getConstant());
          out.print(source[2]); // 104:55 = " = ""
          out.print(property.getName());
          out.print(source[3]); // 104:81 = "";"
        }
      }
    }

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        String decl = "private";
        if (!property.isMutable()) {
          decl += " final";
        }
        else if (property.isTransient()) {
          decl += " transient";
        }
        out.print(source[4]); // 121:2 = "  "
        out.print(decl);
        out.print(source[5]); // 122:10 = " "
        out.print(property.getType());
        out.print(source[6]); // 122:33 = " "
        out.print(property.getName());
        out.print(source[7]); // 122:56 = ";  // "
        out.print(property.getComment());
        out.print(source[8]); // 122:87 = ""
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[9]); // 129:2 = ""
      if (!withBuilder) {
        out.print(source[10]); // 133:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[11]); // 135:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[12]); // 140:2 = "   * @param "
            out.print(property.getName());
            out.print(source[13]); // 141:35 = " "
            out.print(property.getComment());
            out.print(source[14]); // 141:61 = ""
          }
        }
        out.print(source[15]); // 145:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[16]); // 172:2 = "  protected "
        out.print(getClassName());
        out.print(source[17]); // 173:30 = "(Builder builder) {"
        if (superClass != null) {
          out.print(source[18]); // 176:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            if (property.isRequired()) {
              out.print(source[19]); // 183:2 = "    if (!builder."
              out.print(property.getName());
              out.print(source[20]); // 184:39 = "Provided) {      throw new "
              out.print(exceptionName);
              out.print(source[21]); // 185:33 = "(""
              out.print(property.getName());
              out.print(source[22]); // 185:57 = " is required");    }"
            }
            out.print(source[23]); // 189:2 = "    this."
            out.print(property.getName());
            out.print(source[24]); // 190:31 = " = builder."
            out.print(property.getName());
            out.print(source[25]); // 190:64 = ";"
          }
        }
        if (validate != null) {
          out.print(source[26]); // 195:2 = "    "
          out.print(validate);
          out.print(source[27]); // 196:16 = ";"
        }
        out.print(source[28]); // 199:2 = "  }"
      }
      else {
        out.print(source[29]); // 204:2 = "  public "
        out.print(getClassName());
        out.print(source[30]); // 205:27 = "("
        out.print(args.toString());
        out.print(source[31]); // 205:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[32]); // 208:2 = "    super("
          out.print(superArgs);
          out.print(source[33]); // 209:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[34]); // 214:2 = "    this."
            out.print(property.getName());
            out.print(source[35]); // 215:31 = " = "
            out.print(property.getName());
            out.print(source[36]); // 215:56 = ";"
          }
        }
        if (validate != null) {
          out.print(source[37]); // 220:2 = "    "
          out.print(validate);
          out.print(source[38]); // 221:16 = ";"
        }
        out.print(source[39]); // 224:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[40]); // 233:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[41]); // 236:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[42]); // 238:39 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[43]); // 242:2 = "  "
          out.print(anno);
          out.print(source[44]); // 243:10 = ""
        }
        out.print(source[45]); // 246:2 = "  public "
        out.print(property.getType());
        out.print(source[46]); // 247:31 = " "
        out.print(property.getGetterName());
        out.print(source[47]); // 247:60 = "() {    return "
        out.print(property.getName());
        out.print(source[48]); // 248:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[49]); // 257:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[50]); // 260:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[51]); // 262:35 = " "
        out.print(property.getComment());
        out.print(source[52]); // 262:61 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[53]); // 266:2 = "  "
          out.print(anno);
          out.print(source[54]); // 267:10 = ""
        }
        out.print(source[55]); // 270:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[56]); // 271:42 = "("
        out.print(property.getType());
        out.print(source[57]); // 271:65 = " "
        out.print(property.getName());
        out.print(source[58]); // 271:88 = ") {    this."
        out.print(property.getName());
        out.print(source[59]); // 272:31 = " = "
        out.print(property.getName());
        out.print(source[60]); // 272:56 = ";  }"
      }
    }

    // create "from" methods
    for (Property property: properties) {
      if (property.isWithFrom()) {
        out.print(source[61]); // 281:2 = "  /**   * Create copy with "
        out.print(property.getComment());
        out.print(source[62]); // 284:47 = " from given "
        out.print(property.getName());
        out.print(source[63]); // 284:81 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[64]); // 286:35 = " "
        out.print(property.getComment());
        out.print(source[65]); // 286:61 = "   * @return the copied "
        out.print(getClassName());
        out.print(source[66]); // 287:43 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[67]); // 291:2 = "  "
          out.print(anno);
          out.print(source[68]); // 292:10 = ""
        }
        out.print(source[69]); // 295:2 = "  public "
        out.print(getClassName());
        out.print(source[70]); // 296:27 = " "
        out.print(property.getFromName());
        out.print(source[71]); // 296:54 = "("
        out.print(property.getType());
        out.print(source[72]); // 296:77 = " "
        out.print(property.getName());
        out.print(source[73]); // 296:100 = ") {"
        if (withBuilder) {
          if (property.isMutable()) {
            out.print(source[74]); // 300:2 = "    "
            out.print(getClassName());
            out.print(source[75]); // 301:22 = " object = toBuilder().build();    objec..."
            out.print(property.getSetterName());
            out.print(source[76]); // 302:39 = "("
            out.print(property.getName());
            out.print(source[77]); // 302:62 = ");    return object;"
          }
          else {
            out.print(source[78]); // 307:2 = "    return toBuilder()."
            out.print(property.getName());
            out.print(source[79]); // 308:45 = "("
            out.print(property.getName());
            out.print(source[80]); // 308:68 = ").build();"
          }
        }
        else {
          StringBuilder argBuf = new StringBuilder();
          for (Property prop: properties) {
            if (argBuf.length() > 0) {
              argBuf.append(", ");
            }
            if (prop == property) {
              argBuf.append(prop.getName());
            }
            else {
              if (prop.isInherited()) {
                argBuf.append(prop.getGetterName() + "()");
              }
              else {
                argBuf.append("this." + prop.getName());
              }
            }
          }
          out.print(source[81]); // 330:2 = "    return new "
          out.print(getClassName());
          out.print(source[82]); // 331:33 = "("
          out.print(argBuf);
          out.print(source[83]); // 331:44 = ");"
        }
        out.print(source[84]); // 334:2 = "  }"
      }
    }

    if (withEquals) {
      out.print(source[85]); // 341:2 = "  @Override  public boolean equals(Obj..."
      if (superClass != null) {
        out.print(source[86]); // 356:2 = "    if (!super.equals(obj)) {      retu..."
      }
      out.print(source[87]); // 362:2 = "    "
      out.print(getClassName());
      out.print(source[88]); // 363:22 = " other = ("
      out.print(getClassName());
      out.print(source[89]); // 363:50 = ") obj;"
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[90]); // 368:2 = "    if ("
            out.print(property.getName());
            out.print(source[91]); // 369:30 = " != other."
            out.print(property.getName());
            out.print(source[92]); // 369:62 = ") {      return false;    }"
          }
          else  {
            out.print(source[93]); // 375:2 = "    if (!Objects.equals("
            out.print(property.getName());
            out.print(source[94]); // 376:46 = ", other."
            out.print(property.getName());
            out.print(source[95]); // 376:76 = ")) {      return false;    }"
          }
        }
      }
      out.print(source[96]); // 383:2 = "    return true;  }"
    }


    if (withHashCode) {
      out.print(source[97]); // 391:2 = "  @Override  public int hashCode() {"
      if (superClass != null) {
        out.print(source[98]); // 397:2 = "    int hash = super.hashCode();"
      }
      else {
        out.print(source[99]); // 402:2 = "    int hash = 7;"
      }
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[100]); // 408:2 = "    hash = 79 * hash + "
          out.print(property.getHashCodeInvocation());
          out.print(source[101]); // 409:59 = ";"
        }
      }
      out.print(source[102]); // 413:2 = "    return hash;  }"
    }

    if (withBuilder) {
      String extendsStr = "";
      if (superClass != null) {
        extendsStr = "extends " + superClass + ".Builder ";
      }
      out.print(source[103]); // 424:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[104]); // 428:33 = " builder.   *   * @return the builder..."
      if (withFrom) {
        out.print(source[105]); // 437:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[106]); // 440:33 = " builder from current object.   *   * ..."
      if (superClass != null) {
        out.print(source[107]); // 446:2 = "  @Override"
      }
      out.print(source[108]); // 450:2 = "  public Builder toBuilder() {    retur..."
      }
      out.print(source[109]); // 456:2 = "  /**   * The "
      out.print(getClassName());
      out.print(source[110]); // 459:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[111]); // 461:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[112]); // 466:2 = "    private "
          out.print(property.getType());
          out.print(source[113]); // 467:34 = " "
          out.print(property.getName());
          out.print(source[114]); // 467:57 = ";  // "
          out.print(property.getComment());
          out.print(source[115]); // 467:88 = ""
          if (property.isRequired()) {
            out.print(source[116]); // 470:2 = "    private boolean "
            out.print(property.getName());
            out.print(source[117]); // 471:42 = "Provided;  // true if "
            out.print(property.getComment());
            out.print(source[118]); // 471:89 = " was provided"
          }
        }
      }
      out.print(source[119]); // 476:2 = "    protected Builder() {}"
      if (withFrom) {
        out.print(source[120]); // 481:2 = "    protected Builder("
        out.print(getClassName());
        out.print(source[121]); // 483:40 = " template) {"
        if (superClass != null) {
          out.print(source[122]); // 486:2 = "      super(template);"
        }
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[123]); // 492:2 = "      "
            out.print(property.getName());
            out.print(source[124]); // 493:28 = "(template."
            out.print(property.getGetterName());
            out.print(source[125]); // 493:66 = "());"
          }
        }
        out.print(source[126]); // 497:2 = "    }"
      }

      out.print(source[127]); // 502:2 = "    /**     * Builds a "
      out.print(getClassName());
      out.print(source[128]); // 505:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[129]); // 507:38 = "     */"
      if (superClass != null) {
        out.print(source[130]); // 511:2 = "    @Override"
      }
      out.print(source[131]); // 515:2 = "    public "
      out.print(getClassName());
      out.print(source[132]); // 516:29 = " build() {"
      if (isAbstract()) {
        out.print(source[133]); // 519:2 = "      throw new "
        out.print(exceptionName);
        out.print(source[134]); // 520:33 = "("cannot build abstract "
        out.print(getClassName());
        out.print(source[135]); // 520:75 = "");"
      }
      else {
        out.print(source[136]); // 524:2 = "      return new "
        out.print(getClassName());
        out.print(source[137]); // 525:35 = "(this);"
      }
      out.print(source[138]); // 528:2 = "    }"

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[139]); // 534:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[140]); // 537:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[141]); // 539:37 = " "
          out.print(property.getComment());
          out.print(source[142]); // 539:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[143]); // 542:41 = "("
          out.print(property.getType());
          out.print(source[144]); // 542:64 = " "
          out.print(property.getName());
          out.print(source[145]); // 542:87 = ") {      this."
          out.print(property.getName());
          out.print(source[146]); // 543:33 = " = "
          out.print(property.getName());
          out.print(source[147]); // 543:58 = ";"
        if (property.isRequired()) {
          out.print(source[148]); // 546:2 = "      "
          out.print(property.getName());
          out.print(source[149]); // 547:28 = "Provided = true;"
        }
        out.print(source[150]); // 550:2 = "      return this;    }"
        }
      }
      out.print(source[151]); // 556:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
