// wurblet generated by Wurbelizer 17.3.2.2, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the database column names.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ColumnNames
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class ColumnNames extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    List<String> allColConst = null;
    boolean isSingleTableInheritance = getEntity().getTopSuperEntity().getInheritanceType() == InheritanceType.SINGLE;
    if (isSingleTableInheritance || isMuteOptionSet(getEntity())) {
      allColConst = new ArrayList<>();
      if (getEntity().getSuperEntity() == null) {
        for (Attribute attr: getEntity().getAllAttributes())  {
          if (attr.isImplicit()) {
            allColConst.add(getColumnNameConstant(attr, 0));
          }
        }
      }
    }

    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoConstant() && !attr.getOptions().isNoDeclare() && !attr.getOptions().isFromSuper()) {
        int columnCount = getEffectiveDataType(attr).getColumnCount();
        String baseColConst = getColumnNameConstant(attr, -1);

        for (int columnIndex = 0; columnIndex < columnCount; columnIndex++) {
          String colConst = getColumnNameConstant(attr, columnIndex);
          if (allColConst != null && !attr.getOptions().isMute()) {
            allColConst.add(colConst);
          }
          if (colConst.equals(baseColConst)) {
            baseColConst = null;
          }
          out.print(source[0]); // 39:2 = "  /** database column name for '"
          out.print(attr);
          out.print(source[1]); // 41:40 = "'"
          out.print(columnCount > 1 ? (", column " + (columnIndex+1) + " of " + columnCount) : "");
          out.print(source[2]); // 41:122 = ". */  public static final String "
          out.print(colConst);
          out.print(source[3]); // 42:41 = " = "
          out.print(StringHelper.toDoubleQuotes(getColumnName(attr, columnIndex)));
          out.print(source[4]); // 42:109 = ";"
        }
        if (baseColConst != null) {
          out.print(source[5]); // 46:2 = "  /** database column basename for '"
          out.print(attr);
          out.print(source[6]); // 48:44 = "'. */  public static final String "
          out.print(baseColConst);
          out.print(source[7]); // 49:45 = " = "
          out.print(StringHelper.toDoubleQuotes(getColumnName(attr, -1)));
          out.print(source[8]); // 49:104 = ";"
        }
      }
    }

    if (allColConst != null) {
      out.print(source[9]); // 56:2 = "  /** mapped columns for '"
      out.print(getEntity());
      out.print(source[10]); // 58:41 = "'. */  public static final List<String>..."
      out.print(getEntity().getName().toUpperCase());
      out.print(source[11]); // 59:78 = " = List.of("
      int i = 0;
      for (String colConst : allColConst) {
        out.print(source[12]); // 63:2 = "    "
        out.print(colConst);
        out.print(++i<allColConst.size()?",":"");
        out.print(source[13]); // 64:49 = ""
      }
      out.print(source[14]); // 67:2 = "  );"
    }
  }

  // ----------------- end wurblet code -----------------
}
