// wurblet generated by Wurbelizer 17.3.2.2, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate relation method definitions of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Relations
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class Relations extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {

    for (Relation rel: getEntity().getRelations()) {

      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }

      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String firstArg = rel.getMethodArgs().get(0).getMethodArgument();
      boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        // take from attribute
        hidden |= attr.isHidden();
        createGetter &= !attr.getOptions().isWriteOnly() && !hidden;
        createSetter &= !attr.getOptions().isReadOnly() && !hidden;
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      Relation oppRel = rel.getForeignRelation();

      // getter

      if (createGetter)  {
        String checkNull = firstArg + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = firstArg + " == null || " + checkNull;
        }
        out.print(source[0]); // 58:2 = "  /**   * Gets "
        out.print(rel);
        out.print(source[1]); // 61:17 = ".   *   * @return "
        out.print(var);
        out.print(source[2]); // 63:21 = " "
        out.print(rel.getComment());
        out.print(source[3]); // 63:42 = "   */  @Bindable"
        if (rel.isComposite()) {
          out.print(source[4]); // 68:2 = "  @Persistent(ordinal="
          out.print(rel.getOrdinal());
          out.print(source[5]); // 69:43 = ", comment="
          out.print(StringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[6]); // 69:102 = ")"
        }
        else {
          if (oppRel != null && oppRel.isComposite()) {
            out.print(source[7]); // 74:2 = "  @Persistent(ordinal="
            out.print(rel.getOrdinal());
            out.print(source[8]); // 75:43 = ", comment="
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[9]); // 75:102 = ", component=false, parent=true)"
          }
          else {
            out.print(source[10]); // 79:2 = "  @Persistent(ordinal="
            out.print(rel.getOrdinal());
            out.print(source[11]); // 80:43 = ", comment="
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[12]); // 80:102 = ", component=false)"
          }
        }
        for (String annotation: rel.getAnnotations()) {
          AnnotationOption anno = new AnnotationOption(annotation);
          if (!anno.isHidden() && !anno.isSetterOnly()) {
            out.print(source[13]); // 87:2 = "  "
            out.print(anno.getAnnotation());
            out.print(source[14]); // 88:26 = ""
          }
        }
        out.print(source[15]); // 92:2 = "  "
        out.print(type);
        out.print(source[16]); // 93:10 = " "
        out.print(rel.getGetterName());
        out.print(source[17]); // 93:34 = "();"
        if (rel.isBluntDeclared()) {
          out.print(source[18]); // 96:2 = "  /**   * Gets "
          out.print(var);
          out.print(source[19]); // 99:17 = " without performing a select if not load..."
          out.print(var);
          out.print(source[20]); // 101:21 = " "
          out.print(rel.getComment());
          out.print(source[21]); // 101:42 = "   */  "
          out.print(type);
          out.print(source[22]); // 103:10 = " "
          out.print(rel.getGetterName());
          out.print(source[23]); // 103:34 = "Blunt();"
        }

        if (nmRel != null) {
          out.print(source[24]); // 108:2 = "  /**   * Gets list of "
          out.print(nmRel.getDeclaredJavaType(false));
          out.print(source[25]); // 111:54 = " joined via "
          out.print(rel);
          out.print(source[26]); // 111:73 = ".   *   * @return list of "
          out.print(nmRel.getVariableName());
          out.print(source[27]); // 113:49 = "   */  @Bindable  @Persistent(ordinal..."
          out.print(rel.getOrdinal());
          out.print(source[28]); // 116:43 = ", comment="
          out.print(StringHelper.toDoubleQuotes(nmVar));
          out.print(source[29]); // 116:91 = ", component=false)  TrackedList<"
          out.print(nmRel.getDeclaredJavaType(false));
          out.print(source[30]); // 117:50 = "> get"
          out.print(nmName);
          out.print(source[31]); // 117:65 = "();"
        }

        if (rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
              out.print(source[32]); // 123:2 = "  /**   * Returns whether "
              out.print(rel.getName());
              out.print(source[33]); // 126:38 = " is loaded.   *   * @return true if "
              out.print(rel.getGetterName());
              out.print(source[34]); // 128:45 = "() invoked at least once   */  @Bindab..."
              out.print(StringHelper.firstToUpper(var));
              out.print(source[35]); // 131:46 = "Loaded();"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        boolean linkMethodIndexed = rel.getForeignRelation() != null ?
            rel.getForeignRelation().getLinkMethodIndex() != null : false;

            out.print(source[36]); // 142:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[37]); // 145:17 = ".   *   * @param "
            out.print(var);
            out.print(source[38]); // 147:20 = " "
            out.print(rel.getComment());
            out.print(source[39]); // 147:41 = ""
        if (linkMethodIndexed) {
          out.print(source[40]); // 150:2 = "   * @param index the index starting at ..."
        }
        out.print(source[41]); // 154:2 = "   */"
        if (attr != null && attr.getOptions().isBindable()) {
          out.print(source[42]); // 158:2 = "  "
          out.print(attr.getBindableAnnotation());
          out.print(source[43]); // 159:34 = ""
        }
        for (String annotation: rel.getAnnotations()) {
          AnnotationOption anno = new AnnotationOption(annotation);
          if (!anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
            out.print(source[44]); // 165:2 = "  "
            out.print(anno.getAnnotation());
            out.print(source[45]); // 166:26 = ""
          }
        }
        if (linkMethodIndexed) {
          out.print(source[46]); // 171:2 = "  void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[47]); // 172:55 = "("
          out.print(type);
          out.print(source[48]); // 172:64 = " "
          out.print(var);
          out.print(source[49]); // 172:72 = ", int index);"
        }
        else {
          out.print(source[50]); // 176:2 = "  void "
          out.print(rel.getSetterName());
          out.print(source[51]); // 177:30 = "("
          out.print(type);
          out.print(source[52]); // 177:39 = " "
          out.print(var);
          out.print(source[53]); // 177:47 = ");"
        }
      }
    }

    // creates the select- and delete-methods for list relations in foreign entities
    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());
    Set<String> declaredArgSet = new HashSet<>();   // to avoid duplicates if args= is used

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }
      if (rel.getRelationType() == RelationType.LIST) {
        Attribute attribute = rel.getForeignAttribute();
        if (attribute != null) {
          String declaredArgs = createDeclaredArgsForSelectOrDeleteMethod(rel);
          if (declaredArgSet.add(declaredArgs)) {
            out.print(source[54]); // 197:2 = "  /**   * Selects "
            out.print(rel);
            out.print(source[55]); // 200:20 = ".   *"
            for (MethodArgument arg : rel.getMethodArgs()) {
              Attribute attr = arg.getForeignAttribute();
              out.print(source[56]); // 205:2 = "   * @param "
              out.print(attr.getName());
              out.print(source[57]); // 206:31 = " "
              out.print(attr.getOptions().getComment());
              out.print(source[58]); // 206:66 = ""
            }
            out.print(source[59]); // 209:2 = "   * @return "
            out.print(rel.getComment());
            out.print(source[60]); // 210:34 = "   */  "
            out.print(rel.getDeclaredJavaType(true));
            out.print(source[61]); // 212:35 = " "
            out.print(createRelationSelectMethodName(rel));
            out.print(source[62]); // 212:75 = "("
            out.print(declaredArgs);
            out.print(source[63]); // 212:92 = ");"
            if (rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
              out.print(source[64]); // 215:2 = "  /**   * Deletes "
              out.print(rel);
              out.print(source[65]); // 218:20 = ".   *"
              for (MethodArgument arg : rel.getMethodArgs()) {
                Attribute attr = arg.getForeignAttribute();
                out.print(source[66]); // 223:2 = "   * @param "
                out.print(attr.getName());
                out.print(source[67]); // 224:31 = " "
                out.print(attr.getOptions().getComment());
                out.print(source[68]); // 224:66 = ""
              }
              out.print(source[69]); // 227:2 = "   * @return "
              out.print(rel.getComment());
              out.print(source[70]); // 228:34 = "   */  int "
              out.print(createListRelationDeleteMethodName(rel));
              out.print(source[71]); // 230:49 = "("
              out.print(declaredArgs);
              out.print(source[72]); // 230:66 = ");"
            }
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
