// wurblet generated by Wurbelizer 17.4.0.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;
import org.tentackle.sql.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the database column names.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ColumnNames
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class ColumnNames extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    List<String> allColConst = null;
    boolean isSingleTableInheritance = getEntity().getTopSuperEntity().getInheritanceType() == InheritanceType.SINGLE;
    if (isSingleTableInheritance || isMuteOptionSet(getEntity())) {
      allColConst = new ArrayList<>();
      if (getEntity().getSuperEntity() == null) {
        for (Attribute attr: getEntity().getAllAttributes())  {
          if (attr.isImplicit()) {
            allColConst.add(getColumnNameConstant(attr, 0));
          }
        }
      }
    }

    Map<Attribute, DataType<?>> bsAttrs = new LinkedHashMap<>();  // backend-specific attributes requires special handling
    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoConstant() && !attr.getOptions().isNoDeclare() && !attr.getOptions().isFromSuper()) {
        DataType<?> effectiveType = getEffectiveDataType(attr);
        String baseColConst = getColumnNameConstant(attr, -1);
        int columnCount;
        if (effectiveType.isColumnCountBackendSpecific()) {
          columnCount = 0;
          bsAttrs.put(attr, effectiveType);     // remember for later below...
        }
        else {
          columnCount = effectiveType.getColumnCount(null);
        }
        for (int columnIndex = 0; columnIndex < columnCount; columnIndex++) {
          String colConst = getColumnNameConstant(attr, columnIndex);
          if (allColConst != null && !attr.getOptions().isMute()) {
            allColConst.add(colConst);
          }
          if (colConst.equals(baseColConst)) {
            baseColConst = null;
          }
          out.print(source[0]); // 47:2 = "  /** database column name for '"
          out.print(attr);
          out.print(source[1]); // 49:40 = "'"
          out.print(columnCount > 1 ? (", column " + (columnIndex+1) + " of " + columnCount) : "");
          out.print(source[2]); // 49:122 = ". */  public static final String "
          out.print(colConst);
          out.print(source[3]); // 50:41 = " = "
          out.print(StringHelper.toDoubleQuotes(getColumnName(attr, columnIndex)));
          out.print(source[4]); // 50:109 = ";"
        }
        if (baseColConst != null) {
          out.print(source[5]); // 54:2 = "  /** database column basename for "
          out.print(effectiveType.isColumnCountBackendSpecific() ? "backend-specific " : "");
          out.print(source[6]); // 56:110 = "'"
          out.print(attr);
          out.print(source[7]); // 56:119 = "'. */  public static final String "
          out.print(baseColConst);
          out.print(source[8]); // 57:45 = " = "
          out.print(StringHelper.toDoubleQuotes(getColumnName(attr, -1)));
          out.print(source[9]); // 57:104 = ";"
        }
      }
    }

    if (allColConst != null) {
      out.print(source[10]); // 64:2 = "  /** backend-agnostic mapped columns. ..."
      int i = 0;
      for (String colConst : allColConst) {
        out.print(source[11]); // 71:2 = "    "
        out.print(colConst);
        out.print(++i<allColConst.size()?",":"");
        out.print(source[12]); // 72:49 = ""
      }
      out.print(source[13]); // 75:2 = "  );"
      if (!bsAttrs.isEmpty()) {
        out.print(source[14]); // 79:2 = "  /** backend-specific mapped columns. ..."
      }
      out.print(source[15]); // 85:2 = "  /**   * Returns all mapped columns f..."
      out.print(getEntity());
      out.print(source[16]); // 88:59 = "}.   *   * @param backend the backend..."
      if (bsAttrs.isEmpty()) {
        out.print(source[17]); // 96:2 = "    return MAPPED_COLUMNS;"
      }
      else {
        out.print(source[18]); // 101:2 = "    return BACKEND_COLUMNS_MAP.computeIf..."
        for (Map.Entry<Attribute, DataType<?>> entry : bsAttrs.entrySet()) {
          out.print(source[19]); // 107:2 = "      columnNames.addAll("
          out.print(entry.getValue().getDataTypeConstant());
          out.print(source[20]); // 108:67 = ".createColumnNames(b, "
          out.print(getColumnNameConstant(entry.getKey(), -1));
          out.print(source[21]); // 108:134 = "));"
        }
        out.print(source[22]); // 111:2 = "      return Collections.unmodifiableLis..."
      }
      out.print(source[23]); // 116:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
