// wurblet generated by Wurbelizer 17.4.0.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;
import org.tentackle.sql.*;

/**
 * <strong>({@code @wurblet})</strong> Generate domain method definitions.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DomainMethods
 * <p>
 * arguments:
 * <ul>
 * <li>--noif: if not part of an interface (adds "public static final")</li>
 * </ul>
 * For more options, see {@link ModelWurblet}.
 */
public class DomainMethods extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException, WurbelException {
    List<Attribute> udk = getEntity().getUniqueDomainKey();
    if (!udk.isEmpty()) {
      List<Attribute> superUdk = null;
      if (getEntity().getSuperEntity() != null) {
        superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
      }
      if (superUdk == null || !udk.equals(superUdk)) {
        out.print(source[0]); // 23:2 = "  @Override  public boolean isUniqueDom..."
        String returnType = isGenerified() ? "T" : getPdoClassName();
        if (udk.size() == 1) {
          Attribute attr = udk.get(0);
          String javaType = attr.getDataType().isPrimitive() ?
                                attr.getDataType().toNonPrimitive().toString() : attr.getJavaType();
                                out.print(source[1]); // 34:2 = "  @Override  public Class<?> getUnique..."
                                out.print(javaType);
                                out.print(source[2]); // 38:23 = ".class;  }  @Override  public "
                                out.print(returnType);
                                out.print(source[3]); // 42:23 = " findByUniqueDomainKey(Object domainKey)..."
                                out.print(udk.get(0).getJavaType());
                                out.print(source[4]); // 43:69 = ") domainKey);  }  @Override  public ..."
                                out.print(javaType);
                                out.print(source[5]); // 47:21 = " getUniqueDomainKey() {    return me()...."
                                out.print(udk.get(0).getGetterName());
                                out.print(source[6]); // 48:46 = "();  }  @Override  public void setUn..."
                                out.print(udk.get(0).getSetterName());
                                out.print(source[7]); // 53:39 = "(("
                                out.print(udk.get(0).getJavaType());
                                out.print(source[8]); // 53:69 = ") domainKey);  }"
        }
        else {
          StringBuilder params = new StringBuilder();
          for (Attribute attr: udk) {
            appendCommaSeparated(params, "udk.");
            params.append(attr.getName()).append("()");
          }
          out.print(source[9]); // 63:2 = "  @Override  public Class<?> getUnique..."
          out.print(getEntity());
          out.print(source[10]); // 67:26 = "UDK.class;  }  @Override  public "
          out.print(returnType);
          out.print(source[11]); // 71:23 = " findByUniqueDomainKey(Object domainKey)..."
          out.print(getEntity());
          out.print(source[12]); // 72:19 = "UDK udk = ("
          out.print(getEntity());
          out.print(source[13]); // 72:45 = "UDK) domainKey;    return on().selectBy..."
          out.print(params);
          out.print(source[14]); // 73:50 = ");  }  @Override  public "
          out.print(getEntity());
          out.print(source[15]); // 77:24 = "UDK getUniqueDomainKey() {    return ne..."
          out.print(getEntity());
          out.print(source[16]); // 78:30 = "UDK(me());  }  @Override  public voi..."
          out.print(getEntity());
          out.print(source[17]); // 83:19 = "UDK udk = ("
          out.print(getEntity());
          out.print(source[18]); // 83:45 = "UDK) domainKey;"
          for (Attribute attr: udk) {
            out.print(source[19]); // 86:2 = "    me()."
            out.print(attr.getSetterName());
            out.print(source[20]); // 87:33 = "(udk."
            out.print(attr.getName());
            out.print(source[21]); // 87:56 = "());"
          }
          out.print(source[22]); // 90:2 = "  }"
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
