/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tentackle.common.Path;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;
import org.tentackle.wurblet.Join;
import org.wurbelizer.wurbel.WurbelException;

public class JoinPath
implements Path<JoinPath, Join> {
    private List<Join> elements;
    private List<JoinPath> paths;

    public JoinPath(List<Join> elements, List<JoinPath> paths) {
        this.elements = elements;
        this.paths = paths;
    }

    public JoinPath(Join element, List<JoinPath> paths) {
        this.elements = new ArrayList<Join>();
        this.elements.add(element);
        this.paths = paths;
    }

    public List<Join> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<Join>();
        }
        return this.elements;
    }

    public List<JoinPath> getPaths() {
        if (this.paths == null) {
            this.paths = new ArrayList<JoinPath>();
        }
        return this.paths;
    }

    public Join findJoin(Entity component) throws WurbelException {
        return component == null ? null : this.findJoinImpl(this, component);
    }

    private Join findJoinImpl(JoinPath path, Entity component) throws WurbelException {
        Join join = null;
        JoinPath joinPath = null;
        List<Join> joins = path.getElements();
        int joinCount = joins.size();
        for (Join jn : path.getElements()) {
            if (!component.equals(jn.getRelation().getForeignEntity())) continue;
            if (join != null) {
                throw new WurbelException("ambiguous path to " + component + " in path " + path);
            }
            join = jn;
            joinPath = path;
        }
        for (JoinPath subPath : path.getPaths()) {
            Join jn = this.findJoinImpl(subPath, component);
            if (jn == null) continue;
            if (join != null) {
                throw new WurbelException("ambiguous path to " + component + " in paths " + joinPath + " / " + subPath);
            }
            join = jn;
            joinPath = subPath;
        }
        return join;
    }

    public Join findJoin(List<Relation> relations) {
        return relations == null || relations.isEmpty() ? null : this.findJoinImpl(this, relations);
    }

    private Join findJoinImpl(JoinPath path, List<Relation> relations) {
        Join join;
        block3: {
            JoinPath subPath;
            join = null;
            int depth = 0;
            List<Join> joins = path.getElements();
            int joinCount = joins.size();
            for (Relation relation : relations) {
                if (depth >= joinCount) break;
                join = joins.get(depth);
                if (!relation.equals(join.getRelation())) {
                    return null;
                }
                ++depth;
            }
            if (depth >= relations.size()) break block3;
            relations = relations.subList(depth, relations.size());
            Iterator<Object> iterator = path.getPaths().iterator();
            while (iterator.hasNext() && (join = this.findJoinImpl(subPath = (JoinPath)iterator.next(), relations)) == null) {
            }
        }
        return join;
    }

    public void normalize() {
        int size;
        for (JoinPath subPath : this.getPaths()) {
            subPath.normalize();
        }
        while ((size = this.getElements().size()) > 1) {
            Join last = this.getElements().get(size - 1);
            JoinPath path = new JoinPath(last, new ArrayList<JoinPath>(this.getPaths()));
            this.getElements().remove(size - 1);
            this.getPaths().clear();
            this.getPaths().add(path);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Join join : this.getElements()) {
            buf.append(" * ").append(join);
        }
        for (JoinPath subPath : this.getPaths()) {
            buf.append(" [ ").append(subPath).append(" ]");
        }
        return buf.toString();
    }
}

