// wurblet generated by Wurbelizer 17.5.1.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;
import org.tentackle.sql.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the attribute- and relation-names of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; AttributeNames [--noif]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> if not part of an interface (adds "public static final")</li>
 * </ul>
 * For more options, see {@link ModelWurblet}.
 */
public class AttributeNames extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() {
    String lead = getOption("noif") == null ? "" : "public static final ";
    for (Relation rel: getEntity().getRelations()) {
      String var = rel.getVariableName();
      out.print(source[0]); // 19:2 = "  /** relation name for '"
      out.print(rel);
      out.print(source[1]); // 21:32 = "'. */  "
      out.print(lead);
      out.print(source[2]); // 22:10 = "String RN_"
      out.print(var.toUpperCase(Locale.ROOT));
      out.print(source[3]); // 22:52 = " = ""
      out.print(var);
      out.print(source[4]); // 22:63 = "";"
    }

    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoConstant() && !attr.getOptions().isFromSuper() && !attr.getOptions().isMute())    {
          String name = attr.getName().toUpperCase(Locale.ROOT);
          out.print(source[5]); // 29:2 = "  /** attribute name for database colum..."
          out.print(attr.getColumnName());
          out.print(source[6]); // 31:66 = "'. */  "
          out.print(lead);
          out.print(source[7]); // 32:10 = "String AN_"
          out.print(name);
          out.print(source[8]); // 32:28 = " = ""
          out.print(attr.getName());
          out.print(source[9]); // 32:50 = "";"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
