/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.Locale;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.wurblet.ModelWurblet;
import org.wurbelizer.wurbel.WurbelException;

public class ComponentInfo {
    private final Entity joinedEntity;
    private final String rootIdColumnName;
    private final String rootIdClassName;
    private final String extraClassName;

    public ComponentInfo(ModelWurblet wurblet, Entity joinedEntity) throws WurbelException {
        this.joinedEntity = joinedEntity;
        Entity topEntity = joinedEntity.getHierarchyInheritanceType() == InheritanceType.PLAIN ? joinedEntity : joinedEntity.getTopSuperEntity();
        Attribute rootAttribute = null;
        if (topEntity.equals(joinedEntity)) {
            this.extraClassName = null;
            for (topEntity = joinedEntity; topEntity != null && !topEntity.getOptions().isRootIdProvided() && (rootAttribute = topEntity.getRootAttribute()) == null; topEntity = topEntity.getSuperEntity()) {
            }
        } else {
            this.extraClassName = wurblet.deriveClassNameForEntity(joinedEntity);
            rootAttribute = topEntity.getRootAttribute();
        }
        if (rootAttribute != null) {
            Entity rootAttributeEntity = rootAttribute.getEntity().getInheritanceType() == InheritanceType.PLAIN ? joinedEntity : rootAttribute.getEntity();
            this.rootIdClassName = wurblet.deriveClassNameForEntity(rootAttributeEntity);
            this.rootIdColumnName = this.rootIdClassName + ".CN_" + rootAttribute.getName().toUpperCase(Locale.ROOT);
        } else {
            this.rootIdClassName = wurblet.deriveClassNameForEntity(joinedEntity);
            this.rootIdColumnName = "CN_ROOTID";
        }
    }

    public Entity getJoinedEntity() {
        return this.joinedEntity;
    }

    public boolean isExtraJoinNecessary() {
        return this.extraClassName != null;
    }

    public String getExtraClassName() {
        return this.extraClassName;
    }

    public String getRootIdClassName() {
        return this.rootIdClassName;
    }

    public String getRootIdColumnName() {
        return this.rootIdColumnName;
    }
}

