// wurblet generated by Wurbelizer 17.3.2.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the database column names.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ColumnNames
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class ColumnNames extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {
    for (Attribute attr: getEntity().getAttributes())  {
      if (!attr.getOptions().isNoConstant() && !attr.getOptions().isFromSuper()) {
        if (!attr.getOptions().isNoDeclare() || attr.getOptions().isFromSuper())    {
          int columnCount = getEffectiveDataType(attr).getColumnCount();
          String baseColConst = getColumnNameConstant(attr, -1);
          for (int columnIndex = 0; columnIndex < columnCount; columnIndex++) {
            String colConst = getColumnNameConstant(attr, columnIndex);
            if (colConst.equals(baseColConst)) {
              baseColConst = null;
            }
            out.print(source[0]); // 22:2 = "  /** database column name for '"
            out.print(attr);
            out.print(source[1]); // 24:40 = "'"
            out.print(columnCount > 1 ? (", column " + (columnIndex+1) + " of " + columnCount) : "");
            out.print(source[2]); // 24:122 = ". */  public static final String "
            out.print(colConst);
            out.print(source[3]); // 25:41 = " = "
            out.print(StringHelper.toDoubleQuotes(getColumnName(attr, columnIndex)));
            out.print(source[4]); // 25:109 = ";"
          }
          if (baseColConst != null) {
            out.print(source[5]); // 29:2 = "  /** database column basename for '"
            out.print(attr);
            out.print(source[6]); // 31:44 = "'. */  public static final String "
            out.print(baseColConst);
            out.print(source[7]); // 32:45 = " = "
            out.print(StringHelper.toDoubleQuotes(getColumnName(attr, -1)));
            out.print(source[8]); // 32:104 = ";"
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
