// wurblet generated by Wurbelizer 17.3.2.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate unique domain key class for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; UniqueDomainKey
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class UniqueDomainKey extends ModelWurblet {

  public UniqueDomainKey() {
    setPhase(2);
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {
    List<Attribute> udk = getEntity().getUniqueDomainKey();
    List<Attribute> superUdk = null;
    if (getEntity().getSuperEntity() != null) {
      superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
    }
    if (superUdk != null && !udk.isEmpty() && udk.equals(superUdk)) {
      out.print(source[0]); // 19:2 = "  // "
      out.print(getEntity());
      out.print(source[1]); // 20:20 = " inherits from "
      out.print(getEntity().getSuperEntity());
      out.print(source[2]); // 20:67 = ""
    }
    else if (!getEntity().isRootEntity()) {
      out.print(source[3]); // 24:2 = "  // "
      out.print(getEntity());
      out.print(source[4]); // 25:20 = " is not a root entity"
    }
    else if (udk.isEmpty()) {
      out.print(source[5]); // 29:2 = "  // no unique domain key defined for "
      out.print(getEntity());
      out.print(source[6]); // 30:53 = ""
    }
    else if (udk.size() == 1) {
      out.print(source[7]); // 34:2 = "  // unique domain key for "
      out.print(getEntity());
      out.print(source[8]); // 35:42 = " is "
      out.print(udk.get(0));
      out.print(source[9]); // 35:60 = ""
    }
    else  {
      // public static is noise if within an interface
      String modifiers = isInterface() ? "" : "public static ";
      out.print(source[10]); // 41:2 = "  /**   * The unique domain key for "
      out.print(getEntity());
      out.print(source[11]); // 43:46 = ".   */  "
      out.print(modifiers);
      out.print(source[12]); // 45:15 = "class "
      out.print(getEntity());
      out.print(source[13]); // 45:36 = "UDK implements Serializable, Comparable<..."
      out.print(getEntity());
      out.print(source[14]); // 45:91 = "UDK> {    private static final long se..."
      StringBuilder con1Args = new StringBuilder();   // 1st constructor arguments
      StringBuilder con2Args = new StringBuilder();   // 2nd constructor arguments
      boolean first = true;
      for (Attribute attr: udk) {
        if (first) {
          first = false;
        }
        else {
          con1Args.append(", ");
          con2Args.append(", ");
        }
        con1Args.append(attr.getJavaType()).append(" ").append(attr.getName());
        con2Args.append("pdo.").append(attr.getGetterName()).append("()");
        out.print(source[15]); // 62:2 = "    /** "
        out.print(attr.getOptions().getComment());
        out.print(source[16]); // 64:42 = ". */    public final "
        out.print(attr.getJavaType());
        out.print(source[17]); // 65:39 = " "
        out.print(attr.getName());
        out.print(source[18]); // 65:58 = ";"
      }
      out.print(source[19]); // 68:2 = "    /**     * Creates a unique domain ..."
      for (Attribute attr: udk) {
        out.print(source[20]); // 75:2 = "     * @param "
        out.print(attr.getName());
        out.print(source[21]); // 76:33 = " "
        out.print(attr.getOptions().getComment());
        out.print(source[22]); // 76:68 = ""
      }
      out.print(source[23]); // 79:2 = "     */    public "
      out.print(getEntity());
      out.print(source[24]); // 81:26 = "UDK("
      out.print(con1Args.toString());
      out.print(source[25]); // 81:53 = ") {"
      for (Attribute attr: udk) {
        out.print(source[26]); // 84:2 = "      this."
        out.print(attr.getName());
        out.print(source[27]); // 85:29 = " = "
        out.print(attr.getName());
        out.print(source[28]); // 85:50 = ";"
      }
      out.print(source[29]); // 88:2 = "    }    /**     * Creates a unique d..."
      out.print(getEntity());
      out.print(source[30]); // 96:26 = "UDK("
      out.print(getEntity());
      out.print(source[31]); // 96:45 = " pdo) {      this("
      out.print(con2Args.toString());
      out.print(source[32]); // 97:34 = ");    }    @Override    public int h..."
      for (Attribute attr: udk) {
        if (attr.getDataType().isPrimitive()) {
          out.print(source[33]); // 106:2 = "      hash = 79 * hash + "
          out.print(attr.getName());
          out.print(source[34]); // 107:43 = ";"
        }
        else  {
          out.print(source[35]); // 111:2 = "      hash = 79 * hash + Objects.hashCod..."
          out.print(attr.getName());
          out.print(source[36]); // 112:60 = ");"
        }
      }
      out.print(source[37]); // 116:2 = "      return hash;    }    @Override..."
      out.print(getEntity());
      out.print(source[38]); // 128:21 = "UDK other = ("
      out.print(getEntity());
      out.print(source[39]); // 128:49 = "UDK) obj;"
      for (Attribute attr: udk) {
        if (attr.getDataType().isPrimitive()) {
          out.print(source[40]); // 132:2 = "      if ("
          out.print(attr.getName());
          out.print(source[41]); // 133:28 = " != other."
          out.print(attr.getName());
          out.print(source[42]); // 133:56 = ") {        return false;      }"
        }
        else  {
          out.print(source[43]); // 139:2 = "      if (!Objects.equals("
          out.print(attr.getName());
          out.print(source[44]); // 140:44 = ", other."
          out.print(attr.getName());
          out.print(source[45]); // 140:70 = ")) {        return false;      }"
        }
      }
      out.print(source[46]); // 146:2 = "      return true;    }    @Override..."
      out.print(getEntity());
      out.print(source[47]); // 151:40 = "UDK other) {      int rv = other == nul..."
      String inset = "";
      for (Attribute attr: udk) {
        out.print(source[48]); // 156:2 = "      "
        out.print(inset);
        out.print(source[49]); // 157:15 = "if (rv == 0) {"
          if (attr.getDataType().isPrimitive()) {
            out.print(source[50]); // 160:2 = "      "
            out.print(inset);
            out.print(source[51]); // 161:15 = "  rv = "
            out.print(attr.getDataType().toNonPrimitive());
            out.print(source[52]); // 161:61 = ".compare("
            out.print(attr.getName());
            out.print(source[53]); // 161:88 = ", other."
            out.print(attr.getName());
            out.print(source[54]); // 161:114 = ");"
        }
        else  {
          out.print(source[55]); // 165:2 = "      "
          out.print(inset);
          out.print(source[56]); // 166:15 = "  rv = Compare.compare("
          out.print(attr.getName());
          out.print(source[57]); // 166:56 = ", other."
          out.print(attr.getName());
          out.print(source[58]); // 166:82 = ");"
        }
        inset += "  ";
      }

      do {
        inset = inset.substring(2);
        out.print(source[59]); // 174:2 = "      "
        out.print(inset);
        out.print(source[60]); // 175:15 = "}"

      } while (!inset.isEmpty());
       out.print(source[61]); // 179:2 = "      return rv;    }  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
