// wurblet generated by Wurbelizer 17.3.2.1, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate unique domain key class for an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; UniqueDomainKey
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class UniqueDomainKey extends ModelWurblet {

  public UniqueDomainKey() {
    setPhase(2);
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {
    List<Attribute> udk = getEntity().getUniqueDomainKey();
    List<Attribute> superUdk = null;
    if (getEntity().getSuperEntity() != null) {
      superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
    }
    if (superUdk != null && !udk.isEmpty() && udk.equals(superUdk)) {
      out.print(source[0]); // 19:2 = "  // "
      out.print(getEntity());
      out.print(source[1]); // 20:20 = " inherits from "
      out.print(getEntity().getSuperEntity());
      out.print(source[2]); // 20:67 = ""
    }
    else if (!getEntity().isRootEntity()) {
      out.print(source[3]); // 24:2 = "  // "
      out.print(getEntity());
      out.print(source[4]); // 25:20 = " is not a root entity"
    }
    else if (udk.isEmpty()) {
      out.print(source[5]); // 29:2 = "  // no unique domain key defined for "
      out.print(getEntity());
      out.print(source[6]); // 30:53 = ""
    }
    else if (udk.size() == 1) {
      out.print(source[7]); // 34:2 = "  // unique domain key for "
      out.print(getEntity());
      out.print(source[8]); // 35:42 = " is "
      out.print(udk.get(0));
      out.print(source[9]); // 35:60 = ""
    }
    else  {
      // public is noise if within an interface and nested records are implicitly static
      String modifiers = isInterface() ? "" : "public ";
      StringBuilder con1Args = new StringBuilder();   // 1st constructor arguments
      StringBuilder con2Args = new StringBuilder();   // 2nd constructor arguments
      boolean first = true;
      for (Attribute attr: udk) {
        if (first) {
          first = false;
        }
        else {
          con1Args.append(", ");
          con2Args.append(", ");
        }
        con1Args.append(attr.getJavaType()).append(" ").append(attr.getName());
        con2Args.append("pdo.").append(attr.getGetterName()).append("()");
      }
      out.print(source[10]); // 55:2 = "  /**   * The unique domain key for "
      out.print(getEntity());
      out.print(source[11]); // 57:46 = ".   *"
      for (Attribute attr: udk) {
        out.print(source[12]); // 61:2 = "   * @param "
        out.print(attr.getName());
        out.print(source[13]); // 62:31 = " "
        out.print(attr.getOptions().getComment());
        out.print(source[14]); // 62:66 = ""
      }
      out.print(source[15]); // 65:2 = "   */  "
      out.print(modifiers);
      out.print(source[16]); // 67:15 = "record "
      out.print(getEntity());
      out.print(source[17]); // 67:37 = "UDK("
      out.print(con1Args.toString());
      out.print(source[18]); // 67:64 = ")         implements Serializable, Comp..."
      out.print(getEntity());
      out.print(source[19]); // 68:60 = "UDK> {    /**     * Creates a unique ..."
      out.print(getEntity());
      out.print(source[20]); // 75:26 = "UDK("
      out.print(getEntity());
      out.print(source[21]); // 75:45 = " pdo) {      this("
      out.print(con2Args.toString());
      out.print(source[22]); // 76:34 = ");    }    @Override    public int c..."
      out.print(getEntity());
      out.print(source[23]); // 80:40 = "UDK other) {      int rv = other == nul..."
      String inset = "";
      for (Attribute attr: udk) {
        out.print(source[24]); // 85:2 = "      "
        out.print(inset);
        out.print(source[25]); // 86:15 = "if (rv == 0) {"
          if (attr.getDataType().isPrimitive()) {
            out.print(source[26]); // 89:2 = "      "
            out.print(inset);
            out.print(source[27]); // 90:15 = "  rv = "
            out.print(attr.getDataType().toNonPrimitive());
            out.print(source[28]); // 90:61 = ".compare("
            out.print(attr.getName());
            out.print(source[29]); // 90:88 = ", other."
            out.print(attr.getName());
            out.print(source[30]); // 90:114 = ");"
        }
        else  {
          out.print(source[31]); // 94:2 = "      "
          out.print(inset);
          out.print(source[32]); // 95:15 = "  rv = Compare.compare("
          out.print(attr.getName());
          out.print(source[33]); // 95:56 = ", other."
          out.print(attr.getName());
          out.print(source[34]); // 95:82 = ");"
        }
        inset += "  ";
      }

      do {
        inset = inset.substring(2);
        out.print(source[35]); // 103:2 = "      "
        out.print(inset);
        out.print(source[36]); // 104:15 = "}"

      } while (!inset.isEmpty());
       out.print(source[37]); // 108:2 = "      return rv;    }  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
