// wurblet generated by Wurbelizer 2.0.3, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;


public class IntMap extends AbstractIntMap {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      // ----------------- begin wurblet code -----------------

    /**
     * Tentackle - http://www.tentackle.org
     *
     * This library is free software; you can redistribute it and/or
     * modify it under the terms of the GNU Lesser General Public
     * License as published by the Free Software Foundation; either
     * version 2.1 of the License, or (at your option) any later version.
     *
     * This library is distributed in the hope that it will be useful,
     * but WITHOUT ANY WARRANTY; without even the implied warranty of
     * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     * Lesser General Public License for more details.
     *
     * You should have received a copy of the GNU Lesser General Public
     * License along with this library; if not, write to the Free Software
     * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
     */



    /**
     * Creates the declarations for a mapping between ints and values.
     * Useful for pre-enum APIs like JTable column indexes.
     *
     * Usage: <guardname> IntMap <model> [--type=<type>] [--name=<name>] [--static] [--scope=<scope>] [--offset=<n>]
     *
     *        <model> the model to be parsed by AbstractIntMap (pairs of int constants and values)
     *        --type=<type> the java type of the created value array, defaults to String
     *        --name=<name> the name of the created value array, defaults to <guardname>
     *        --static creates the defs and the array as static
     *        --scope=<scope> the scope, default is "private"
     *        --offset=<offset> offset for ints, if not starting at 0
     */

    String type       = "String";                                             // java type
    String name       = getContainer().getProperty(Wurbler.PROPSPACE_WURBLET, Wurbler.WURBLET_GUARDNAME);   // java name
    String scope      = "private";                                            // java scope
    String genStatic  = "";                                                   // " static" if static code
    int offset        = 0;

    for (String arg: getContainer().getArgs())  {
      if (arg.startsWith("--type=")) {
        type = arg.substring(7);
      }
      else if (arg.startsWith("--name=")) {
        name = arg.substring(7);
      }
      else if (arg.startsWith("--scope=")) {
        scope = arg.substring(8);
      }
      else if (arg.startsWith("--offset=")) {
        offset = Integer.parseInt(arg.substring(9));
      }
      else if (arg.equals("--static")) {
        genStatic = " static";
      }
    }

    // generate int definitions
    int index = offset;
    boolean valuesFound = false;
    for (MapEntry entry: getMapEntryList())  {
      String value = entry.getValue();
      if (value != null && !value.isEmpty()) {
        valuesFound = true;
        out.print(source[0]); // 72:2 = "  /** Index for "
        out.print(value);
        out.print(source[1]); // 74:25 = " **/"
      }
      out.print(source[2]); // 77:2 = "  "
      out.print(scope);
      out.print(genStatic);
      out.print(source[3]); // 78:24 = " final int "
      out.print(entry.getName());
      out.print(source[4]); // 78:54 = " = "
      out.print(index++);
      out.print(source[5]); // 78:68 = ";"
    }

    if (valuesFound) {
      // generate values
      out.print(source[6]); // 84:2 = "  /**   * values according to indexe..."
      out.print(scope);
      out.print(genStatic);
      out.print(source[7]); // 91:24 = " final "
      out.print(type);
      out.print(source[8]); // 91:39 = "[] "
      out.print(name);
      out.print(source[9]); // 91:50 = " = {"
      for (MapEntry entry: getMapEntryList()) {
        out.print(source[10]); // 94:2 = "    "
        out.print(entry.getValue());
        out.print(source[11]); // 95:24 = ","
      }
      out.print(source[12]); // 98:2 = "  };"
    }

      // ----------------- end wurblet code -----------------
    }
    catch (Exception ex) {
      throw new WurbelException("wurblet " + this + " failed", ex);
    }
  }
}
