/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;

public class ModelCommentSupport {
    public static void printVia(Relation relation, PrintStream out) {
        out.print(" via ");
        if (relation.getAttribute() != null) {
            out.print(relation.getAttribute());
        } else if (relation.getForeignEntity() != null && relation.getForeignAttribute() != null) {
            String entityName = relation.getForeignEntity().getName();
            if (relation.getForeignEntity().getTableAlias() != null) {
                entityName = relation.getForeignEntity().getTableAlias();
            }
            out.print(entityName);
            out.print('.');
            out.print(relation.getForeignAttribute());
        } else {
            out.print("?");
        }
    }

    public static void printReferencedBy(Relation relation, String indent, PrintStream out) {
        Entity entity = relation.getEntity();
        out.print(indent);
        out.print(entity);
        ModelCommentSupport.printRootEntities(entity, entity.getRootEntities(), out);
        if (relation.isDeepReference()) {
            out.print(" deeply");
        }
        ModelCommentSupport.printVia(relation, out);
        if (!relation.getName().equalsIgnoreCase(entity.toString())) {
            out.print(" as " + BasicStringHelper.firstToLower((String)relation.getName()));
        }
        Relation nmRel = relation.getNmRelation();
        Relation rel = relation;
        if (nmRel == null && relation.getForeignRelation() != null && (nmRel = relation.getForeignRelation().getNmRelation()) != null) {
            rel = relation.getForeignRelation();
        }
        if (nmRel != null) {
            out.print(" [N:M] to ");
            Entity nmEntity = nmRel.getForeignEntity();
            out.print(nmEntity);
            if (rel.getNmMethodName() != null && !rel.getNmMethodName().equalsIgnoreCase(nmEntity.toString())) {
                out.print(" as " + BasicStringHelper.firstToLower((String)rel.getNmMethodName()));
            }
            out.println();
        } else if (relation.getRelationType() == RelationType.LIST) {
            out.println(" [1:N]");
        } else {
            out.println(" [1:1]");
        }
    }

    public static void printComponents(Collection<Relation> compositeRelations, Collection<Entity> subEntities, String indent, PrintStream out) {
        for (Relation relation : compositeRelations) {
            Entity component = relation.getForeignEntity();
            for (Entity sub : subEntities) {
                if (sub.getComponents().isEmpty()) continue;
                out.print(indent);
                out.print("^ ");
                out.println(sub);
                ArrayList<Relation> subCompositeRelations = new ArrayList<Relation>();
                for (Relation subRelation : sub.getRelationsIncludingInherited()) {
                    if (!subRelation.isComposite()) continue;
                    subCompositeRelations.add(subRelation);
                }
                ModelCommentSupport.printComponents(subCompositeRelations, sub.getSubEntities(), indent + "    ", out);
            }
            out.print(indent);
            out.print("+ ");
            out.print(component);
            ModelCommentSupport.printVia(relation, out);
            if (!relation.getName().equalsIgnoreCase(component.toString())) {
                out.print(" as " + BasicStringHelper.firstToLower((String)relation.getName()));
            }
            if (relation.getNmRelation() != null) {
                out.print(" [N:M] to ");
                Entity nmEntity = relation.getNmRelation().getForeignEntity();
                out.print(nmEntity);
                if (relation.getNmMethodName() != null && !relation.getNmMethodName().equalsIgnoreCase(nmEntity.toString())) {
                    out.print(" as " + BasicStringHelper.firstToLower((String)relation.getNmMethodName()));
                }
                out.println();
            } else if (relation.getRelationType() == RelationType.LIST) {
                out.println(" [1:N]");
            } else {
                out.println(" [1:1]");
            }
            ArrayList<Relation> componentCompositeRelations = new ArrayList<Relation>();
            for (Relation subRelation : component.getRelationsIncludingInherited()) {
                if (!subRelation.isComposite()) continue;
                componentCompositeRelations.add(subRelation);
            }
            ModelCommentSupport.printComponents(componentCompositeRelations, component.getSubEntities(), indent + "    ", out);
        }
    }

    public static void printSubEntities(Collection<Entity> subEntities, String indent, PrintStream out) {
        for (Entity sub : subEntities) {
            out.print(indent);
            out.print("^ ");
            out.println(sub);
            ModelCommentSupport.printSubEntities(sub.getSubEntities(), indent + "    ", out);
        }
    }

    public static void printNonCompositeRelations(Entity entity, List<Relation> relations, String indent, PrintStream out) {
        for (Relation relation : relations) {
            if (relation.isComposite() || relation.getForeignEntity().equals(entity)) continue;
            out.print(indent);
            out.print(relation.getForeignEntity());
            ModelCommentSupport.printRootEntities(entity, relation.getForeignEntity().getRootEntities(), out);
            if (!relation.getEntity().equals(entity)) {
                out.print(" from ");
                out.print(relation.getEntity());
                ModelCommentSupport.printRootEntities(entity, relation.getEntity().getRootEntities(), out);
            }
            ModelCommentSupport.printVia(relation, out);
            if (relation.isReversed()) {
                out.println(" reversed");
            }
            out.println();
        }
    }

    private static void printRootEntities(Entity entity, Collection<Entity> rootEntities, PrintStream out) {
        ArrayList<Entity> roots = new ArrayList<Entity>();
        for (Entity rootEntity : rootEntities) {
            if (rootEntity.equals(entity)) continue;
            roots.add(rootEntity);
        }
        if (!roots.isEmpty()) {
            out.print(" (");
            boolean needComma = false;
            for (Entity rootEntity : roots) {
                if (needComma) {
                    out.print(", ");
                } else {
                    needComma = true;
                }
                out.print(rootEntity);
            }
            out.print(")");
        }
    }

    private ModelCommentSupport() {
    }
}

