/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendFactory;
import org.tentackle.wurblet.TentackleWurbletsModel;
import org.tentackle.wurblet.WurbletParameter;
import org.tentackle.wurblet.WurbletParameterExpression;
import org.tentackle.wurblet.WurbletParameterParser;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurblet.AbstractWurblet;

public class ModelWurblet
extends AbstractWurblet {
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\s*([\\w\\.]+)\\.class");
    private String modelDirName;
    private String modelName;
    private Entity entity;
    private List<String> args;
    private boolean contextIdAttributeValid;
    private Boolean isPdo;
    private boolean remote;
    private String pdoClassName;
    private WurbletParameterParser parser;
    private List<Relation> joins;

    public String getModelDirName() {
        return this.modelDirName;
    }

    public String getPdoClassName() throws WurbelException {
        if (this.isPdo == null) {
            int ndx;
            String annotation;
            this.isPdo = false;
            int ndx2 = 0;
            while ((annotation = this.getContainer().getProperty("wurblet", "annotation_" + ndx2)) != null) {
                if (annotation.startsWith("@DomainObjectService") || annotation.startsWith("@PersistentObjectService")) {
                    Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
                    if (matcher.find()) {
                        this.pdoClassName = matcher.group(1);
                        if (this.getContainer().getVerbosity().isDebug()) {
                            this.getContainer().getLogger().info("pdoClassName: " + this.pdoClassName);
                        }
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                    throw new WurbelException("malformed annotation: " + annotation);
                }
                ++ndx2;
            }
            String persistentIface = this.getContainer().getProperty("wurblet", "extends_0");
            if (persistentIface != null && (ndx = persistentIface.indexOf(60)) > 0 && (ndx = (persistentIface = persistentIface.substring(ndx + 1)).lastIndexOf(62)) > 0) {
                this.pdoClassName = persistentIface.substring(0, ndx);
                if (this.pdoClassName.length() > 1 && this.pdoClassName.indexOf(60) < 0) {
                    this.isPdo = true;
                    return this.pdoClassName;
                }
            }
            this.pdoClassName = this.getContainer().getProperty("wurblet", "definition");
            if (this.pdoClassName != null) {
                if (this.getContainer().getVerbosity().isDebug()) {
                    this.getContainer().getLogger().info(this.getContainer().getProperty("wurblet", "classname") + ": definition = '" + this.pdoClassName + "'");
                }
                if ((ndx = this.pdoClassName.indexOf("extends")) >= 0) {
                    int ndx1 = this.pdoClassName.indexOf(60);
                    int ndx22 = this.pdoClassName.indexOf(44);
                    if (ndx1 > ndx && ndx22 > ndx1) {
                        this.pdoClassName = this.pdoClassName.substring(ndx1 + 1, ndx22).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
                if ((ndx = this.pdoClassName.indexOf("T extends")) >= 0) {
                    this.pdoClassName = this.pdoClassName.substring(ndx + 9);
                    ndx = this.pdoClassName.indexOf(60);
                    if (ndx > 0) {
                        this.pdoClassName = this.pdoClassName.substring(0, ndx).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
            }
        }
        if (this.isPdo.booleanValue()) {
            return this.pdoClassName;
        }
        throw new WurbelException("cannot determine the pdo-class from the java-source");
    }

    public boolean isPdo() {
        if (this.isPdo == null) {
            try {
                this.getPdoClassName();
            }
            catch (WurbelException wurbelException) {
                // empty catch block
            }
        }
        return this.isPdo;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isPartOfInheritanceHierarchy() {
        return this.isPdo() && this.getEntity().getTopSuperEntity().isAbstract();
    }

    public boolean isGenerified() {
        String definition = this.getContainer().getProperty("wurblet", "definition");
        return definition != null && definition.startsWith("<");
    }

    public String getMethodName() throws WurbelException {
        String methodName = this.getOption("method");
        if (methodName == null) {
            methodName = this.getGuardName();
        }
        return methodName;
    }

    public String getModelName() throws WurbelException {
        if (this.modelName == null) {
            this.modelName = this.getOption("model");
            if (this.modelName == null) {
                this.modelName = this.getPdoClassName();
            }
            if (this.modelName == null) {
                throw new WurbelException("model not specified");
            }
        }
        return this.modelName;
    }

    public String deriveClassNameForEntity(Entity otherEntity) throws WurbelException {
        String entityName;
        String className = this.getClassName();
        int ndx = className.indexOf(entityName = this.getEntity().getName());
        if (ndx < 0) {
            throw new WurbelException(className + " does not contain the entity name '" + entityName + "' substring");
        }
        String lead = className.substring(0, ndx);
        String tail = className.substring(ndx + entityName.length());
        return lead + otherEntity.getName() + tail;
    }

    public List<Entity> orderByInheritanceLevelAndClassId(List<Entity> entities) {
        Collections.sort(entities, (o1, o2) -> {
            int rv = o1.getInheritanceLevel() - o2.getInheritanceLevel();
            if (rv == 0) {
                rv = Long.compare(o1.getClassId(), o2.getClassId());
            }
            return rv;
        });
        return entities;
    }

    public boolean isContextIdAttributeValid() {
        return this.contextIdAttributeValid;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getOptionArgs() {
        return this.parser.getOptionArgs();
    }

    public String getOption(String option) {
        int equalsOffset = option.length();
        for (String arg : this.getOptionArgs()) {
            if (arg.equals(option)) {
                return "";
            }
            if (!arg.startsWith(option) || arg.charAt(equalsOffset) != '=') continue;
            return arg.substring(equalsOffset + 1);
        }
        return null;
    }

    public List<WurbletParameter> getAllParameters() {
        return this.parser.getAllParameters();
    }

    public List<WurbletParameter> getMethodParameters() {
        return this.parser.getMethodParameters();
    }

    public List<WurbletParameter> getExpressionParameters() {
        return this.parser.getExpressionParameters();
    }

    public WurbletParameterExpression getExpression() {
        return this.parser.getExpression();
    }

    public List<WurbletParameter> getExtraParameters() {
        return this.parser.getExtraParameters();
    }

    public List<WurbletParameter> getSortingParameters() {
        return this.parser.getSortingParameters();
    }

    public boolean isWithSorting() {
        return !this.getSortingParameters().isEmpty();
    }

    public List<Relation> getJoins() {
        return this.joins;
    }

    public String createRelationSelectMethodName(Relation relation) {
        String text = "select";
        if (relation.getMethodName() != null) {
            if (relation.getRelationType() == RelationType.LIST) {
                text = text + "By";
            }
            text = text + relation.getMethodName();
        } else if (relation.getRelationType() == RelationType.LIST) {
            text = text + "By" + relation.getEntity().getName() + "Id";
        } else if (relation.isSelectionCached()) {
            text = text + "Cached";
        }
        if (text.equals("select")) {
            text = "select";
        }
        return text;
    }

    public String createListRelationDeleteMethodName(Relation relation) {
        String text = "deleteBy";
        text = relation.getMethodName() != null ? text + relation.getMethodName() : text + relation.getEntity().getName() + "Id";
        return text;
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws WurbelException {
        ModelException modelException;
        WurbelException wex;
        super.run();
        this.args = Arrays.asList(this.container.getArgs());
        this.joins = new ArrayList<Relation>();
        this.parser = new WurbletParameterParser(this.args);
        this.modelDirName = this.getContainer().getProperty("extra", "model");
        File modelDir = new File(this.modelDirName);
        if (!modelDir.exists()) {
            this.getContainer().getLogger().info("creating " + modelDir);
            modelDir.mkdirs();
        }
        if (!modelDir.isDirectory()) {
            throw new WurbelException(modelDir + " is not a directory");
        }
        String backends = this.getContainer().getProperty("extra", "backends");
        if (backends != null) {
            ArrayList<Backend> backendList = new ArrayList<Backend>();
            if ("all".equalsIgnoreCase(backends)) {
                backendList.addAll(BackendFactory.getInstance().getAllBackends());
            } else {
                for (String backend : backends.split(",")) {
                    backendList.add(BackendFactory.getInstance().getBackendByName(backend.trim()));
                }
            }
            Model.getInstance().getEntityFactory().setBackends(backendList);
        }
        ModelDefaults modelDefaults = null;
        String modelDefaultsStr = this.getContainer().getProperty("extra", "modelDefaults");
        if (modelDefaultsStr != null) {
            modelDefaults = new ModelDefaults(modelDefaultsStr);
        }
        Model model = Model.getInstance();
        try {
            model.loadModel(this.modelDirName, modelDefaults);
        }
        catch (ModelException mex2) {
            WurbelException wex2 = new WurbelException("errors in model loaded from directory '" + this.modelDirName + "'", (Throwable)mex2);
            if (model instanceof TentackleWurbletsModel && !mex2.getEntities().isEmpty() && ((TentackleWurbletsModel)model).getLoadingException() == null) {
                ((TentackleWurbletsModel)model).setLoadingException(wex2);
            }
            throw wex2;
        }
        try {
            this.entity = this.getModelName().indexOf(File.separatorChar) >= 0 ? model.loadByFileName(modelDefaults, this.getModelName()) : model.getByEntityName(this.getModelName());
        }
        catch (ModelException mex3) {
            throw new WurbelException("errors in model loaded from file '" + this.getModelName() + "'", (Throwable)mex3);
        }
        if (this.entity == null) {
            Object wex2;
            Throwable delayedModelException = null;
            if (model instanceof TentackleWurbletsModel && (wex2 = ((TentackleWurbletsModel)model).getLoadingException()) != null) {
                delayedModelException = wex2.getCause();
            }
            throw new WurbelException("no such entity '" + this.getModelName() + "' in model " + modelDir, delayedModelException);
        }
        this.remote = this.entity.getOptions().isRemote();
        if (this.getOption("remote") != null) {
            this.remote = true;
        }
        if (this.getOption("noremote") != null) {
            this.remote = false;
        }
        this.contextIdAttributeValid = this.entity.getContextIdAttribute() != null;
        HashSet<Entity> componentKeyEntities = new HashSet<Entity>();
        for (WurbletParameter wurbletParameter : this.getAllParameters()) {
            Attribute attribute;
            Entity parEntity = this.entity;
            if (wurbletParameter.isComponentKey() || wurbletParameter.isRelationKey() && !wurbletParameter.getComponentEntityName().isEmpty()) {
                Relation relation;
                if (wurbletParameter.isSortKey()) {
                    throw new WurbelException("sorting not allowed for component keys: " + wurbletParameter);
                }
                if (!this.entity.isRootEntityAccordingToModel()) {
                    throw new WurbelException("component keys are only allowed for root-entities: " + wurbletParameter);
                }
                try {
                    parEntity = model.getByEntityName(wurbletParameter.getComponentEntityName());
                }
                catch (ModelException mex4) {
                    throw new WurbelException("model errors while loading '" + wurbletParameter.getComponentEntityName() + "'", (Throwable)mex4);
                }
                if (parEntity == null && !wurbletParameter.isRelationKey() && (relation = this.entity.getRelation(wurbletParameter.getComponentEntityName(), true)) != null) {
                    parEntity = relation.getForeignEntity();
                }
                if (parEntity == null) {
                    throw new WurbelException("no such entity '" + wurbletParameter.getComponentEntityName() + "' in " + wurbletParameter);
                }
                boolean rootOk = false;
                block10: for (Entity joinedEntity = parEntity; joinedEntity != null; joinedEntity = joinedEntity.getSuperEntity()) {
                    for (Entity rootEntity : joinedEntity.getRootEntities()) {
                        if (!rootEntity.equals(this.entity)) continue;
                        rootOk = true;
                        break block10;
                    }
                }
                if (!rootOk) {
                    throw new WurbelException(parEntity + " is not a component of " + this.entity + ": " + wurbletParameter);
                }
                Entity topEntity = parEntity.getTopSuperEntity();
                componentKeyEntities.add(topEntity);
                componentKeyEntities.addAll(parEntity.getAllSubEntities());
            }
            if (wurbletParameter.isRelationKey()) {
                Relation relation = parEntity.getRelation(wurbletParameter.getRelationName(), true);
                if (relation == null) {
                    throw new WurbelException("no such relation '" + wurbletParameter.getRelationName() + "' in " + parEntity + ": " + wurbletParameter);
                }
                wurbletParameter.setRelation(relation);
                parEntity = relation.getForeignEntity();
                if (wurbletParameter.getRelationComponentEntityName() != null) {
                    try {
                        parEntity = model.getByEntityName(wurbletParameter.getRelationComponentEntityName());
                    }
                    catch (ModelException mex5) {
                        throw new WurbelException("model errors while loading '" + wurbletParameter.getRelationComponentEntityName() + "'", (Throwable)mex5);
                    }
                    if (parEntity == null) {
                        throw new WurbelException("no such related entity '" + wurbletParameter.getRelationComponentEntityName() + "' in " + wurbletParameter);
                    }
                }
                if (relation.isComposite()) {
                    for (Entity root : parEntity.getRootEntities()) {
                        if (!root.equals(this.entity)) continue;
                        Entity topEntity = parEntity.getTopSuperEntity();
                        componentKeyEntities.add(topEntity);
                        componentKeyEntities.addAll(parEntity.getAllSubEntities());
                        break;
                    }
                }
            }
            if ((attribute = parEntity.getAttributeByJavaName(wurbletParameter.getName(), true)) == null) {
                throw new WurbelException("no such attribute '" + wurbletParameter.getName() + "' in " + parEntity + ": " + wurbletParameter);
            }
            wurbletParameter.setAttribute(attribute);
            if (!attribute.getEntity().equals(this.entity) || !attribute.getOptions().isContextId()) continue;
            this.contextIdAttributeValid = false;
        }
        for (String string : this.parser.getJoinNames()) {
            Relation join = this.entity.getRelation(string, true);
            if (join == null) {
                throw new WurbelException("no such relation to join: " + string);
            }
            if (join.getSelectionType() != SelectionType.LAZY && join.getSelectionType() != SelectionType.EAGER) {
                throw new WurbelException("joined relation '" + join.getName() + "' must be lazy or eager");
            }
            if (this.remote && !join.isComposite() && !join.isSerialized() && join.getSelectionType() != SelectionType.EAGER) {
                throw new WurbelException("joined non-composite relation '" + join.getName() + "' must be serialized for remote access");
            }
            if (componentKeyEntities.contains(join.getForeignEntity())) {
                throw new WurbelException("join '" + join.getName() + "' is already used by a component key");
            }
            this.joins.add(join);
        }
        if (this.contextIdAttributeValid && this.contextIdAttributeValid) {
            void var8_20;
            int uniqueAttributeCount = 0;
            for (Attribute attribute : this.entity.getAttributes()) {
                if (!attribute.getOptions().isDomainKey()) continue;
                ++uniqueAttributeCount;
            }
            boolean bl = false;
            for (WurbletParameter key : this.getExpressionParameters()) {
                Attribute attribute = key.getAttribute();
                if (attribute == null || !attribute.getOptions().isDomainKey()) continue;
                ++var8_20;
            }
            if (uniqueAttributeCount > 0 && uniqueAttributeCount == var8_20) {
                this.contextIdAttributeValid = false;
            }
        }
        if (model instanceof TentackleWurbletsModel && (wex = ((TentackleWurbletsModel)model).getLoadingException()) != null && wex.getCause() instanceof ModelException && (modelException = (ModelException)wex.getCause()).getEntities().contains(this.entity)) {
            throw wex;
        }
    }

    public boolean isIdAttribute(Attribute attribute) {
        return attribute.getJavaName().equals("id");
    }

    public boolean isSerialAttribute(Attribute attribute) {
        return attribute.getJavaName().equals("serial");
    }

    public boolean isIdOrSerialAttribute(Attribute attribute) {
        return this.isIdAttribute(attribute) || this.isSerialAttribute(attribute);
    }

    public boolean isAttributeDerived(Attribute attribute) {
        return attribute.getOptions().isDerived() || attribute.getEntity() != this.entity;
    }

    public boolean isSetGetRequired(Attribute attribute) {
        return attribute.getOptions().isSetGet() || this.isAttributeDerived(attribute);
    }

    public void appendCommaSeparated(StringBuilder builder, String appendStr) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(appendStr);
    }

    public void prependCommaSeparated(StringBuilder builder, String prependStr) {
        if (builder.length() > 0) {
            builder.insert(0, ", ");
        }
        builder.insert(0, prependStr);
    }
}

