// wurblet generated by Wurbelizer 2.0.6, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import org.tentackle.buildsupport.*;
import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;


public class Relations extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      // ----------------- begin wurblet code -----------------

    /**
     * Tentackle - http://www.tentackle.org
     *
     * This library is free software; you can redistribute it and/or
     * modify it under the terms of the GNU Lesser General Public
     * License as published by the Free Software Foundation; either
     * version 2.1 of the License, or (at your option) any later version.
     *
     * This library is distributed in the hope that it will be useful,
     * but WITHOUT ANY WARRANTY; without even the implied warranty of
     * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     * Lesser General Public License for more details.
     *
     * You should have received a copy of the GNU Lesser General Public
     * License along with this library; if not, write to the Free Software
     * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
     */



    /**
     * generate interface code for PDO relations.
     *
     * usage:  @wurblet <tag> Relations --model=<mapfile>
     *
     *         <mapfile> is the mapping description
     *
     * Example: @wurblet relations Relations --model=$mapping
     */

    // create comment for referencing relations
    List<Relation> referencingRelations = getEntity().getReferencingRelationsIncludingSubEntities();
    out.print(source[0]); // 35:2 = "  /**   * "
    out.print(getEntity());
    out.print(source[1]); // 38:20 = " "
    out.print(referencingRelations.isEmpty() ? "is not referenced by any other entity!" : "is referenced by:");
    out.print(source[2]); // 38:120 = ""
    for (Relation rel: referencingRelations) {
      out.print(source[3]); // 41:2 = "   * "
      out.print(rel);
      out.print(source[4]); // 42:12 = ""
    }
    out.print(source[5]); // 45:2 = "   */"

    for (Relation rel: getEntity().getRelations()) {

      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }

      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType();
      String firstArg = rel.getMethodArgs().get(0);
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        // take from attribute
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = BasicStringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = BasicStringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = BasicStringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = BasicStringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = firstArg + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = firstArg + " == null || " + checkNull;
        }
        out.print(source[6]); // 90:2 = "  /**   * Gets "
        out.print(rel);
        out.print(source[7]); // 93:17 = ".   *   * @return "
        out.print(var);
        out.print(source[8]); // 95:21 = " "
        out.print(rel.getComment());
        out.print(source[9]); // 95:42 = "   */  @Bindable"
        if (!rel.isComposite()) {
          out.print(source[10]); // 100:2 = "  @Persistent(value="
          out.print(BasicStringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[11]); // 101:75 = ", component=false)"
        }
        else {
          out.print(source[12]); // 105:2 = "  @Persistent("
          out.print(BasicStringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[13]); // 106:69 = ")"
        }
        for (String annotation: rel.getAnnotations()) {
          out.print(source[14]); // 110:2 = "  "
          out.print(annotation);
          out.print(source[15]); // 111:16 = ""
        }
        out.print(source[16]); // 114:2 = "  "
        out.print(type);
        out.print(source[17]); // 115:10 = " "
        out.print(rel.getGetterName());
        out.print(source[18]); // 115:34 = "();"
        if (nmRel != null) {
          out.print(source[19]); // 118:2 = "  /**   * Gets list of "
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[20]); // 121:49 = " joined via "
          out.print(rel);
          out.print(source[21]); // 121:68 = ".   *   * @return list of "
          out.print(nmRel.getVariableName());
          out.print(source[22]); // 123:49 = "   */  @Bindable  @Persistent(value="
          out.print(BasicStringHelper.toDoubleQuotes(nmVar));
          out.print(source[23]); // 126:64 = ", component=false)  TrackedList<"
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[24]); // 127:45 = "> get"
          out.print(nmName);
          out.print(source[25]); // 127:60 = "();"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        boolean linkMethodIndexed = rel.getForeignRelation() != null ?
            rel.getForeignRelation().getLinkMethodIndex() != null : false;

            out.print(source[26]); // 138:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[27]); // 141:17 = ".   *   * @param "
            out.print(var);
            out.print(source[28]); // 143:20 = " "
            out.print(rel.getComment());
            out.print(source[29]); // 143:41 = ""
        if (linkMethodIndexed) {
          out.print(source[30]); // 146:2 = "   * @param index the index starting at ..."
        }
        out.print(source[31]); // 150:2 = "   */"
        if (attr != null && attr.getOptions().isBind()) {
          out.print(source[32]); // 154:2 = "  "
          out.print(attr.getBindableAnnotation());
          out.print(source[33]); // 155:34 = ""
        }
        if (linkMethodIndexed) {
          out.print(source[34]); // 159:2 = "  void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[35]); // 160:55 = "("
          out.print(type);
          out.print(source[36]); // 160:64 = " "
          out.print(var);
          out.print(source[37]); // 160:72 = ", int index);"
        }
        else {
          out.print(source[38]); // 164:2 = "  void "
          out.print(rel.getSetterName());
          out.print(source[39]); // 165:30 = "("
          out.print(type);
          out.print(source[40]); // 165:39 = " "
          out.print(var);
          out.print(source[41]); // 165:47 = ");"
        }
      }
    }

    // creates the select- and delete-methods for list relations in foreign entities
    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }
      if (rel.getRelationType() == RelationType.LIST) {
        Attribute attribute = rel.getForeignAttribute();
        if (attribute != null) {
          out.print(source[42]); // 182:2 = "  /**   * Selects "
          out.print(rel);
          out.print(source[43]); // 185:20 = ".   *   * @param "
          out.print(attribute.getJavaName());
          out.print(source[44]); // 187:40 = " "
          out.print(attribute.getOptions().getComment());
          out.print(source[45]); // 187:80 = "   * @return "
          out.print(rel.getComment());
          out.print(source[46]); // 188:34 = "   */  "
          out.print(rel.getDeclaredJavaType());
          out.print(source[47]); // 190:31 = " "
          out.print(createRelationSelectMethodName(rel));
          out.print(source[48]); // 190:71 = "("
          out.print(attribute.getJavaType());
          out.print(source[49]); // 190:99 = " "
          out.print(attribute.getJavaName());
          out.print(source[50]); // 190:127 = ");"
          if (rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
            out.print(source[51]); // 193:2 = "  /**   * Deletes "
            out.print(rel);
            out.print(source[52]); // 196:20 = ".   *   * @param "
            out.print(attribute.getJavaName());
            out.print(source[53]); // 198:40 = " "
            out.print(attribute.getOptions().getComment());
            out.print(source[54]); // 198:80 = "   * @return "
            out.print(rel.getComment());
            out.print(source[55]); // 199:34 = "   */  int "
            out.print(createListRelationDeleteMethodName(rel));
            out.print(source[56]); // 201:49 = "("
            out.print(attribute.getJavaType());
            out.print(source[57]); // 201:77 = " "
            out.print(attribute.getJavaName());
            out.print(source[58]); // 201:105 = ");"
          }
        }
      }
    }

      // ----------------- end wurblet code -----------------
    }
    catch (Exception ex) {
      throw new WurbelException("wurblet " + this + " failed", ex);
    }
  }
}
