/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import org.tentackle.model.Attribute;
import org.tentackle.model.Relation;
import org.tentackle.wurblet.WurbletParameterOperand;

public class WurbletParameter
implements WurbletParameterOperand {
    private final String text;
    private String name;
    private final boolean isComponentKey;
    private final boolean isRelationKey;
    private final String componentEntityName;
    private final String relationName;
    private final String relationComponentEntityName;
    private String arg;
    private String relop;
    private String value;
    private boolean fixed;
    private String sortMode;
    private Attribute attribute;
    private Relation relation;

    public WurbletParameter(String text) {
        int ndx2;
        this.text = text;
        int ndx = text.indexOf(58);
        if (ndx > 0) {
            this.name = text.substring(0, ndx);
            this.relop = text.substring(ndx + 1);
            ndx = this.relop.indexOf(58);
            if (ndx > 0) {
                this.value = this.relop.substring(ndx + 1);
                this.relop = this.relop.substring(0, ndx);
            } else {
                ndx = this.relop.indexOf(35);
                if (ndx > 0) {
                    this.value = this.relop.substring(ndx + 1);
                    this.relop = this.relop.substring(0, ndx);
                    this.fixed = true;
                }
            }
            switch (this.relop.toUpperCase()) {
                case "NULL": {
                    this.relop = " IS NULL";
                    this.value = "";
                    this.fixed = true;
                    break;
                }
                case "NOTNULL": {
                    this.relop = " IS NOT NULL";
                    this.value = "";
                    this.fixed = true;
                    break;
                }
                case "LIKE": {
                    this.relop = " LIKE ";
                    break;
                }
                case "NOTLIKE": {
                    this.relop = " NOT LIKE ";
                }
            }
        } else {
            this.name = text;
            switch (this.name.charAt(0)) {
                case '-': {
                    this.sortMode = " DESC";
                    this.name = this.name.substring(1);
                    break;
                }
                case '+': {
                    this.sortMode = " ASC";
                    this.name = this.name.substring(1);
                    break;
                }
                default: {
                    this.relop = "=";
                }
            }
        }
        ndx = this.name.indexOf(46);
        if (ndx >= 0) {
            this.componentEntityName = this.name.substring(0, ndx);
            this.name = this.name.substring(ndx + 1);
            ndx = this.name.indexOf(46);
            if (ndx > 0) {
                this.isComponentKey = false;
                this.isRelationKey = true;
                this.relationName = this.name.substring(0, ndx);
                this.name = this.name.substring(ndx + 1);
                ndx = this.name.indexOf(46);
                if (ndx > 0) {
                    this.relationComponentEntityName = this.name.substring(0, ndx);
                    this.name = this.name.substring(ndx + 1);
                } else {
                    this.relationComponentEntityName = null;
                }
            } else {
                this.isRelationKey = false;
                this.relationName = null;
                this.relationComponentEntityName = null;
                this.isComponentKey = !this.componentEntityName.isEmpty();
            }
        } else {
            this.relationName = null;
            this.componentEntityName = null;
            this.relationComponentEntityName = null;
            this.isComponentKey = false;
            this.isRelationKey = false;
        }
        this.arg = this.name;
        ndx = this.name.indexOf(91);
        if (ndx > 0 && (ndx2 = this.name.indexOf(93)) > ndx) {
            this.arg = this.name.substring(ndx + 1, ndx2);
            this.name = this.name.substring(0, ndx);
        }
    }

    public boolean isComponentKey() {
        return this.isComponentKey;
    }

    public boolean isRelationKey() {
        return this.isRelationKey;
    }

    public String getComponentEntityName() {
        return this.componentEntityName;
    }

    public String getRelationComponentEntityName() {
        return this.relationComponentEntityName;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public boolean isSortKey() {
        return this.sortMode != null;
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public boolean isArg() {
        return this.value == null;
    }

    public boolean isSqlArg() {
        return !this.fixed;
    }

    public String getSqlArg() {
        String str;
        if (this.value != null) {
            str = this.value;
            if (this.attribute != null && this.attribute.getDataType().isNumeric()) {
                switch (this.attribute.getDataType()) {
                    case BYTE: {
                        str = "(Byte) " + str;
                        break;
                    }
                    case BYTE_PRIMITIVE: {
                        str = "(byte) " + str;
                        break;
                    }
                    case SHORT: {
                        str = "(Short) " + str;
                        break;
                    }
                    case SHORT_PRIMITIVE: {
                        str = "(short) " + str;
                    }
                }
            }
        } else {
            str = this.arg;
        }
        return str;
    }

    public String getRelop() {
        String str;
        switch (this.relop) {
            case "=": {
                if (this.fixed) {
                    str = "Backend.SQL_EQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_EQUAL_PAR";
                break;
            }
            case "<>": 
            case "!=": {
                if (this.fixed) {
                    str = "Backend.SQL_NOTEQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_NOTEQUAL_PAR";
                break;
            }
            case "<": {
                if (this.fixed) {
                    str = "Backend.SQL_LESS + " + this.value;
                    break;
                }
                str = "Backend.SQL_LESS_PAR";
                break;
            }
            case ">": {
                if (this.fixed) {
                    str = "Backend.SQL_GREATER + " + this.value;
                    break;
                }
                str = "Backend.SQL_GREATER_PAR";
                break;
            }
            case "<=": {
                if (this.fixed) {
                    str = "Backend.SQL_LESSOREQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_LESSOREQUAL_PAR";
                break;
            }
            case ">=": {
                if (this.fixed) {
                    str = "Backend.SQL_GREATEROREQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_GREATEROREQUAL_PAR";
                break;
            }
            case " LIKE ": {
                if (this.fixed) {
                    str = "Backend.SQL_LIKE + " + this.value;
                    break;
                }
                str = "Backend.SQL_LIKE_PAR";
                break;
            }
            case " NOT LIKE ": {
                if (this.fixed) {
                    str = "Backend.SQL_NOTLIKE + " + this.value;
                    break;
                }
                str = "Backend.SQL_NOTLIKE_PAR";
                break;
            }
            case " IS NULL": {
                str = "Backend.SQL_ISNULL";
                break;
            }
            case " IS NOT NULL": {
                str = "Backend.SQL_ISNOTNULL";
                break;
            }
            default: {
                str = this.relop + (this.fixed ? this.value : "?");
            }
        }
        return str;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String arg) {
        this.arg = arg;
    }

    public void setRelop(String relop) {
        this.relop = relop;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public String toString() {
        return this.getText();
    }
}

