/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.WurbletParameterOperand;
import org.tentackle.wurblet.WurbletParameterOperator;
import org.wurbelizer.wurbel.WurbelException;

public class WurbletParameterExpression
implements WurbletParameterOperand {
    private final WurbletParameterExpression parent;
    private final List<WurbletParameterOperand> operands;
    private final List<WurbletParameterOperator> operators;

    public WurbletParameterExpression(WurbletParameterExpression parent) {
        this.parent = parent;
        this.operands = new ArrayList<WurbletParameterOperand>();
        this.operators = new ArrayList<WurbletParameterOperator>();
    }

    public WurbletParameterExpression getParent() {
        return this.parent;
    }

    public List<WurbletParameterOperand> getOperands() {
        return this.operands;
    }

    public List<WurbletParameterOperator> getOperators() {
        return this.operators;
    }

    public void addOperand(WurbletParameterOperator operator, WurbletParameterOperand operand) throws WurbelException {
        if (operand == null) {
            throw new WurbelException("operand cannot be null");
        }
        if (this.operands.isEmpty()) {
            if (operator != null && operator != WurbletParameterOperator.NOT) {
                throw new WurbelException("operator " + (Object)((Object)operator) + " not allowed at start of expression");
            }
        } else if (operator == null) {
            operator = WurbletParameterOperator.AND;
        } else if (operator == WurbletParameterOperator.NOT) {
            if (!(operand instanceof WurbletParameterExpression)) {
                throw new WurbelException("operator NOT must be followed by an expression");
            }
            if (!this.operands.isEmpty()) {
                throw new WurbelException("operator NOT cannot follow an operand");
            }
        }
        if (operator != null) {
            this.operators.add(operator);
        }
        this.operands.add(operand);
    }

    public boolean needParenthesesAfterAndOperator() {
        return this.operators.contains((Object)WurbletParameterOperator.OR) || this.operators.contains((Object)WurbletParameterOperator.ORNOT);
    }

    public String toCode(CodeGenerator<Object> generator) throws WurbelException {
        StringBuilder buf = new StringBuilder();
        Iterator<WurbletParameterOperand> operandIter = this.operands.iterator();
        Iterator<WurbletParameterOperator> operatorIter = this.operators.iterator();
        if (!this.operators.isEmpty() && this.operands.size() == this.operators.size()) {
            buf.append(generator.generate((Object)operatorIter.next()));
        }
        while (operandIter.hasNext()) {
            buf.append(generator.generate(operandIter.next()));
            if (!operatorIter.hasNext()) continue;
            buf.append(generator.generate((Object)operatorIter.next()));
        }
        return buf.toString();
    }

    public String toString() {
        try {
            return this.toCode(t -> {
                if (t instanceof WurbletParameterOperator) {
                    WurbletParameterOperator operator = (WurbletParameterOperator)((Object)((Object)t));
                    if (operator == WurbletParameterOperator.NOT) {
                        return t + " ";
                    }
                    return " " + t + " ";
                }
                if (t instanceof WurbletParameterExpression) {
                    return "(" + t + ")";
                }
                return t.toString();
            });
        }
        catch (WurbelException ex) {
            return ex.getMessage();
        }
    }
}

