/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.wurblet.WurbletParameter;
import org.tentackle.wurblet.WurbletParameterExpression;
import org.tentackle.wurblet.WurbletParameterOperator;
import org.wurbelizer.wurbel.WurbelException;

public class WurbletParameterParser {
    private final List<String> optionArgs = new ArrayList<String>();
    private final WurbletParameterExpression expression = new WurbletParameterExpression(null);
    private final List<WurbletParameter> expressionParameters = new ArrayList<WurbletParameter>();
    private final List<WurbletParameter> sortingParameters = new ArrayList<WurbletParameter>();
    private final List<WurbletParameter> extraParameters;
    private List<WurbletParameter> methodParameters;
    private List<WurbletParameter> allParameters;
    private final List<String> joinNames = new ArrayList<String>();

    public WurbletParameterParser(List<String> args) throws WurbelException {
        this.extraParameters = new ArrayList<WurbletParameter>();
        this.parse(args);
    }

    public List<String> getOptionArgs() {
        return this.optionArgs;
    }

    public WurbletParameterExpression getExpression() {
        return this.expression;
    }

    public List<WurbletParameter> getExpressionParameters() {
        return this.expressionParameters;
    }

    public List<WurbletParameter> getSortingParameters() {
        return this.sortingParameters;
    }

    public List<WurbletParameter> getExtraParameters() {
        return this.extraParameters;
    }

    public List<WurbletParameter> getAllParameters() {
        if (this.allParameters == null) {
            this.allParameters = new ArrayList<WurbletParameter>(this.expressionParameters.size() + this.extraParameters.size() + this.sortingParameters.size());
            this.allParameters.addAll(this.expressionParameters);
            this.allParameters.addAll(this.extraParameters);
            this.allParameters.addAll(this.sortingParameters);
        }
        return this.allParameters;
    }

    public List<WurbletParameter> getMethodParameters() {
        if (this.methodParameters == null) {
            this.methodParameters = new ArrayList<WurbletParameter>(this.extraParameters.size() + this.expressionParameters.size());
            this.methodParameters.addAll(this.extraParameters);
            this.methodParameters.addAll(this.expressionParameters);
        }
        return this.methodParameters;
    }

    public List<String> getJoinNames() {
        return this.joinNames;
    }

    private void parse(List<String> args) throws WurbelException {
        int expressionLevel = 0;
        LinkedList<WurbletParameterOperator> operators = new LinkedList<WurbletParameterOperator>();
        WurbletParameterOperator operator = null;
        WurbletParameterExpression expr = this.expression;
        boolean expressionFinished = false;
        for (String arg : args) {
            if (arg == null) continue;
            if (arg.startsWith("--")) {
                this.optionArgs.add(arg.substring(2));
                continue;
            }
            if (arg.length() > 1 && arg.startsWith("*")) {
                this.joinNames.add(arg.substring(1));
                expressionFinished = true;
                continue;
            }
            if (expressionFinished) {
                WurbletParameter par = new WurbletParameter(arg);
                if (par.isSortKey()) {
                    this.sortingParameters.add(par);
                    continue;
                }
                this.extraParameters.add(par);
                continue;
            }
            Iterator<String> iterator = this.splitArg(arg).iterator();
            block11: while (iterator.hasNext()) {
                String subArg;
                switch (subArg = iterator.next()) {
                    case "(": {
                        expr = new WurbletParameterExpression(expr);
                        operators.push(operator);
                        operator = null;
                        ++expressionLevel;
                        continue block11;
                    }
                    case ")": {
                        if (--expressionLevel < 0) {
                            throw new WurbelException("unbalanced braces: more closed than opened");
                        }
                        WurbletParameterExpression parent = expr.getParent();
                        operator = (WurbletParameterOperator)((Object)operators.pop());
                        if (parent != null) {
                            parent.addOperand(operator, expr);
                            operator = null;
                        }
                        expr = parent;
                        continue block11;
                    }
                    case "|": {
                        if (expressionLevel == 0) {
                            expressionFinished = true;
                            continue block11;
                        }
                        throw new WurbelException("key group separator not allowed in nested expressions");
                    }
                }
                WurbletParameterOperator oper = WurbletParameterOperator.toInternal(subArg);
                if (oper != null) {
                    if (operator != null) {
                        if (oper == WurbletParameterOperator.NOT) {
                            if (operator == WurbletParameterOperator.AND) {
                                operator = WurbletParameterOperator.ANDNOT;
                                continue;
                            }
                            if (operator == WurbletParameterOperator.OR) {
                                operator = WurbletParameterOperator.ORNOT;
                                continue;
                            }
                        }
                        throw new WurbelException((Object)((Object)operator) + " cannot be followed by " + (Object)((Object)oper));
                    }
                    operator = oper;
                    continue;
                }
                WurbletParameter operand = new WurbletParameter(subArg);
                if (operand.isSortKey()) {
                    if (expressionLevel == 0) {
                        this.sortingParameters.add(operand);
                        expressionFinished = true;
                        continue;
                    }
                    throw new WurbelException("sorting key " + operand + " not allowed in nested expressions");
                }
                expr.addOperand(operator, operand);
                operator = null;
                this.expressionParameters.add(operand);
            }
        }
        if (expressionLevel > 0) {
            throw new WurbelException("unbalanced braces: more opened than closed");
        }
    }

    private List<String> splitArg(String arg) {
        ArrayList<String> strs = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean quoted = false;
        char c = '\u0000';
        for (int i = 0; i < arg.length(); ++i) {
            char cl = c;
            c = arg.charAt(i);
            if (quoted) {
                buf.append(c);
                quoted = false;
                continue;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (c == '(' && (i >= arg.length() - 1 || arg.charAt(i + 1) != ')') || c == ')' && cl != '(' || c == '|') {
                String str = buf.toString().trim();
                if (!BasicStringHelper.isAllWhitespace((String)str)) {
                    strs.add(str);
                }
                buf.setLength(0);
                buf.append(c);
                strs.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        String str = buf.toString().trim();
        if (!BasicStringHelper.isAllWhitespace((String)str)) {
            strs.add(str);
        }
        return strs;
    }
}

