/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;

public class ModelCommentSupport {
    public static void printVia(Relation relation, PrintStream out) {
        out.print(" via ");
        if (relation.getAttribute() != null) {
            out.print(relation.getAttribute());
        } else if (relation.getForeignEntity() != null && relation.getForeignAttribute() != null) {
            String entityName = relation.getForeignEntity().getName();
            if (relation.getForeignEntity().getTableAlias() != null) {
                entityName = relation.getForeignEntity().getTableAlias();
            }
            out.print(entityName);
            out.print('.');
            out.print(relation.getForeignAttribute());
        } else if (!relation.getMethodArgs().isEmpty()) {
            out.print(relation.getMethodArgs().get(0));
        } else {
            out.print("?");
        }
        if (relation.getMethodArgs().size() > 1) {
            boolean firstSkipped = false;
            for (MethodArgument arg : relation.getMethodArgs()) {
                if (firstSkipped) {
                    out.print(" & ");
                    out.print(arg);
                }
                firstSkipped = true;
            }
        }
    }

    public static void printReferencedBy(Entity entity, Relation relation, String indent, PrintStream out) {
        Entity referencingEntity = relation.getEntity();
        Set roots = referencingEntity.getRootEntities();
        if (roots.size() != 1 || !roots.contains(entity)) {
            out.print(indent);
            out.print(referencingEntity);
            ModelCommentSupport.printRootEntities(referencingEntity, roots, out);
            if (relation.isDeepReference()) {
                out.print(" deeply");
            }
            Relation nmRel = relation.getNmRelation();
            Relation rel = relation;
            if (nmRel == null && relation.getForeignRelation() != null && (nmRel = relation.getForeignRelation().getNmRelation()) != null) {
                rel = relation.getForeignRelation();
            }
            if (nmRel != null && !entity.equals(relation.getForeignEntity())) {
                out.print(" via ");
                out.print(relation.getForeignEntity());
                out.print(" as ");
                out.print(relation.getName());
                out.println(" [N:M]");
            } else {
                ModelCommentSupport.printVia(relation, out);
                if (!relation.getName().equalsIgnoreCase(referencingEntity.toString())) {
                    out.print(" as " + relation.getVariableName());
                }
                if (relation.getRelationType() == RelationType.LIST) {
                    out.println(" [1:N]");
                } else {
                    out.println(" [1:1]");
                }
            }
        }
    }

    public static void printComponents(Set<Relation> allRelations, Collection<Relation> compositeRelations, Collection<Entity> subEntities, String indent, PrintStream out) {
        for (Relation relation : compositeRelations) {
            boolean relationNotAlreadyPrinted = allRelations.add(relation);
            Entity component = relation.getForeignEntity();
            if (relationNotAlreadyPrinted) {
                for (Entity sub : subEntities) {
                    if (sub.getComponents().isEmpty()) continue;
                    out.print(indent);
                    out.print("^ ");
                    out.println(sub);
                    ArrayList<Relation> subCompositeRelations = new ArrayList<Relation>();
                    for (Relation subRelation : sub.getRelationsIncludingInherited()) {
                        if (!subRelation.isComposite()) continue;
                        subCompositeRelations.add(subRelation);
                    }
                    ModelCommentSupport.printComponents(allRelations, subCompositeRelations, sub.getSubEntities(), indent + "    ", out);
                }
            }
            out.print(indent);
            out.print("+ ");
            out.print(component);
            ModelCommentSupport.printVia(relation, out);
            if (!relation.getName().equalsIgnoreCase(component.toString())) {
                out.print(" as " + StringHelper.firstToLower((String)relation.getName()));
            }
            if (relation.getNmRelation() != null) {
                out.print(" [N:M] to ");
                Entity nmEntity = relation.getNmRelation().getForeignEntity();
                out.print(nmEntity);
                if (relation.getNmMethodName() != null && !relation.getNmMethodName().equalsIgnoreCase(nmEntity.toString())) {
                    out.print(" as " + StringHelper.firstToLower((String)relation.getNmMethodName()));
                }
            } else if (relation.getRelationType() == RelationType.LIST) {
                out.print(" [1:N]");
            } else {
                out.print(" [1:1]");
            }
            ArrayList<Relation> componentCompositeRelations = new ArrayList<Relation>();
            for (Relation subRelation : component.getRelationsIncludingInherited()) {
                if (!subRelation.isComposite()) continue;
                componentCompositeRelations.add(subRelation);
            }
            if (relationNotAlreadyPrinted) {
                out.println();
                ModelCommentSupport.printComponents(allRelations, componentCompositeRelations, component.getSubEntities(), indent + "    ", out);
                continue;
            }
            if (relation.getForeignEntity().isComposite()) {
                out.println(" ...");
                continue;
            }
            out.println();
        }
    }

    public static void printSubEntities(Collection<Entity> subEntities, String indent, PrintStream out) {
        for (Entity sub : subEntities) {
            out.print(indent);
            out.print("^ ");
            out.println(sub);
            ModelCommentSupport.printSubEntities(sub.getSubEntities(), indent + "    ", out);
        }
    }

    public static void printNonCompositeRelations(Entity entity, List<Relation> relations, boolean rootsFromForeignEntity, String indent, PrintStream out) {
        ArrayList<Relation> sortedRelations = new ArrayList<Relation>();
        for (Relation relation : relations) {
            if (relation.isComposite() || relation.getForeignEntity().equals(entity)) continue;
            sortedRelations.add(relation);
        }
        Collections.sort(sortedRelations, (o1, o2) -> o1.getForeignEntity().getName().compareTo(o2.getForeignEntity().getName()));
        for (Relation relation : sortedRelations) {
            out.print(indent);
            out.print(relation.getForeignEntity());
            if (rootsFromForeignEntity) {
                ModelCommentSupport.printRootEntities(entity, relation.getForeignEntity().getRootEntities(), out);
            }
            if (!relation.getEntity().equals(entity)) {
                out.print(" from ");
                out.print(relation.getEntity());
                if (!rootsFromForeignEntity) {
                    ModelCommentSupport.printRootEntities(relation.getEntity(), relation.getEntity().getRootEntities(), out);
                }
            }
            ModelCommentSupport.printVia(relation, out);
            if (relation.isReversed()) {
                out.print(" reversed");
            }
            if (relation.isDeepReference()) {
                out.print(" deeply");
            }
            if (relation.getRelationType() == RelationType.LIST && !relation.isReversed()) {
                out.print(" [1:N]");
            } else {
                Relation nmRel = relation.getDefiningNmRelation();
                if (nmRel != null && entity.equals(nmRel.getEntity())) {
                    out.print(" [N:M]");
                } else {
                    out.print(" [1:1]");
                }
            }
            out.println();
        }
    }

    private static void printRootEntities(Entity entity, Collection<Entity> rootEntities, PrintStream out) {
        ArrayList<Entity> roots = new ArrayList<Entity>(rootEntities);
        if (roots.size() == 1 && entity.equals(roots.get(0))) {
            roots.clear();
        }
        if (!roots.isEmpty()) {
            Collections.sort(roots, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            out.print(" (");
            boolean needComma = false;
            for (Entity rootEntity : roots) {
                if (needComma) {
                    out.print(", ");
                } else {
                    needComma = true;
                }
                out.print(rootEntity);
            }
            out.print(")");
        }
    }

    private ModelCommentSupport() {
    }
}

