/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendFactory;
import org.tentackle.wurblet.TentackleWurbletsModel;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelTerminationException;
import org.wurbelizer.wurblet.AbstractWurblet;

public class ModelWurblet
extends AbstractWurblet {
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\s*([\\w\\.]+)\\.class");
    private String modelDirName;
    private List<String> otherModelDirNames;
    private String modelName;
    private Entity entity;
    private List<String> args;
    private List<String> optionArgs;
    private List<String> wurbletArgs;
    private Boolean isPdo;
    private boolean remote;
    private String pdoClassName;

    public String getModelDirName() {
        return this.modelDirName;
    }

    public String getPdoClassName() throws WurbelException {
        if (this.isPdo == null) {
            int ndx;
            String annotation;
            this.isPdo = false;
            int ndx2 = 0;
            while ((annotation = this.getContainer().getProperty("wurblet", "annotation_" + ndx2)) != null) {
                if (annotation.startsWith("@DomainObjectService") || annotation.startsWith("@PersistentObjectService")) {
                    Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
                    if (matcher.find()) {
                        this.pdoClassName = matcher.group(1);
                        if (this.getContainer().getVerbosity().isDebug()) {
                            this.getContainer().getLogger().info("pdoClassName: " + this.pdoClassName);
                        }
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                    throw new WurbelException("malformed annotation: " + annotation);
                }
                ++ndx2;
            }
            String persistentIface = this.getContainer().getProperty("wurblet", "extends_0");
            if (persistentIface != null && (ndx = persistentIface.indexOf(60)) > 0 && (ndx = (persistentIface = persistentIface.substring(ndx + 1)).lastIndexOf(62)) > 0) {
                this.pdoClassName = persistentIface.substring(0, ndx);
                if (this.pdoClassName.length() > 1 && this.pdoClassName.indexOf(60) < 0) {
                    this.isPdo = true;
                    return this.pdoClassName;
                }
            }
            this.pdoClassName = this.getContainer().getProperty("wurblet", "definition");
            if (this.pdoClassName != null) {
                if (this.getContainer().getVerbosity().isDebug()) {
                    this.getContainer().getLogger().info(this.getContainer().getProperty("wurblet", "classname") + ": definition = '" + this.pdoClassName + "'");
                }
                if ((ndx = this.pdoClassName.indexOf("extends")) >= 0) {
                    int ndx1 = this.pdoClassName.indexOf(60);
                    int ndx22 = this.pdoClassName.indexOf(44);
                    if (ndx1 > ndx && ndx22 > ndx1) {
                        this.pdoClassName = this.pdoClassName.substring(ndx1 + 1, ndx22).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
                if ((ndx = this.pdoClassName.indexOf("T extends")) >= 0) {
                    this.pdoClassName = this.pdoClassName.substring(ndx + 9);
                    ndx = this.pdoClassName.indexOf(60);
                    if (ndx > 0) {
                        this.pdoClassName = this.pdoClassName.substring(0, ndx).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
            }
        }
        if (this.isPdo.booleanValue()) {
            return this.pdoClassName;
        }
        this.pdoClassName = this.getContainer().getProperty("wurblet", "interfacename");
        if (this.pdoClassName != null) {
            return this.pdoClassName;
        }
        throw new WurbelException("cannot determine the pdo-class from the java-source");
    }

    public boolean isPdo() {
        if (this.isPdo == null) {
            try {
                this.getPdoClassName();
            }
            catch (WurbelException wurbelException) {
                // empty catch block
            }
        }
        return this.isPdo;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isPartOfInheritanceHierarchy() {
        return this.isPdo() && this.getEntity().getTopSuperEntity().isAbstract();
    }

    public boolean isGenerified() {
        String definition = this.getContainer().getProperty("wurblet", "definition");
        return definition != null && definition.startsWith("<");
    }

    public String getMethodName() throws WurbelException {
        String methodName = this.getOption("method");
        if (methodName == null) {
            methodName = this.getGuardName();
        }
        return methodName;
    }

    public String getModelName() throws WurbelException {
        if (this.modelName == null) {
            this.modelName = this.getOption("model");
            if (this.modelName == null) {
                this.modelName = this.getPdoClassName();
            }
            if (this.modelName == null) {
                throw new WurbelException("model not specified");
            }
        }
        return this.modelName;
    }

    public String deriveClassNameForEntity(Entity otherEntity) throws WurbelException {
        String entityName;
        String className = this.getClassName();
        int ndx = className.indexOf(entityName = this.getEntity().getName());
        if (ndx < 0) {
            throw new WurbelException(className + " does not contain the entity name '" + entityName + "' substring");
        }
        String lead = className.substring(0, ndx);
        String tail = className.substring(ndx + entityName.length());
        return lead + otherEntity.getName() + tail;
    }

    public List<Entity> orderByInheritanceLevelAndClassId(List<Entity> entities) {
        Collections.sort(entities, (o1, o2) -> {
            int rv = o1.getInheritanceLevel() - o2.getInheritanceLevel();
            if (rv == 0) {
                rv = Long.compare(o1.getClassId(), o2.getClassId());
            }
            return rv;
        });
        return entities;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getOptionArgs() {
        return this.optionArgs;
    }

    public String getOption(String option) {
        int equalsOffset = option.length();
        for (String arg : this.getOptionArgs()) {
            if (arg.equals(option)) {
                return "";
            }
            if (!arg.startsWith(option) || arg.charAt(equalsOffset) != '=') continue;
            return arg.substring(equalsOffset + 1);
        }
        return null;
    }

    public List<String> getWurbletArgs() {
        return this.wurbletArgs;
    }

    public String createRelationSelectMethodName(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("select");
        if (relation.getMethodName() != null) {
            if (relation.getRelationType() == RelationType.LIST) {
                text.append("By");
            }
            text.append(relation.getMethodName());
        } else if (relation.getRelationType() == RelationType.LIST) {
            text.append("By");
            for (MethodArgument arg : relation.getMethodArgs()) {
                text.append(StringHelper.firstToUpper((String)arg.getForeignAttribute().getName()));
            }
        } else if (relation.isSelectionCached()) {
            text.append("Cached");
        }
        return text.toString();
    }

    public String createListRelationDeleteMethodName(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("deleteBy");
        if (relation.getMethodName() != null) {
            text.append(relation.getMethodName());
        } else {
            for (MethodArgument arg : relation.getMethodArgs()) {
                text.append(StringHelper.firstToUpper((String)arg.getForeignAttribute().getName()));
            }
        }
        return text.toString();
    }

    public String createDeclaredArgsForSelectOrDeleteMethod(Relation relation) throws ModelException {
        StringBuilder text = new StringBuilder();
        for (MethodArgument arg : relation.getMethodArgs()) {
            if (text.length() > 0) {
                text.append(", ");
            }
            Attribute attr = arg.getForeignAttribute();
            text.append(attr.getJavaType()).append(' ').append(attr.getName());
        }
        return text.toString();
    }

    public void run() throws WurbelException {
        ModelException mex;
        WurbelException wex;
        Object wex2;
        String backends;
        super.run();
        this.args = Arrays.asList(this.container.getArgs());
        this.wurbletArgs = new ArrayList<String>();
        this.optionArgs = new ArrayList<String>();
        for (String arg : this.args) {
            if (arg == null) continue;
            if (arg.startsWith("--")) {
                this.optionArgs.add(arg.substring(2));
                continue;
            }
            this.wurbletArgs.add(arg);
        }
        this.modelDirName = this.getContainer().getProperty("extra", "model");
        if (this.modelDirName == null) {
            throw new WurbelException("missing wurblet property 'model'");
        }
        File modelDir = new File(this.modelDirName);
        if (!modelDir.exists()) {
            this.getContainer().getLogger().info("creating " + modelDir);
            modelDir.mkdirs();
        }
        if (!modelDir.isDirectory()) {
            throw new WurbelException(modelDir + " is not a directory");
        }
        String otherModels = this.getContainer().getProperty("extra", "otherModels");
        if (otherModels != null) {
            this.otherModelDirNames = new ArrayList<String>();
            StringTokenizer stok = new StringTokenizer(otherModels, " \t\n\r\f,");
            while (stok.hasMoreTokens()) {
                this.otherModelDirNames.add(stok.nextToken());
            }
        }
        if ((backends = this.getContainer().getProperty("extra", "backends")) != null) {
            ArrayList<Backend> backendList = new ArrayList<Backend>();
            if ("all".equalsIgnoreCase(backends)) {
                backendList.addAll(BackendFactory.getInstance().getAllBackends());
            } else if (!"none".equalsIgnoreCase(backends)) {
                for (String backend : backends.split(",")) {
                    backendList.add(BackendFactory.getInstance().getBackendByName(backend.trim()));
                }
            }
            Model.getInstance().getEntityFactory().setBackends(backendList);
        }
        ModelDefaults modelDefaults = null;
        String modelDefaultsStr = this.getContainer().getProperty("extra", "modelDefaults");
        if (modelDefaultsStr != null) {
            try {
                modelDefaults = new ModelDefaults(modelDefaultsStr);
            }
            catch (ModelException mex2) {
                throw new WurbelException(mex2.getMessage(), (Throwable)mex2);
            }
        }
        EntityAliases entityAliases = null;
        String entityAliasesStr = this.getContainer().getProperty("extra", "entityAliases");
        if (entityAliasesStr != null) {
            try {
                entityAliases = new EntityAliases(entityAliasesStr);
            }
            catch (ModelException mex3) {
                throw new WurbelException(mex3.getMessage(), (Throwable)mex3);
            }
        }
        Model model = Model.getInstance();
        try {
            if (this.otherModelDirNames != null) {
                for (String otherModelDirName : this.otherModelDirNames) {
                    model.loadModel(otherModelDirName, modelDefaults, entityAliases);
                }
            }
            model.loadModel(this.modelDirName, modelDefaults, entityAliases);
        }
        catch (ModelException mex4) {
            wex2 = new WurbelTerminationException("errors in model loaded from directory '" + this.modelDirName + "'", true, (Throwable)mex4);
            if (model instanceof TentackleWurbletsModel && mex4.getElement() != null && ((TentackleWurbletsModel)model).getLoadingException() == null) {
                ((TentackleWurbletsModel)model).setLoadingException((WurbelException)((Object)wex2));
            }
            throw wex2;
        }
        try {
            this.entity = this.getModelName().indexOf(File.separatorChar) >= 0 ? model.loadByFileName(this.getModelName(), modelDefaults, entityAliases) : model.getByEntityName(this.getModelName());
        }
        catch (ModelException mex5) {
            throw new WurbelException("errors in model loaded from file '" + this.getModelName() + "'", (Throwable)mex5);
        }
        if (this.entity == null) {
            Throwable delayedModelException = null;
            if (model instanceof TentackleWurbletsModel && (wex2 = ((TentackleWurbletsModel)model).getLoadingException()) != null) {
                delayedModelException = wex2.getCause();
            }
            throw new WurbelException("no such entity '" + this.getModelName() + "' in model " + modelDir, delayedModelException);
        }
        this.remote = this.entity.getOptions().isRemote();
        if (this.getOption("remote") != null) {
            this.remote = true;
        }
        if (this.getOption("noremote") != null) {
            this.remote = false;
        }
        if (model instanceof TentackleWurbletsModel && (wex = ((TentackleWurbletsModel)model).getLoadingException()) != null && wex.getCause() instanceof ModelException && (mex = (ModelException)wex.getCause()).isRelatedTo((ModelElement)this.entity)) {
            throw wex;
        }
    }

    public boolean isIdAttribute(Attribute attribute) {
        return attribute.getName().equals("id");
    }

    public boolean isSerialAttribute(Attribute attribute) {
        return attribute.getName().equals("serial");
    }

    public boolean isIdOrSerialAttribute(Attribute attribute) {
        return this.isIdAttribute(attribute) || this.isSerialAttribute(attribute);
    }

    public boolean isAttributeDerived(Attribute attribute) {
        return attribute.getOptions().isDerived() || attribute.getEntity() != this.entity;
    }

    public boolean isSetGetRequired(Attribute attribute) {
        return attribute.getOptions().isSetGet() || this.isAttributeDerived(attribute);
    }

    public void appendCommaSeparated(StringBuilder builder, String appendStr) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(appendStr);
    }

    public void prependCommaSeparated(StringBuilder builder, String prependStr) {
        if (builder.length() > 0) {
            builder.insert(0, ", ");
        }
        builder.insert(0, prependStr);
    }
}

