// wurblet generated by Wurbelizer 2.1.1, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate relation method definitions of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Relations
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class Relations extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {
    // create comment for referencing relations
    List<Relation> referencingRelations = getEntity().getReferencingRelationsIncludingSubEntities();
    out.print(source[0]); // 14:2 = "  /**   * "
    out.print(getEntity());
    out.print(source[1]); // 17:20 = " "
    out.print(referencingRelations.isEmpty() ? "is not referenced by any other entity!" : "is referenced by:");
    out.print(source[2]); // 17:120 = ""
    for (Relation rel: referencingRelations) {
      out.print(source[3]); // 20:2 = "   * "
      out.print(rel);
      out.print(source[4]); // 21:12 = ""
    }
    out.print(source[5]); // 24:2 = "   */"

    for (Relation rel: getEntity().getRelations()) {

      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }

      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType();
      String firstArg = rel.getMethodArgs().get(0).getMethodArgument();
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        // take from attribute
        createGetter &= !attr.getOptions().isWriteOnly();
        createSetter &= !attr.getOptions().isReadOnly();
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      // getter

      if (createGetter)  {
        String checkNull = firstArg + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = firstArg + " == null || " + checkNull;
        }
        out.print(source[6]); // 69:2 = "  /**   * Gets "
        out.print(rel);
        out.print(source[7]); // 72:17 = ".   *   * @return "
        out.print(var);
        out.print(source[8]); // 74:21 = " "
        out.print(rel.getComment());
        out.print(source[9]); // 74:42 = "   */  @Bindable"
        if (!rel.isComposite()) {
          out.print(source[10]); // 79:2 = "  @Persistent(value="
          out.print(StringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[11]); // 80:70 = ", component=false)"
        }
        else {
          out.print(source[12]); // 84:2 = "  @Persistent("
          out.print(StringHelper.toDoubleQuotes(rel.getComment()));
          out.print(source[13]); // 85:64 = ")"
        }
        for (String annotation: rel.getAnnotations()) {
          out.print(source[14]); // 89:2 = "  "
          out.print(annotation);
          out.print(source[15]); // 90:16 = ""
        }
        out.print(source[16]); // 93:2 = "  "
        out.print(type);
        out.print(source[17]); // 94:10 = " "
        out.print(rel.getGetterName());
        out.print(source[18]); // 94:34 = "();"
        if (nmRel != null) {
          out.print(source[19]); // 97:2 = "  /**   * Gets list of "
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[20]); // 100:49 = " joined via "
          out.print(rel);
          out.print(source[21]); // 100:68 = ".   *   * @return list of "
          out.print(nmRel.getVariableName());
          out.print(source[22]); // 102:49 = "   */  @Bindable  @Persistent(value="
          out.print(StringHelper.toDoubleQuotes(nmVar));
          out.print(source[23]); // 105:59 = ", component=false)  TrackedList<"
          out.print(nmRel.getDeclaredJavaType());
          out.print(source[24]); // 106:45 = "> get"
          out.print(nmName);
          out.print(source[25]); // 106:60 = "();"
        }

        if (rel.isComposite() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
              out.print(source[26]); // 112:2 = "  /**   * Returns whether "
              out.print(rel.getName());
              out.print(source[27]); // 115:38 = " is loaded.   *   * @return true if "
              out.print(rel.getGetterName());
              out.print(source[28]); // 117:45 = "() invoked at least once   */  @Bindab..."
              out.print(StringHelper.firstToUpper(var));
              out.print(source[29]); // 120:46 = "Loaded();"
        }
      }


      if (createSetter)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        boolean linkMethodIndexed = rel.getForeignRelation() != null ?
            rel.getForeignRelation().getLinkMethodIndex() != null : false;

            out.print(source[30]); // 131:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[31]); // 134:17 = ".   *   * @param "
            out.print(var);
            out.print(source[32]); // 136:20 = " "
            out.print(rel.getComment());
            out.print(source[33]); // 136:41 = ""
        if (linkMethodIndexed) {
          out.print(source[34]); // 139:2 = "   * @param index the index starting at ..."
        }
        out.print(source[35]); // 143:2 = "   */"
        if (attr != null && attr.getOptions().isBind()) {
          out.print(source[36]); // 147:2 = "  "
          out.print(attr.getBindableAnnotation());
          out.print(source[37]); // 148:34 = ""
        }
        if (linkMethodIndexed) {
          out.print(source[38]); // 152:2 = "  void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[39]); // 153:55 = "("
          out.print(type);
          out.print(source[40]); // 153:64 = " "
          out.print(var);
          out.print(source[41]); // 153:72 = ", int index);"
        }
        else {
          out.print(source[42]); // 157:2 = "  void "
          out.print(rel.getSetterName());
          out.print(source[43]); // 158:30 = "("
          out.print(type);
          out.print(source[44]); // 158:39 = " "
          out.print(var);
          out.print(source[45]); // 158:47 = ");"
        }
      }
    }

    // creates the select- and delete-methods for list relations in foreign entities
    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());
    Set<String> declaredArgSet = new HashSet<>();   // to avoid duplicates if args= is used

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (rel.getAccessScope() != AccessScope.PUBLIC) {
        continue;   // skip non-public in interfaces
      }
      if (rel.getRelationType() == RelationType.LIST) {
        Attribute attribute = rel.getForeignAttribute();
        if (attribute != null) {
          String declaredArgs = createDeclaredArgsForSelectOrDeleteMethod(rel);
          if (declaredArgSet.add(declaredArgs)) {
            out.print(source[46]); // 178:2 = "  /**   * Selects "
            out.print(rel);
            out.print(source[47]); // 181:20 = ".   *"
            for (MethodArgument arg : rel.getMethodArgs()) {
              Attribute attr = arg.getForeignAttribute();
              out.print(source[48]); // 186:2 = "   * @param "
              out.print(attr.getName());
              out.print(source[49]); // 187:31 = " "
              out.print(attr.getOptions().getComment());
              out.print(source[50]); // 187:66 = ""
            }
            out.print(source[51]); // 190:2 = "   * @return "
            out.print(rel.getComment());
            out.print(source[52]); // 191:34 = "   */  "
            out.print(rel.getDeclaredJavaType());
            out.print(source[53]); // 193:31 = " "
            out.print(createRelationSelectMethodName(rel));
            out.print(source[54]); // 193:71 = "("
            out.print(declaredArgs);
            out.print(source[55]); // 193:88 = ");"
            if (rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
              out.print(source[56]); // 196:2 = "  /**   * Deletes "
              out.print(rel);
              out.print(source[57]); // 199:20 = ".   *"
              for (MethodArgument arg : rel.getMethodArgs()) {
                Attribute attr = arg.getForeignAttribute();
                out.print(source[58]); // 204:2 = "   * @param "
                out.print(attr.getName());
                out.print(source[59]); // 205:31 = " "
                out.print(attr.getOptions().getComment());
                out.print(source[60]); // 205:66 = ""
              }
              out.print(source[61]); // 208:2 = "   * @return "
              out.print(rel.getComment());
              out.print(source[62]); // 209:34 = "   */  int "
              out.print(createListRelationDeleteMethodName(rel));
              out.print(source[63]); // 211:49 = "("
              out.print(declaredArgs);
              out.print(source[64]); // 211:66 = ");"
            }
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
