// wurblet generated by Wurbelizer 2.1.1, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> option to generate code according to the builder pattern.</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * This option is ignored in builder pattern mode.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=", the property is mutable and a setter is generated.<br>
 * Example:
 * <pre>
 * =String name   the name
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        if (property.isMutable()) {
          out.print(source[0]); // 52:2 = "  private "
          out.print(property.getType());
          out.print(source[1]); // 53:32 = " "
          out.print(property.getName());
          out.print(source[2]); // 53:55 = ";  // "
          out.print(property.getComment());
          out.print(source[3]); // 53:86 = ""
        }
        else {
          out.print(source[4]); // 57:2 = "  private final "
          out.print(property.getType());
          out.print(source[5]); // 58:38 = " "
          out.print(property.getName());
          out.print(source[6]); // 58:61 = ";  // "
          out.print(property.getComment());
          out.print(source[7]); // 58:92 = ""
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[8]); // 66:2 = ""
      if (!withBuilder) {
        out.print(source[9]); // 70:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[10]); // 72:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[11]); // 77:2 = "   * @param "
            out.print(property.getName());
            out.print(source[12]); // 78:35 = " "
            out.print(property.getComment());
            out.print(source[13]); // 78:61 = ""
          }
        }
        out.print(source[14]); // 82:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[15]); // 109:2 = "  protected "
        out.print(getClassName());
        out.print(source[16]); // 110:30 = "(Builder builder) {"
        if (extendsWithBuilder != null) {
          out.print(source[17]); // 113:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[18]); // 119:2 = "    this."
            out.print(property.getName());
            out.print(source[19]); // 120:31 = " = builder."
            out.print(property.getName());
            out.print(source[20]); // 120:64 = ";"
          }
        }
        out.print(source[21]); // 124:2 = "  }"
      }
      else {
        out.print(source[22]); // 129:2 = "  public "
        out.print(getClassName());
        out.print(source[23]); // 130:27 = "("
        out.print(args.toString());
        out.print(source[24]); // 130:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[25]); // 133:2 = "    super("
          out.print(superArgs);
          out.print(source[26]); // 134:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[27]); // 139:2 = "    this."
            out.print(property.getName());
            out.print(source[28]); // 140:31 = " = "
            out.print(property.getName());
            out.print(source[29]); // 140:56 = ";"
          }
        }
        out.print(source[30]); // 144:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[31]); // 153:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[32]); // 156:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[33]); // 158:39 = "   */  public "
        out.print(property.getType());
        out.print(source[34]); // 160:31 = " "
        out.print(property.getGetterName());
        out.print(source[35]); // 160:60 = "() {    return "
        out.print(property.getName());
        out.print(source[36]); // 161:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[37]); // 170:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[38]); // 173:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[39]); // 175:35 = " "
        out.print(property.getComment());
        out.print(source[40]); // 175:61 = "   */  public void "
        out.print(property.getSetterName());
        out.print(source[41]); // 177:42 = "("
        out.print(property.getType());
        out.print(source[42]); // 177:65 = " "
        out.print(property.getName());
        out.print(source[43]); // 177:88 = ") {    this."
        out.print(property.getName());
        out.print(source[44]); // 178:31 = " = "
        out.print(property.getName());
        out.print(source[45]); // 178:56 = ";  }"
      }
    }

    if (withBuilder) {
      String extendsStr = "";
      if (extendsWithBuilder != null) {
        extendsStr = "extends " + extendsWithBuilder + ".Builder ";
      }
      out.print(source[46]); // 189:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[47]); // 193:33 = " builder.   *   * @return the builder..."
      out.print(getClassName());
      out.print(source[48]); // 202:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[49]); // 204:44 = "{"
      for (Property property: properties) {
        out.print(source[50]); // 208:2 = "    private "
        out.print(property.getType());
        out.print(source[51]); // 209:34 = " "
        out.print(property.getName());
        out.print(source[52]); // 209:57 = ";  // "
        out.print(property.getComment());
        out.print(source[53]); // 209:88 = ""
      }
      out.print(source[54]); // 212:2 = "    protected Builder() {}    /**  ..."
      out.print(getClassName());
      out.print(source[55]); // 218:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[56]); // 220:38 = "     */"
      if (extendsWithBuilder != null) {
        out.print(source[57]); // 224:2 = "    @Override"
      }
      out.print(source[58]); // 228:2 = "    public "
      out.print(getClassName());
      out.print(source[59]); // 229:29 = " build() {      return new "
      out.print(getClassName());
      out.print(source[60]); // 230:35 = "(this);    }"
      for (Property property: properties) {
        out.print(source[61]); // 235:2 = "    /**     * Sets "
        out.print(property.getComment());
        out.print(source[62]); // 238:37 = ".     *     * @param "
        out.print(property.getName());
        out.print(source[63]); // 240:37 = " "
        out.print(property.getComment());
        out.print(source[64]); // 240:63 = "     */    public Builder "
        out.print(property.getName());
        out.print(source[65]); // 242:41 = "("
        out.print(property.getType());
        out.print(source[66]); // 242:64 = " "
        out.print(property.getName());
        out.print(source[67]); // 242:87 = ") {      this."
        out.print(property.getName());
        out.print(source[68]); // 243:33 = " = "
        out.print(property.getName());
        out.print(source[69]); // 243:58 = ";      return this;    }"
      }
      out.print(source[70]); // 248:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
