// wurblet generated by Wurbelizer 2.1.1, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate getter and setter definitions of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Methods [--noudk]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noudk:</em> don't generate selectByUniqueDomainKey method definition.</li>
 * </ul>
 * For more options, see {@link ModelWurblet}.
 */
public class Methods extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException, WurbelException {

    boolean generateSelectByUDK = getOption("noudk") == null;

    for (Attribute attr: getEntity().getAttributes())  {

      if (attr.getOptions().getAccessScope() != AccessScope.PUBLIC ||
          attr.getOptions().isFromSuper() ||
          attr.getOptions().isHidden()) {
        continue; // skip
      }

      if (attr.getOptions().isNoMethod())    {
        out.print(source[0]); // 28:2 = "  // no accessor methods for "
        out.print(attr);
        out.print(source[1]); // 30:37 = "  // "
        out.print(attr.getOptions().getComment());
        out.print(source[2]); // 31:39 = ""
      }
      else {
        String type = attr.getJavaType();
        String methodSuffix = attr.getMethodNameSuffix();
        String getter = attr.getGetterName();
        String setter = attr.getSetterName();
        if (attr.getOptions().isWriteOnly()) {
          out.print(source[3]); // 40:2 = "  // "
          out.print(attr);
          out.print(source[4]); // 42:13 = " is writeonly, no getter."
        }
        else  {
          out.print(source[5]); // 46:2 = "  /**   * Gets the attribute "
          out.print(attr);
          out.print(source[6]); // 49:32 = ".   *   * @return "
          out.print(attr.getOptions().getComment());
          out.print(source[7]); // 51:48 = "   */  @Persistent("
          out.print(StringHelper.toDoubleQuotes(attr.getOptions().getComment()));
          out.print(source[8]); // 53:78 = ")"
          for (String annotation: attr.getOptions().getAnnotations()) {
            out.print(source[9]); // 56:2 = "  "
            out.print(annotation);
            out.print(source[10]); // 57:16 = ""
          }
          if (attr.getOptions().isBind()) {
            out.print(source[11]); // 61:2 = "  "
            out.print(attr.getBindableAnnotation());
            out.print(source[12]); // 62:34 = ""
          }
          if (attr.getOptions().isDomainKey()) {
            out.print(source[13]); // 66:2 = "  @DomainKey"
          }
          out.print(source[14]); // 70:2 = "  "
          out.print(type);
          out.print(source[15]); // 71:10 = " "
          out.print(getter);
          out.print(source[16]); // 71:21 = "();"
        }

        if (attr.getOptions().isReadOnly()) {
          out.print(source[17]); // 76:2 = "  // "
          out.print(attr);
          out.print(source[18]); // 78:13 = " is readonly, no setter."
        }
        else {
          // check to make setter for lazy or eager object relations hidden to the application
          Relation rel = attr.getRelation();
          if (rel == null || rel.getSelectionType() == SelectionType.ALWAYS) {
            out.print(source[19]); // 85:2 = "  /**   * Sets the attribute "
            out.print(attr);
            out.print(source[20]); // 88:32 = ".   *   * @param "
            out.print(attr.getName());
            out.print(source[21]); // 90:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[22]); // 90:66 = "   */"
            if (attr.getOptions().isBind()) {
              out.print(source[23]); // 94:2 = "  @Bindable"
            }
            out.print(source[24]); // 98:2 = "  void "
            out.print(setter);
            out.print(source[25]); // 99:17 = "("
            out.print(type);
            out.print(source[26]); // 99:26 = " "
            out.print(attr.getName());
            out.print(source[27]); // 99:45 = ");"
          }
          if (getEntity().getOptions().getTrackType().isAttracked()) {
            out.print(source[28]); // 103:2 = "  /**   * Gets the modification state ..."
            out.print(attr);
            out.print(source[29]); // 106:44 = ".   *   * @return true if modified   ..."
            out.print(methodSuffix);
            out.print(source[30]); // 110:28 = "Modified();"
          }
          if (getEntity().getOptions().getTrackType() == TrackType.FULLTRACKED) {
            out.print(source[31]); // 114:2 = "  /**   * Gets the last persisted valu..."
            out.print(attr);
            out.print(source[32]); // 117:46 = ".   *   * @return the last persisted v..."
            out.print(attr.getJavaType());
            out.print(source[33]); // 121:24 = " "
            out.print(getter);
            out.print(source[34]); // 121:35 = "Persisted();"
          }
        }
        if (attr.getOptions().isWithTimezone()) {
          out.print(source[35]); // 126:2 = "  /**   * Gets the database timezone f..."
          out.print(attr);
          out.print(source[36]); // 129:44 = ".   *   * @return the timezone configu..."
          out.print(methodSuffix);
          out.print(source[37]); // 133:30 = "TimezoneConfig();"
        }
      }
    }

    if (isPdo() && generateSelectByUDK) {
      List<Attribute> udk = getEntity().getUniqueDomainKey();
      if (!udk.isEmpty()) {
        List<Attribute> superUdk = null;
        if (getEntity().getSuperEntity() != null) {
          superUdk = getEntity().getSuperEntity().getUniqueDomainKey();
        }
        if (superUdk == null || !udk.equals(superUdk)) {
          out.print(source[38]); // 147:2 = "  /**   * Selects "
          out.print(getEntity());
          out.print(source[39]); // 150:28 = " by its unique domain key.   *"
          String returnType = isGenerified() ? "T" : getPdoClassName();
          StringBuilder params = new StringBuilder();
          for (Attribute attr: udk) {
            appendCommaSeparated(params, attr.getJavaType());
            params.append(' ').append(attr.getName());
            out.print(source[40]); // 158:2 = "   * @param "
            out.print(attr.getName());
            out.print(source[41]); // 159:31 = " "
            out.print(attr.getOptions().getComment());
            out.print(source[42]); // 159:66 = ""
          }
          out.print(source[43]); // 162:2 = "   * @return the "
          out.print(getEntity());
          out.print(source[44]); // 163:33 = ", null if no such PDO   */  "
          out.print(returnType);
          out.print(source[45]); // 165:16 = " selectByUniqueDomainKey("
          out.print(params);
          out.print(source[46]); // 165:51 = ");"
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
