// wurblet generated by Wurbelizer 2.2.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder] [--bindable] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> option to generate code according to the builder pattern.</li>
 * <li><em>--bindable:</em> add &#64;Bindable annotation to getter and setter (if not explicitly added via square brackets).</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * This option is ignored in builder pattern mode.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=", the property is mutable and a setter is generated.<br>
 * Example:
 * <pre>
 * =String name   the name
 * </pre>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        if (property.isMutable()) {
          out.print(source[0]); // 57:2 = "  private "
          out.print(property.getType());
          out.print(source[1]); // 58:32 = " "
          out.print(property.getName());
          out.print(source[2]); // 58:55 = ";  // "
          out.print(property.getComment());
          out.print(source[3]); // 58:86 = ""
        }
        else {
          out.print(source[4]); // 62:2 = "  private final "
          out.print(property.getType());
          out.print(source[5]); // 63:38 = " "
          out.print(property.getName());
          out.print(source[6]); // 63:61 = ";  // "
          out.print(property.getComment());
          out.print(source[7]); // 63:92 = ""
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[8]); // 71:2 = ""
      if (!withBuilder) {
        out.print(source[9]); // 75:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[10]); // 77:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[11]); // 82:2 = "   * @param "
            out.print(property.getName());
            out.print(source[12]); // 83:35 = " "
            out.print(property.getComment());
            out.print(source[13]); // 83:61 = ""
          }
        }
        out.print(source[14]); // 87:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[15]); // 114:2 = "  protected "
        out.print(getClassName());
        out.print(source[16]); // 115:30 = "(Builder builder) {"
        if (extendsWithBuilder != null) {
          out.print(source[17]); // 118:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[18]); // 124:2 = "    this."
            out.print(property.getName());
            out.print(source[19]); // 125:31 = " = builder."
            out.print(property.getName());
            out.print(source[20]); // 125:64 = ";"
          }
        }
        out.print(source[21]); // 129:2 = "  }"
      }
      else {
        out.print(source[22]); // 134:2 = "  public "
        out.print(getClassName());
        out.print(source[23]); // 135:27 = "("
        out.print(args.toString());
        out.print(source[24]); // 135:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[25]); // 138:2 = "    super("
          out.print(superArgs);
          out.print(source[26]); // 139:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[27]); // 144:2 = "    this."
            out.print(property.getName());
            out.print(source[28]); // 145:31 = " = "
            out.print(property.getName());
            out.print(source[29]); // 145:56 = ";"
          }
        }
        out.print(source[30]); // 149:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[31]); // 158:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[32]); // 161:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[33]); // 163:39 = "   */"
        if (withBindable && !property.isBindableAnnotationPresent()) {
          out.print(source[34]); // 167:2 = "  @Bindable"
        }
        for (String anno: property.getAnnotations()) {
          out.print(source[35]); // 172:2 = "  "
          out.print(anno);
          out.print(source[36]); // 173:10 = ""
        }
        out.print(source[37]); // 176:2 = "  public "
        out.print(property.getType());
        out.print(source[38]); // 177:31 = " "
        out.print(property.getGetterName());
        out.print(source[39]); // 177:60 = "() {    return "
        out.print(property.getName());
        out.print(source[40]); // 178:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[41]); // 187:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[42]); // 190:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[43]); // 192:35 = " "
        out.print(property.getComment());
        out.print(source[44]); // 192:61 = "   */"
        if (withBindable && !property.isBindableAnnotationPresent()) {
          out.print(source[45]); // 196:2 = "  @Bindable"
        }
        for (String anno: property.getAnnotations()) {
          out.print(source[46]); // 201:2 = "  "
          out.print(anno);
          out.print(source[47]); // 202:10 = ""
        }
        out.print(source[48]); // 205:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[49]); // 206:42 = "("
        out.print(property.getType());
        out.print(source[50]); // 206:65 = " "
        out.print(property.getName());
        out.print(source[51]); // 206:88 = ") {    this."
        out.print(property.getName());
        out.print(source[52]); // 207:31 = " = "
        out.print(property.getName());
        out.print(source[53]); // 207:56 = ";  }"
      }
    }

    if (withBuilder) {
      String extendsStr = "";
      if (extendsWithBuilder != null) {
        extendsStr = "extends " + extendsWithBuilder + ".Builder ";
      }
      out.print(source[54]); // 218:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[55]); // 222:33 = " builder.   *   * @return the builder..."
      out.print(getClassName());
      out.print(source[56]); // 231:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[57]); // 233:44 = "{"
      for (Property property: properties) {
        out.print(source[58]); // 237:2 = "    private "
        out.print(property.getType());
        out.print(source[59]); // 238:34 = " "
        out.print(property.getName());
        out.print(source[60]); // 238:57 = ";  // "
        out.print(property.getComment());
        out.print(source[61]); // 238:88 = ""
      }
      out.print(source[62]); // 241:2 = "    protected Builder() {}    /**  ..."
      out.print(getClassName());
      out.print(source[63]); // 247:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[64]); // 249:38 = "     */"
      if (extendsWithBuilder != null) {
        out.print(source[65]); // 253:2 = "    @Override"
      }
      out.print(source[66]); // 257:2 = "    public "
      out.print(getClassName());
      out.print(source[67]); // 258:29 = " build() {      return new "
      out.print(getClassName());
      out.print(source[68]); // 259:35 = "(this);    }"
      for (Property property: properties) {
        out.print(source[69]); // 264:2 = "    /**     * Sets "
        out.print(property.getComment());
        out.print(source[70]); // 267:37 = ".     *     * @param "
        out.print(property.getName());
        out.print(source[71]); // 269:37 = " "
        out.print(property.getComment());
        out.print(source[72]); // 269:63 = "     */    public Builder "
        out.print(property.getName());
        out.print(source[73]); // 271:41 = "("
        out.print(property.getType());
        out.print(source[74]); // 271:64 = " "
        out.print(property.getName());
        out.print(source[75]); // 271:87 = ") {      this."
        out.print(property.getName());
        out.print(source[76]); // 272:33 = " = "
        out.print(property.getName());
        out.print(source[77]); // 272:58 = ";      return this;    }"
      }
      out.print(source[78]); // 277:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
