/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.JoinPath;
import org.tentackle.wurblet.JoinPathFactory;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentOperand;
import org.tentackle.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class WurbletArgumentExpression
implements WurbletArgumentOperand {
    private final WurbletArgumentExpression parent;
    private final List<WurbletArgumentOperand> operands;
    private final List<WurbletArgumentOperator> operators;
    private List<JoinPath> mergedPaths;

    public WurbletArgumentExpression(WurbletArgumentExpression parent) {
        this.parent = parent;
        this.operands = new ArrayList<WurbletArgumentOperand>();
        this.operators = new ArrayList<WurbletArgumentOperator>();
    }

    public WurbletArgumentExpression getParent() {
        return this.parent;
    }

    public List<WurbletArgumentOperand> getOperands() {
        return this.operands;
    }

    public List<WurbletArgumentOperator> getOperators() {
        return this.operators;
    }

    public List<JoinPath> getMergedPaths() {
        if (this.mergedPaths == null) {
            ArrayList<WurbletArgument> pathArgs = new ArrayList<WurbletArgument>();
            for (WurbletArgumentOperand oper : this.operands) {
                WurbletArgument arg;
                if (!(oper instanceof WurbletArgument) || !(arg = (WurbletArgument)oper).isPath()) continue;
                pathArgs.add(arg);
            }
            this.mergedPaths = this.needParenthesesAfterAndOperator() ? new ArrayList<JoinPath>() : new JoinPathFactory().createPaths(pathArgs);
        }
        return this.mergedPaths;
    }

    public WurbletArgumentOperator addOperand(WurbletArgumentOperator operator, WurbletArgumentOperand operand) throws WurbelException {
        if (operand == null) {
            throw new WurbelException("operand cannot be null");
        }
        if (this.operands.isEmpty()) {
            if (operator != null && operator != WurbletArgumentOperator.NOT) {
                throw new WurbelException("operator " + String.valueOf((Object)operator) + " not allowed at start of expression");
            }
        } else if (operator == null) {
            operator = WurbletArgumentOperator.AND;
        } else if (operator == WurbletArgumentOperator.NOT && !(operand instanceof WurbletArgumentExpression)) {
            throw new WurbelException("operator NOT must be followed by an expression");
        }
        if (operator != null) {
            this.operators.add(operator);
        }
        this.operands.add(operand);
        return operator;
    }

    public boolean needParenthesesAfterAndOperator() {
        return this.operators.contains((Object)WurbletArgumentOperator.OR) || this.operators.contains((Object)WurbletArgumentOperator.ORNOT);
    }

    public String toCode(CodeGenerator<Object> generator) throws WurbelException {
        StringBuilder buf = new StringBuilder();
        Iterator<WurbletArgumentOperand> operandIter = this.operands.iterator();
        Iterator<WurbletArgumentOperator> operatorIter = this.operators.iterator();
        if (!this.operators.isEmpty() && this.operands.size() == this.operators.size()) {
            buf.append(generator.generate((Object)operatorIter.next()));
        }
        while (operandIter.hasNext()) {
            buf.append(generator.generate(operandIter.next()));
            if (!operatorIter.hasNext()) continue;
            buf.append(generator.generate((Object)operatorIter.next()));
        }
        return buf.toString();
    }

    public String toString() {
        try {
            return this.toCode(t -> {
                if (t instanceof WurbletArgumentOperator) {
                    WurbletArgumentOperator operator = (WurbletArgumentOperator)((Object)((Object)t));
                    if (operator == WurbletArgumentOperator.NOT) {
                        return String.valueOf(t) + " ";
                    }
                    return " " + String.valueOf(t) + " ";
                }
                if (t instanceof WurbletArgumentExpression) {
                    return "(" + String.valueOf(t) + ")";
                }
                return t.toString();
            });
        }
        catch (WurbelException ex) {
            return ex.getMessage();
        }
    }
}

