// wurblet generated by Wurbelizer 21.6.1.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;
import org.tentackle.sql.*;

/**
 * <strong>({@code @wurblet})</strong> Generate relation method definitions of an entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; Relations
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class Relations extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {

    for (Relation rel: getEntity().getRelations()) {

      boolean isPublic = rel.getAccessScope() == AccessScope.PUBLIC;

      String var = rel.getVariableName();
      String type = rel.getDeclaredJavaType(false);
      String firstArg = rel.getMethodArgs().get(0).getMethodArgument();
      boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
      boolean createGetter = !rel.isWriteOnly();
      boolean createSetter = !rel.isReadOnly() &&
                             (rel.getSelectionType() != SelectionType.ALWAYS || rel.isSelectionCached()) &&
                             (!rel.isComposite() || rel.getRelationType() == RelationType.OBJECT);
      Attribute attr = rel.getAttribute();
      if (attr != null) {
        // take from attribute
        hidden |= attr.isHidden();
        createGetter &= !attr.getOptions().isWriteOnly() && !hidden;
        createSetter &= !attr.getOptions().isReadOnly() && !hidden;
      }

      Relation nmRel = rel.getNmRelation();
      String nmName = null;
      String nmVar = null;
      if (nmRel != null) {
        if (rel.getNmMethodName() != null) {
          nmName = StringHelper.firstToUpper(rel.getNmMethodName());
          nmVar  = StringHelper.firstToLower(rel.getNmMethodName());
        }
        else  {
          nmName = StringHelper.firstToUpper(rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
          nmVar = StringHelper.firstToLower(rel.getNmName()) + "List";
        }
      }

      Relation oppRel = rel.getForeignRelation();

      // getter

      if (createGetter)  {
        String checkNull = firstArg + " == 0";
        if (attr != null && !attr.getDataType().isPrimitive()) {
          checkNull = firstArg + " == null || " + checkNull;
        }
        if (isPublic) {
          out.print(source[0]); // 57:2 = "  /**   * Gets "
          out.print(rel);
          out.print(source[1]); // 60:17 = ".   *   * @return "
          out.print(var);
          out.print(source[2]); // 62:21 = " "
          out.print(rel.getComment());
          out.print(source[3]); // 62:42 = "   */  @Bindable"
          if (rel.isComposite()) {
            out.print(source[4]); // 67:2 = "  @Persistent(ordinal="
            out.print(rel.getOrdinal());
            out.print(source[5]); // 68:43 = ", comment="
            out.print(StringHelper.toDoubleQuotes(rel.getComment()));
            out.print(source[6]); // 68:102 = ")"
          }
          else {
            if (oppRel != null && oppRel.isComposite()) {
              out.print(source[7]); // 73:2 = "  @Persistent(ordinal="
              out.print(rel.getOrdinal());
              out.print(source[8]); // 74:43 = ", comment="
              out.print(StringHelper.toDoubleQuotes(rel.getComment()));
              out.print(source[9]); // 74:102 = ", component=false, parent=true)"
            }
            else {
              out.print(source[10]); // 78:2 = "  @Persistent(ordinal="
              out.print(rel.getOrdinal());
              out.print(source[11]); // 79:43 = ", comment="
              out.print(StringHelper.toDoubleQuotes(rel.getComment()));
              out.print(source[12]); // 79:102 = ", component=false)"
            }
          }
          for (String annotation: rel.getAnnotations()) {
            AnnotationOption anno = new AnnotationOption(annotation);
            if (!anno.isHidden() && !anno.isSetterOnly()) {
              out.print(source[13]); // 86:2 = "  "
              out.print(anno.getAnnotation());
              out.print(source[14]); // 87:26 = ""
            }
          }
          out.print(source[15]); // 91:2 = "  "
          out.print(type);
          out.print(source[16]); // 92:10 = " "
          out.print(rel.getGetterName());
          out.print(source[17]); // 92:34 = "();"
        }
        if (rel.isBluntDeclared()) {
          out.print(source[18]); // 96:2 = "  /**   * Gets "
          out.print(var);
          out.print(source[19]); // 99:17 = " without performing a select if not load..."
          out.print(var);
          out.print(source[20]); // 101:21 = " "
          out.print(rel.getComment());
          out.print(source[21]); // 101:42 = "   */  "
          out.print(type);
          out.print(source[22]); // 103:10 = " "
          out.print(rel.getGetterName());
          out.print(source[23]); // 103:34 = "Blunt();"
        }

        if (nmRel != null && rel.getNmScope() == AccessScope.PUBLIC) {
          out.print(source[24]); // 108:2 = "  /**   * Gets list of "
          out.print(nmRel.getDeclaredJavaType(false));
          out.print(source[25]); // 111:54 = " joined via "
          out.print(rel);
          out.print(source[26]); // 111:73 = ".   *   * @return list of "
          out.print(nmRel.getVariableName());
          out.print(source[27]); // 113:49 = "   */  @Bindable  @Persistent(ordinal..."
          out.print(rel.getOrdinal());
          out.print(source[28]); // 116:43 = ", comment="
          out.print(StringHelper.toDoubleQuotes(nmVar));
          out.print(source[29]); // 116:91 = ", component=false)  TrackedList<"
          out.print(nmRel.getDeclaredJavaType(false));
          out.print(source[30]); // 117:50 = "> get"
          out.print(nmName);
          out.print(source[31]); // 117:65 = "();"
        }

        if (isPublic && rel.isComposite() && !rel.isEmbedding() &&
            (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
              out.print(source[32]); // 123:2 = "  /**   * Returns whether "
              out.print(rel.getName());
              out.print(source[33]); // 126:38 = " is loaded.   *   * @return true if "
              out.print(rel.getGetterName());
              out.print(source[34]); // 128:45 = "() invoked at least once   */  @Bindab..."
              out.print(StringHelper.firstToUpper(var));
              out.print(source[35]); // 131:46 = "Loaded();"
        }
      }

      if (createSetter && isPublic)  {
        String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
        boolean linkMethodIndexed = rel.getForeignRelation() != null ?
            rel.getForeignRelation().getLinkMethodIndex() != null : false;

            out.print(source[36]); // 141:2 = "  /**   * Sets "
            out.print(rel);
            out.print(source[37]); // 144:17 = ".   *   * @param "
            out.print(var);
            out.print(source[38]); // 146:20 = " "
            out.print(rel.getComment());
            out.print(source[39]); // 146:41 = ""
        if (linkMethodIndexed) {
          out.print(source[40]); // 149:2 = "   * @param index the index starting at ..."
        }
        out.print(source[41]); // 153:2 = "   */"
        if (attr != null && attr.getOptions().isBindable()) {
          out.print(source[42]); // 157:2 = "  "
          out.print(attr.getBindableAnnotation());
          out.print(source[43]); // 158:34 = ""
        }
        for (String annotation: rel.getAnnotations()) {
          AnnotationOption anno = new AnnotationOption(annotation);
          if (!anno.isHidden() && (anno.isSetterOnly() || anno.isSetterAndGetter())) {
            out.print(source[44]); // 164:2 = "  "
            out.print(anno.getAnnotation());
            out.print(source[45]); // 165:26 = ""
          }
        }
        if (linkMethodIndexed) {
          out.print(source[46]); // 170:2 = "  void "
          out.print(rel.getForeignRelation().getLinkMethodName());
          out.print(source[47]); // 171:55 = "("
          out.print(type);
          out.print(source[48]); // 171:64 = " "
          out.print(var);
          out.print(source[49]); // 171:72 = ", int index);"
        }
        else {
          out.print(source[50]); // 175:2 = "  void "
          out.print(rel.getSetterName());
          out.print(source[51]); // 176:30 = "("
          out.print(type);
          out.print(source[52]); // 176:39 = " "
          out.print(var);
          out.print(source[53]); // 176:47 = ");"
        }
      }
    }

    // creates the select- and delete-methods for list relations in foreign entities
    boolean useDatabaseRefInt = getEntity().getIntegrity().isCompositesCheckedByDatabase() &&
                                Boolean.FALSE.equals(getEntity().isDeletionCascaded());
    Set<String> declaredArgSet = new HashSet<>();   // to avoid duplicates if args= is used

    for (Relation rel: getEntity().getReferencingRelations()) {
      if (rel.getRelationType() == RelationType.LIST) {
        Attribute attribute = rel.getForeignAttribute();
        if (attribute != null) {
          String declaredArgs = createDeclaredArgsForSelectOrDeleteMethod(rel);
          if (declaredArgSet.add(declaredArgs)) {
            out.print(source[54]); // 193:2 = "  /**   * Selects "
            out.print(rel);
            out.print(source[55]); // 196:20 = ".   *"
            for (MethodArgument arg : rel.getMethodArgs()) {
              Attribute attr = arg.getForeignAttribute();
              out.print(source[56]); // 201:2 = "   * @param "
              out.print(attr.getName());
              out.print(source[57]); // 202:31 = " "
              out.print(attr.getOptions().getComment());
              out.print(source[58]); // 202:66 = ""
            }
            out.print(source[59]); // 205:2 = "   * @return "
            out.print(rel.getComment());
            out.print(source[60]); // 206:34 = "   */  "
            out.print(rel.getDeclaredJavaType(true));
            out.print(source[61]); // 208:35 = " "
            out.print(createRelationSelectMethodName(rel));
            out.print(source[62]); // 208:75 = "("
            out.print(declaredArgs);
            out.print(source[63]); // 208:92 = ");"
            if (rel.isComposite() && !rel.isDeletionCascaded() && !useDatabaseRefInt) {
              out.print(source[64]); // 211:2 = "  /**   * Deletes "
              out.print(rel);
              out.print(source[65]); // 214:20 = ".   *"
              for (MethodArgument arg : rel.getMethodArgs()) {
                Attribute attr = arg.getForeignAttribute();
                out.print(source[66]); // 219:2 = "   * @param "
                out.print(attr.getName());
                out.print(source[67]); // 220:31 = " "
                out.print(attr.getOptions().getComment());
                out.print(source[68]); // 220:66 = ""
              }
              out.print(source[69]); // 223:2 = "   * @return "
              out.print(rel.getComment());
              out.print(source[70]); // 224:34 = "   */  int "
              out.print(createListRelationDeleteMethodName(rel));
              out.print(source[71]); // 226:49 = "("
              out.print(declaredArgs);
              out.print(source[72]); // 226:66 = ");"
            }
          }
        }
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
