/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

public class AnnotationOption {
    private final String annotation;
    private String annotationType;
    private boolean setterOnly;
    private boolean setterAndGetter;
    private boolean hidden;

    public AnnotationOption(String annotation) {
        Modifier modifier;
        if (((String)annotation).length() > 2 && (modifier = this.toModifier(((String)annotation).charAt(1))) != null) {
            annotation = "@" + ((String)annotation).substring(2);
            this.applyModifier(modifier);
            if (((String)annotation).length() > 2 && (modifier = this.toModifier(((String)annotation).charAt(1))) != null) {
                annotation = "@" + ((String)annotation).substring(2);
                this.applyModifier(modifier);
            }
        }
        this.annotation = annotation;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public boolean isSetterOnly() {
        return this.setterOnly;
    }

    public boolean isSetterAndGetter() {
        return this.setterAndGetter;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getAnnotationType() {
        if (this.annotationType == null && this.annotation.startsWith("@")) {
            int ndx = this.annotation.indexOf(40);
            this.annotationType = ndx > 1 ? this.annotation.substring(1, ndx).trim() : this.annotation.substring(1).trim();
        }
        return this.annotationType;
    }

    private Modifier toModifier(char c) {
        return switch (c) {
            case '=' -> Modifier.SETTER_ONLY;
            case '+' -> Modifier.SETTER_AND_GETTER;
            case '~' -> Modifier.HIDDEN;
            default -> null;
        };
    }

    private void applyModifier(Modifier modifier) {
        switch (modifier.ordinal()) {
            case 2: {
                this.hidden = true;
                break;
            }
            case 0: {
                this.setterOnly = true;
                break;
            }
            case 1: {
                this.setterAndGetter = true;
            }
        }
    }

    private static enum Modifier {
        SETTER_ONLY,
        SETTER_AND_GETTER,
        HIDDEN;

    }
}

