// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [options] &lt;filename&gt;
 * <p>
 * <ul>
 * <li><em>--builder:</em> generate code according to the builder pattern.</li>
 * <li><em>--equals:</em> generate the equals method.</li>
 * <li><em>--hashCode:</em> generate the hashCode method.</li>
 * <li><em>--validate[=&lt;code&gt;]:</em> perform validation after construction.
 * Requires that the DTO implements <code>Validateable</code>.
 * If the optional &lt;code&gt; is missing, the default <code>"ValidationUtilities.getInstance().validate(this)"</code> will be used.
 * </li>
 * <li><em>--names:</em> generate the name constants for all properties.</li>
 * <li><em>--from:</em> only if --builder set: generate method to create a builder from instance. This will automatically
 * happen if the '+' option is set for at least one property.</li>
 * <li><em>--with:</em> same as <code>--from</code>, but the generated methods are prefixed by "with" instead of "from".
 * In TT, the default is to use "frommers" instead of "withers", since builder implementations exist in the wild
 * that use withers for builder methods (which return the builder and not the object to be built!). This may be confusing.
 * TT supports both, though.</li>
 * <li><em>--nott:</em> generate generic code that does not need any Tentackle dependency (such as TentackleRuntimeException)</li>
 * <li><em>filename:</em> the file holding the DTO model. Obsolete if the class is a java record.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed by "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed by "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed by "!" are considered as required and a (Tentackle)RuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * For lines prefixed by "+" a from-Method is generated that creates a new DTO from the current one by replacing the given property.
 * If the option --with is set, the methods are prefixed by <code>with</code> (a.k.a. "withers").
 * <pre>
 * +String name   the name
 * </pre>
 * This would create an instance method "fromName(String name)" that returns a new DTO instance.
 * <p>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * Can also be written as:
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20), &#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be removed from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 * <p>
 * Important: if <code>--equals</code> or <code>--hashCode</code> is given in a subclass, all superclasses must
 * get those options as well!
 * <p>
 * <br>
 * The wurblet can also be used for the new java record type to generate additional "from" methods and/or a builder.
 * The record declaration must be annotated with <code>&#64;RecordDTO</code> to get the record components from
 * the analyze build phase instead of a DTO model (which is not necessary in that case). Example:
 * <pre>
 * &#64;RecordDTO
 * public record Position3D(&#64;Bindable(options="AUTOSELECT") int x,
 *                          &#64;Bindable(options="AUTOSELECT") int y,
 *                          &#64;Bindable(options="AUTOSELECT") int z) {
 *   ...
 *   // &#064;wurblet dto DTO --builder --from
 * </pre>
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String exceptionName = nott ? "RuntimeException" : "TentackleRuntimeException";

    if (withNames) {
      // create name constants
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[0]); // 117:2 = "  /** property name for "
          out.print(property.getComment());
          out.print(source[1]); // 118:49 = ". */  public static final String "
          out.print(property.getConstant());
          out.print(source[2]); // 119:55 = " = ""
          out.print(property.getName());
          out.print(source[3]); // 119:81 = "";"
        }
      }
    }

    if (!isRecord()) {
      // create declarations
      for (Property property: properties) {
        if (!property.isInherited()) {
          String decl = "private";
          if (!property.isMutable()) {
            decl += " final";
          }
          else if (property.isTransient()) {
            decl += " transient";
          }
          out.print(source[4]); // 137:2 = "  /** "
          out.print(property.getComment());
          out.print(source[5]); // 138:31 = ". */  "
          out.print(decl);
          out.print(source[6]); // 139:10 = " "
          out.print(property.getType());
          out.print(source[7]); // 139:33 = " "
          out.print(property.getName());
          out.print(source[8]); // 139:56 = ";"
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[9]); // 148:2 = ""
      if (!withBuilder) {
        out.print(source[10]); // 152:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[11]); // 154:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[12]); // 159:2 = "   * @param "
            out.print(property.getName());
            out.print(source[13]); // 160:35 = " "
            out.print(property.getComment());
            out.print(source[14]); // 160:61 = ""
          }
        }
        out.print(source[15]); // 164:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (validate != null) {
        out.print(source[16]); // 191:2 = "  @SuppressWarnings("this-escape")"
      }

      if (withBuilder) {
        out.print(source[17]); // 197:2 = "  protected "
        out.print(getClassName());
        out.print(source[18]); // 198:30 = "(Builder builder) {"
        if (isRecord()) {
          StringBuilder buf = new StringBuilder();
          buf.append("this(");
          boolean needComma = false;
          for (Property property: properties) {
            if (needComma) {
              buf.append(", ");
            }
            else {
              needComma = true;
            }
            buf.append("builder.").append(property.getName());
          }
          buf.append(")");
          out.print(source[19]); // 214:2 = "    "
          out.print(buf);
          out.print(source[20]); // 215:11 = ";"
        }
        else {
          if (superClass != null) {
            out.print(source[21]); // 220:2 = "    super(builder);"
          }
          for (Property property: properties) {
            if (!property.isInherited() && !property.isMutable()) {
              if (property.isRequired()) {
                out.print(source[22]); // 227:2 = "    if (!builder."
                out.print(property.getName());
                out.print(source[23]); // 228:39 = "Provided) {      throw new "
                out.print(exceptionName);
                out.print(source[24]); // 229:33 = "(""
                out.print(property.getName());
                out.print(source[25]); // 229:57 = " is required");    }"
              }
              out.print(source[26]); // 233:2 = "    this."
              out.print(property.getName());
              out.print(source[27]); // 234:31 = " = builder."
              out.print(property.getName());
              out.print(source[28]); // 234:64 = ";"
            }
          }
          if (validate != null) {
            out.print(source[29]); // 239:2 = "    "
            out.print(validate);
            out.print(source[30]); // 240:16 = ";"
          }
        }
        out.print(source[31]); // 244:2 = "  }"
      }
      else {
        out.print(source[32]); // 249:2 = "  public "
        out.print(getClassName());
        out.print(source[33]); // 250:27 = "("
        out.print(args.toString());
        out.print(source[34]); // 250:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[35]); // 253:2 = "    super("
          out.print(superArgs);
          out.print(source[36]); // 254:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[37]); // 259:2 = "    this."
            out.print(property.getName());
            out.print(source[38]); // 260:31 = " = "
            out.print(property.getName());
            out.print(source[39]); // 260:56 = ";"
          }
        }
        if (validate != null) {
          out.print(source[40]); // 265:2 = "    "
          out.print(validate);
          out.print(source[41]); // 266:16 = ";"
        }
        out.print(source[42]); // 269:2 = "  }"
      }
    }

    if (!isRecord()) {
      // create getter
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[43]); // 279:2 = "  /**   * Gets "
          out.print(property.getComment());
          out.print(source[44]); // 282:35 = ".   *   * @return "
          out.print(property.getComment());
          out.print(source[45]); // 284:39 = "   */"
          for (String anno: property.getAnnotations()) {
            out.print(source[46]); // 288:2 = "  "
            out.print(anno);
            out.print(source[47]); // 289:10 = ""
          }
          out.print(source[48]); // 292:2 = "  public "
          out.print(property.getType());
          out.print(source[49]); // 293:31 = " "
          out.print(property.getGetterName());
          out.print(source[50]); // 293:60 = "() {    return "
          out.print(property.getName());
          out.print(source[51]); // 294:33 = ";  }"
        }
      }

      // create setter
      for (Property property: properties) {
        if (property.isMutable()) {
          out.print(source[52]); // 303:2 = "  /**   * Sets "
          out.print(property.getComment());
          out.print(source[53]); // 306:35 = ".   *   * @param "
          out.print(property.getName());
          out.print(source[54]); // 308:35 = " "
          out.print(property.getComment());
          out.print(source[55]); // 308:61 = "   */"
          for (String anno: property.getAnnotations()) {
            out.print(source[56]); // 312:2 = "  "
            out.print(anno);
            out.print(source[57]); // 313:10 = ""
          }
          out.print(source[58]); // 316:2 = "  public void "
          out.print(property.getSetterName());
          out.print(source[59]); // 317:42 = "("
          out.print(property.getType());
          out.print(source[60]); // 317:65 = " "
          out.print(property.getName());
          out.print(source[61]); // 317:88 = ") {    this."
          out.print(property.getName());
          out.print(source[62]); // 318:31 = " = "
          out.print(property.getName());
          out.print(source[63]); // 318:56 = ";  }"
        }
      }
    }

    // create "from" methods
    for (Property property: properties) {
      if (property.isWithFrom()) {
        out.print(source[64]); // 328:2 = "  /**   * Create copy with "
        out.print(property.getComment());
        out.print(source[65]); // 331:47 = " from given "
        out.print(property.getName());
        out.print(source[66]); // 331:81 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[67]); // 333:35 = " "
        out.print(property.getComment());
        out.print(source[68]); // 333:61 = "   * @return the copied "
        out.print(getClassName());
        out.print(source[69]); // 334:43 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[70]); // 338:2 = "  "
          out.print(anno);
          out.print(source[71]); // 339:10 = ""
        }
        out.print(source[72]); // 342:2 = "  public "
        out.print(getClassName());
        out.print(source[73]); // 343:27 = " "
        out.print(property.getFromName());
        out.print(source[74]); // 343:54 = "("
        out.print(property.getType());
        out.print(source[75]); // 343:77 = " "
        out.print(property.getName());
        out.print(source[76]); // 343:100 = ") {"
        if (withBuilder) {
          if (property.isMutable()) {
            out.print(source[77]); // 347:2 = "    "
            out.print(getClassName());
            out.print(source[78]); // 348:22 = " object = toBuilder().build();    objec..."
            out.print(property.getSetterName());
            out.print(source[79]); // 349:39 = "("
            out.print(property.getName());
            out.print(source[80]); // 349:62 = ");    return object;"
          }
          else {
            out.print(source[81]); // 354:2 = "    return toBuilder()."
            out.print(property.getName());
            out.print(source[82]); // 355:45 = "("
            out.print(property.getName());
            out.print(source[83]); // 355:68 = ").build();"
          }
        }
        else {
          StringBuilder argBuf = new StringBuilder();
          for (Property prop: properties) {
            if (argBuf.length() > 0) {
              argBuf.append(", ");
            }
            if (prop == property) {
              argBuf.append(prop.getName());
            }
            else {
              if (prop.isInherited()) {
                argBuf.append(prop.getGetterName() + "()");
              }
              else {
                argBuf.append("this." + prop.getName());
              }
            }
          }
          out.print(source[84]); // 377:2 = "    return new "
          out.print(getClassName());
          out.print(source[85]); // 378:33 = "("
          out.print(argBuf);
          out.print(source[86]); // 378:44 = ");"
        }
        out.print(source[87]); // 381:2 = "  }"
      }
    }

    if (withEquals) {
      out.print(source[88]); // 388:2 = "  @Override  public boolean equals(Obj..."
      if (superClass != null) {
        out.print(source[89]); // 403:2 = "    if (!super.equals(obj)) {      retu..."
      }
      out.print(source[90]); // 409:2 = "    "
      out.print(getClassName());
      out.print(source[91]); // 410:22 = " other = ("
      out.print(getClassName());
      out.print(source[92]); // 410:50 = ") obj;"
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[93]); // 415:2 = "    if ("
            out.print(property.getName());
            out.print(source[94]); // 416:30 = " != other."
            out.print(property.getName());
            out.print(source[95]); // 416:62 = ") {      return false;    }"
          }
          else  {
            out.print(source[96]); // 422:2 = "    if (!Objects.equals("
            out.print(property.getName());
            out.print(source[97]); // 423:46 = ", other."
            out.print(property.getName());
            out.print(source[98]); // 423:76 = ")) {      return false;    }"
          }
        }
      }
      out.print(source[99]); // 430:2 = "    return true;  }"
    }


    if (withHashCode) {
      out.print(source[100]); // 438:2 = "  @Override  public int hashCode() {"
      if (superClass != null) {
        out.print(source[101]); // 444:2 = "    int hash = super.hashCode();"
      }
      else {
        out.print(source[102]); // 449:2 = "    int hash = 7;"
      }
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[103]); // 455:2 = "    hash = 79 * hash + "
          out.print(property.getHashCodeInvocation());
          out.print(source[104]); // 456:59 = ";"
        }
      }
      out.print(source[105]); // 460:2 = "    return hash;  }"
    }

    if (withBuilder) {
      String extendsStr = "";
      if (superClass != null) {
        extendsStr = "extends " + superClass + ".Builder ";
      }
      out.print(source[106]); // 471:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[107]); // 475:33 = " builder.   *   * @return the builder..."
      if (withFrom) {
        out.print(source[108]); // 484:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[109]); // 487:33 = " builder from current object.   *   * ..."
      if (superClass != null) {
        out.print(source[110]); // 493:2 = "  @Override"
      }
      out.print(source[111]); // 497:2 = "  public Builder toBuilder() {    retur..."
      }
      out.print(source[112]); // 503:2 = "  /**   * The "
      out.print(getClassName());
      out.print(source[113]); // 506:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[114]); // 508:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[115]); // 513:2 = "    /** "
          out.print(property.getComment());
          out.print(source[116]); // 514:33 = ". */    private "
          out.print(property.getType());
          out.print(source[117]); // 515:34 = " "
          out.print(property.getName());
          out.print(source[118]); // 515:57 = ";"
          if (property.isRequired()) {
            out.print(source[119]); // 518:2 = "    /** true if "
            out.print(property.getComment());
            out.print(source[120]); // 519:41 = " was provided. */    private boolean "
            out.print(property.getName());
            out.print(source[121]); // 520:42 = "Provided;"
          }
          out.print(source[122]); // 523:2 = ""
        }
      }
      out.print(source[123]); // 528:2 = "    protected Builder() {}"
      if (withFrom) {
        out.print(source[124]); // 533:2 = "    protected Builder("
        out.print(getClassName());
        out.print(source[125]); // 535:40 = " template) {"
        if (superClass != null) {
          out.print(source[126]); // 538:2 = "      super(template);"
        }
        for (Property property: properties) {
          if (isRecord()) {
            out.print(source[127]); // 544:2 = "      "
            out.print(property.getName());
            out.print(source[128]); // 545:28 = "(template."
            out.print(property.getName());
            out.print(source[129]); // 545:60 = "());"
          }
          else {
            if (!property.isMutable()) {
              out.print(source[130]); // 550:2 = "      "
              out.print(property.getName());
              out.print(source[131]); // 551:28 = "(template."
              out.print(property.getGetterName());
              out.print(source[132]); // 551:66 = "());"
            }
          }
        }
        out.print(source[133]); // 556:2 = "    }"
      }

      out.print(source[134]); // 561:2 = "    /**     * Builds a "
      out.print(getClassName());
      out.print(source[135]); // 564:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[136]); // 566:38 = "     */"
      if (superClass != null) {
        out.print(source[137]); // 570:2 = "    @Override"
      }
      out.print(source[138]); // 574:2 = "    public "
      out.print(getClassName());
      out.print(source[139]); // 575:29 = " build() {"
      if (isAbstract()) {
        out.print(source[140]); // 578:2 = "      throw new "
        out.print(exceptionName);
        out.print(source[141]); // 579:33 = "("cannot build abstract "
        out.print(getClassName());
        out.print(source[142]); // 579:75 = "");"
      }
      else {
        out.print(source[143]); // 583:2 = "      return new "
        out.print(getClassName());
        out.print(source[144]); // 584:35 = "(this);"
      }
      out.print(source[145]); // 587:2 = "    }"

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[146]); // 593:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[147]); // 596:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[148]); // 598:37 = " "
          out.print(property.getComment());
          out.print(source[149]); // 598:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[150]); // 601:41 = "("
          out.print(property.getType());
          out.print(source[151]); // 601:64 = " "
          out.print(property.getName());
          out.print(source[152]); // 601:87 = ") {      this."
          out.print(property.getName());
          out.print(source[153]); // 602:33 = " = "
          out.print(property.getName());
          out.print(source[154]); // 602:58 = ";"
        if (property.isRequired()) {
          out.print(source[155]); // 605:2 = "      "
          out.print(property.getName());
          out.print(source[156]); // 606:28 = "Provided = true;"
        }
        out.print(source[157]); // 609:2 = "      return this;    }"
        }
      }
      out.print(source[158]); // 615:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
