// wurblet generated by Wurbelizer 21.6.2.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [options] &lt;filename&gt;
 * <p>
 * <ul>
 * <li><em>--builder:</em> generate code according to the builder pattern.</li>
 * <li><em>--equals:</em> generate the equals method.</li>
 * <li><em>--hashCode:</em> generate the hashCode method.</li>
 * <li><em>--validate[=&lt;code&gt;]:</em> perform validation after construction.
 * Requires that the DTO implements <code>Validateable</code>.
 * If the optional &lt;code&gt; is missing, the default <code>"ValidationUtilities.getInstance().validate(this)"</code> will be used.
 * </li>
 * <li><em>--names:</em> generate the name constants for all properties.</li>
 * <li><em>--from:</em> only if --builder set: generate method to create a builder from instance. This will automatically
 * happen if the '+' option is set for at least one property.</li>
 * <li><em>--with:</em> same as <code>--from</code>, but the generated methods are prefixed by "with" instead of "from".
 * In TT, the default is to use "frommers" instead of "withers", since builder implementations exist in the wild
 * that use withers for builder methods (which return the builder and not the object to be built!). This may be confusing.
 * TT supports both, though.</li>
 * <li><em>--nott:</em> generate generic code that does not need any Tentackle dependency (such as TentackleRuntimeException)</li>
 * <li><em>filename:</em> the file holding the DTO model. Obsolete if the class is a java record.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed by "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed by "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed by "!" are considered as required and a (Tentackle)RuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * For lines prefixed by "+" a from-Method is generated that creates a new DTO from the current one by replacing the given property.
 * If the option --with is set, the methods are prefixed by <code>with</code> (a.k.a. "withers").
 * <pre>
 * +String name   the name
 * </pre>
 * This would create an instance method "fromName(String name)" that returns a new DTO instance.
 * <p>
 * The comment may contain optional annotations or access scope enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno] [protected]
 * </pre>
 * Can also be written as:
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20), &#64;MyAnno, protected]
 * </pre>
 * <p>
 * Valid access scopes are: public (default), protected, package, private.
 * <p>
 * Global annotations are defined in a single line above the properties, enclosed in square brackets.
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be removed from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 * <p>
 * Important: if <code>--equals</code> or <code>--hashCode</code> is given in a subclass, all superclasses must
 * get those options as well!
 * <p>
 * <br>
 * The wurblet can also be used for the new java record type to generate additional "from" methods and/or a builder.
 * The record declaration must be annotated with <code>&#64;RecordDTO</code> to get the record components from
 * the analyze build phase instead of a DTO model (which is not necessary in that case). Example:
 * <pre>
 * &#64;RecordDTO
 * public record Position3D(&#64;Bindable(options="AUTOSELECT") int x,
 *                          &#64;Bindable(options="AUTOSELECT") int y,
 *                          &#64;Bindable(options="AUTOSELECT") int z) {
 *   ...
 *   // &#064;wurblet dto DTO --builder --from
 * </pre>
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String exceptionName = nott ? "RuntimeException" : "TentackleRuntimeException";

    if (withNames) {
      // create name constants
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[0]); // 120:2 = "  /** property name for "
          out.print(property.getComment());
          out.print(source[1]); // 121:49 = ". */  public static final String "
          out.print(property.getConstant());
          out.print(source[2]); // 122:55 = " = ""
          out.print(property.getName());
          out.print(source[3]); // 122:81 = "";"
        }
      }
    }

    if (!isRecord()) {
      // create declarations
      for (Property property: properties) {
        if (!property.isInherited()) {
          String decl = "private";
          if (!property.isMutable()) {
            decl += " final";
          }
          else if (property.isTransient()) {
            decl += " transient";
          }
          out.print(source[4]); // 140:2 = "  /** "
          out.print(property.getComment());
          out.print(source[5]); // 141:31 = ". */  "
          out.print(decl);
          out.print(source[6]); // 142:10 = " "
          out.print(property.getType());
          out.print(source[7]); // 142:33 = " "
          out.print(property.getName());
          out.print(source[8]); // 142:56 = ";"
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[9]); // 151:2 = ""
      if (!withBuilder) {
        out.print(source[10]); // 155:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[11]); // 157:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[12]); // 162:2 = "   * @param "
            out.print(property.getName());
            out.print(source[13]); // 163:35 = " "
            out.print(property.getComment());
            out.print(source[14]); // 163:61 = ""
          }
        }
        out.print(source[15]); // 167:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (validate != null) {
        out.print(source[16]); // 194:2 = "  @SuppressWarnings("this-escape")"
      }

      if (withBuilder) {
        out.print(source[17]); // 200:2 = "  protected "
        out.print(getClassName());
        out.print(source[18]); // 201:30 = "(Builder builder) {"
        if (isRecord()) {
          StringBuilder buf = new StringBuilder();
          buf.append("this(");
          boolean needComma = false;
          for (Property property: properties) {
            if (needComma) {
              buf.append(", ");
            }
            else {
              needComma = true;
            }
            buf.append("builder.").append(property.getName());
          }
          buf.append(")");
          out.print(source[19]); // 217:2 = "    "
          out.print(buf);
          out.print(source[20]); // 218:11 = ";"
        }
        else {
          if (superClass != null) {
            out.print(source[21]); // 223:2 = "    super(builder);"
          }
          for (Property property: properties) {
            if (!property.isInherited() && !property.isMutable()) {
              if (property.isRequired()) {
                out.print(source[22]); // 230:2 = "    if (!builder."
                out.print(property.getName());
                out.print(source[23]); // 231:39 = "Provided) {      throw new "
                out.print(exceptionName);
                out.print(source[24]); // 232:33 = "(""
                out.print(property.getName());
                out.print(source[25]); // 232:57 = " is required");    }"
              }
              out.print(source[26]); // 236:2 = "    this."
              out.print(property.getName());
              out.print(source[27]); // 237:31 = " = builder."
              out.print(property.getName());
              out.print(source[28]); // 237:64 = ";"
            }
          }
          if (validate != null) {
            out.print(source[29]); // 242:2 = "    "
            out.print(validate);
            out.print(source[30]); // 243:16 = ";"
          }
        }
        out.print(source[31]); // 247:2 = "  }"
      }
      else {
        out.print(source[32]); // 252:2 = "  public "
        out.print(getClassName());
        out.print(source[33]); // 253:27 = "("
        out.print(args.toString());
        out.print(source[34]); // 253:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[35]); // 256:2 = "    super("
          out.print(superArgs);
          out.print(source[36]); // 257:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[37]); // 262:2 = "    this."
            out.print(property.getName());
            out.print(source[38]); // 263:31 = " = "
            out.print(property.getName());
            out.print(source[39]); // 263:56 = ";"
          }
        }
        if (validate != null) {
          out.print(source[40]); // 268:2 = "    "
          out.print(validate);
          out.print(source[41]); // 269:16 = ";"
        }
        out.print(source[42]); // 272:2 = "  }"
      }
    }

    if (!isRecord()) {
      // create getter
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[43]); // 282:2 = "  /**   * Gets "
          out.print(property.getComment());
          out.print(source[44]); // 285:35 = ".   *   * @return "
          out.print(property.getComment());
          out.print(source[45]); // 287:39 = "   */"
          for (String anno: property.getAnnotations()) {
            out.print(source[46]); // 291:2 = "  "
            out.print(anno);
            out.print(source[47]); // 292:10 = ""
          }
          out.print(source[48]); // 295:2 = "  "
          out.print(property.getScopeAsKeyword());
          out.print(property.getType());
          out.print(source[49]); // 296:56 = " "
          out.print(property.getGetterName());
          out.print(source[50]); // 296:85 = "() {    return "
          out.print(property.getName());
          out.print(source[51]); // 297:33 = ";  }"
        }
      }

      // create setter
      for (Property property: properties) {
        if (property.isMutable()) {
          out.print(source[52]); // 306:2 = "  /**   * Sets "
          out.print(property.getComment());
          out.print(source[53]); // 309:35 = ".   *   * @param "
          out.print(property.getName());
          out.print(source[54]); // 311:35 = " "
          out.print(property.getComment());
          out.print(source[55]); // 311:61 = "   */"
          for (String anno: property.getAnnotations()) {
            out.print(source[56]); // 315:2 = "  "
            out.print(anno);
            out.print(source[57]); // 316:10 = ""
          }
          out.print(source[58]); // 319:2 = "  "
          out.print(property.getScopeAsKeyword());
          out.print(source[59]); // 320:34 = "void "
          out.print(property.getSetterName());
          out.print(source[60]); // 320:67 = "("
          out.print(property.getType());
          out.print(source[61]); // 320:90 = " "
          out.print(property.getName());
          out.print(source[62]); // 320:113 = ") {    this."
          out.print(property.getName());
          out.print(source[63]); // 321:31 = " = "
          out.print(property.getName());
          out.print(source[64]); // 321:56 = ";  }"
        }
      }
    }

    // create "from" methods
    for (Property property: properties) {
      if (property.isWithFrom()) {
        out.print(source[65]); // 331:2 = "  /**   * Create copy with "
        out.print(property.getComment());
        out.print(source[66]); // 334:47 = " from given "
        out.print(property.getName());
        out.print(source[67]); // 334:81 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[68]); // 336:35 = " "
        out.print(property.getComment());
        out.print(source[69]); // 336:61 = "   * @return the copied "
        out.print(getClassName());
        out.print(source[70]); // 337:43 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[71]); // 341:2 = "  "
          out.print(anno);
          out.print(source[72]); // 342:10 = ""
        }
        out.print(source[73]); // 345:2 = "  "
        out.print(property.getScopeAsKeyword());
        out.print(getClassName());
        out.print(source[74]); // 346:52 = " "
        out.print(property.getFromName());
        out.print(source[75]); // 346:79 = "("
        out.print(property.getType());
        out.print(source[76]); // 346:102 = " "
        out.print(property.getName());
        out.print(source[77]); // 346:125 = ") {"
        if (withBuilder) {
          if (property.isMutable()) {
            out.print(source[78]); // 350:2 = "    "
            out.print(getClassName());
            out.print(source[79]); // 351:22 = " object = toBuilder().build();    objec..."
            out.print(property.getSetterName());
            out.print(source[80]); // 352:39 = "("
            out.print(property.getName());
            out.print(source[81]); // 352:62 = ");    return object;"
          }
          else {
            out.print(source[82]); // 357:2 = "    return toBuilder()."
            out.print(property.getName());
            out.print(source[83]); // 358:45 = "("
            out.print(property.getName());
            out.print(source[84]); // 358:68 = ").build();"
          }
        }
        else {
          StringBuilder argBuf = new StringBuilder();
          for (Property prop: properties) {
            if (argBuf.length() > 0) {
              argBuf.append(", ");
            }
            if (prop == property) {
              argBuf.append(prop.getName());
            }
            else {
              if (prop.isInherited()) {
                argBuf.append(prop.getGetterName() + "()");
              }
              else {
                argBuf.append("this." + prop.getName());
              }
            }
          }
          out.print(source[85]); // 380:2 = "    return new "
          out.print(getClassName());
          out.print(source[86]); // 381:33 = "("
          out.print(argBuf);
          out.print(source[87]); // 381:44 = ");"
        }
        out.print(source[88]); // 384:2 = "  }"
      }
    }

    if (withEquals) {
      out.print(source[89]); // 391:2 = "  @Override  public boolean equals(Obj..."
      if (superClass != null) {
        out.print(source[90]); // 406:2 = "    if (!super.equals(obj)) {      retu..."
      }
      out.print(source[91]); // 412:2 = "    "
      out.print(getClassName());
      out.print(source[92]); // 413:22 = " other = ("
      out.print(getClassName());
      out.print(source[93]); // 413:50 = ") obj;"
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[94]); // 418:2 = "    if ("
            out.print(property.getName());
            out.print(source[95]); // 419:30 = " != other."
            out.print(property.getName());
            out.print(source[96]); // 419:62 = ") {      return false;    }"
          }
          else  {
            out.print(source[97]); // 425:2 = "    if (!Objects.equals("
            out.print(property.getName());
            out.print(source[98]); // 426:46 = ", other."
            out.print(property.getName());
            out.print(source[99]); // 426:76 = ")) {      return false;    }"
          }
        }
      }
      out.print(source[100]); // 433:2 = "    return true;  }"
    }


    if (withHashCode) {
      out.print(source[101]); // 441:2 = "  @Override  public int hashCode() {"
      if (superClass != null) {
        out.print(source[102]); // 447:2 = "    int hash = super.hashCode();"
      }
      else {
        out.print(source[103]); // 452:2 = "    int hash = 7;"
      }
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[104]); // 458:2 = "    hash = 79 * hash + "
          out.print(property.getHashCodeInvocation());
          out.print(source[105]); // 459:59 = ";"
        }
      }
      out.print(source[106]); // 463:2 = "    return hash;  }"
    }

    if (withBuilder) {
      String extendsStr = "";
      if (superClass != null) {
        extendsStr = "extends " + superClass + ".Builder ";
      }
      out.print(source[107]); // 474:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[108]); // 478:33 = " builder.   *   * @return the builder..."
      if (withFrom) {
        out.print(source[109]); // 487:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[110]); // 490:33 = " builder from current object.   *   * ..."
      if (superClass != null) {
        out.print(source[111]); // 496:2 = "  @Override"
      }
      out.print(source[112]); // 500:2 = "  public Builder toBuilder() {    retur..."
      }
      out.print(source[113]); // 506:2 = "  /**   * The "
      out.print(getClassName());
      out.print(source[114]); // 509:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[115]); // 511:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[116]); // 516:2 = "    /** "
          out.print(property.getComment());
          out.print(source[117]); // 517:33 = ". */    private "
          out.print(property.getType());
          out.print(source[118]); // 518:34 = " "
          out.print(property.getName());
          out.print(source[119]); // 518:57 = ";"
          if (property.isRequired()) {
            out.print(source[120]); // 521:2 = "    /** true if "
            out.print(property.getComment());
            out.print(source[121]); // 522:41 = " was provided. */    private boolean "
            out.print(property.getName());
            out.print(source[122]); // 523:42 = "Provided;"
          }
          out.print(source[123]); // 526:2 = ""
        }
      }
      out.print(source[124]); // 531:2 = "    protected Builder() {}"
      if (withFrom) {
        out.print(source[125]); // 536:2 = "    protected Builder("
        out.print(getClassName());
        out.print(source[126]); // 538:40 = " template) {"
        if (superClass != null) {
          out.print(source[127]); // 541:2 = "      super(template);"
        }
        for (Property property: properties) {
          if (isRecord()) {
            out.print(source[128]); // 547:2 = "      "
            out.print(property.getName());
            out.print(source[129]); // 548:28 = "(template."
            out.print(property.getName());
            out.print(source[130]); // 548:60 = "());"
          }
          else {
            if (!property.isMutable()) {
              out.print(source[131]); // 553:2 = "      "
              out.print(property.getName());
              out.print(source[132]); // 554:28 = "(template."
              out.print(property.getGetterName());
              out.print(source[133]); // 554:66 = "());"
            }
          }
        }
        out.print(source[134]); // 559:2 = "    }"
      }

      out.print(source[135]); // 564:2 = "    /**     * Builds a "
      out.print(getClassName());
      out.print(source[136]); // 567:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[137]); // 569:38 = "     */"
      if (superClass != null) {
        out.print(source[138]); // 573:2 = "    @Override"
      }
      out.print(source[139]); // 577:2 = "    public "
      out.print(getClassName());
      out.print(source[140]); // 578:29 = " build() {"
      if (isAbstract()) {
        out.print(source[141]); // 581:2 = "      throw new "
        out.print(exceptionName);
        out.print(source[142]); // 582:33 = "("cannot build abstract "
        out.print(getClassName());
        out.print(source[143]); // 582:75 = "");"
      }
      else {
        out.print(source[144]); // 586:2 = "      return new "
        out.print(getClassName());
        out.print(source[145]); // 587:35 = "(this);"
      }
      out.print(source[146]); // 590:2 = "    }"

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[147]); // 596:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[148]); // 599:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[149]); // 601:37 = " "
          out.print(property.getComment());
          out.print(source[150]); // 601:63 = "     * @return the builder     */    ..."
          out.print(property.getName());
          out.print(source[151]); // 604:41 = "("
          out.print(property.getType());
          out.print(source[152]); // 604:64 = " "
          out.print(property.getName());
          out.print(source[153]); // 604:87 = ") {      this."
          out.print(property.getName());
          out.print(source[154]); // 605:33 = " = "
          out.print(property.getName());
          out.print(source[155]); // 605:58 = ";"
        if (property.isRequired()) {
          out.print(source[156]); // 608:2 = "      "
          out.print(property.getName());
          out.print(source[157]); // 609:28 = "Provided = true;"
        }
        out.print(source[158]); // 612:2 = "      return this;    }"
        }
      }
      out.print(source[159]); // 618:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
