/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.tentackle.buildsupport.RecordDTOInfo;
import org.tentackle.buildsupport.RecordDTOInfoParameter;
import org.tentackle.common.StringHelper;
import org.tentackle.model.AccessScope;
import org.tentackle.model.parse.OptionParser;
import org.wurbelizer.wurbel.WurbelDiscardException;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelHelper;
import org.wurbelizer.wurblet.AbstractJavaWurblet;

public class DTOWurblet
extends AbstractJavaWurblet {
    protected String filename;
    protected List<String> annotations;
    protected List<Property> properties;
    protected boolean needConstructor;
    protected boolean withBuilder;
    protected boolean withFrom;
    protected boolean asWithers;
    protected boolean withEquals;
    protected boolean withHashCode;
    protected String validate;
    protected boolean withNames;
    protected boolean nott;
    protected String superClass;
    protected String modelSourceName;
    protected int modelSourceLine;

    public void run() throws WurbelException {
        super.run();
        for (String arg : this.getContainer().getArgs()) {
            if ("--builder".equals(arg)) {
                this.withBuilder = true;
                continue;
            }
            if ("--from".equals(arg)) {
                this.withFrom = true;
                continue;
            }
            if ("--with".equals(arg)) {
                this.withFrom = true;
                this.asWithers = true;
                continue;
            }
            if ("--equals".equals(arg)) {
                if (this.isRecord()) {
                    throw new WurbelException("--equals option not allowed for records");
                }
                this.withEquals = true;
                continue;
            }
            if ("--hashCode".equals(arg)) {
                if (this.isRecord()) {
                    throw new WurbelException("--hashCode option not allowed for records");
                }
                this.withHashCode = true;
                continue;
            }
            if ("--names".equals(arg)) {
                this.withNames = true;
                continue;
            }
            if ("--nott".equals(arg)) {
                this.nott = true;
                continue;
            }
            if (arg.startsWith("--validate")) {
                if (this.isRecord()) {
                    throw new WurbelException("--validate option not allowed for records");
                }
                if (arg.length() > 11 && arg.charAt(10) == '=') {
                    this.validate = arg.substring(11);
                    continue;
                }
                this.validate = "ValidationUtilities.getInstance().validate(this)";
                continue;
            }
            if (this.filename != null || arg.startsWith("--")) continue;
            this.filename = arg;
        }
        this.properties = new ArrayList<Property>();
        this.annotations = new ArrayList<String>();
        if (this.isRecord()) {
            String infoName = (this.getPackageName() + "." + this.getClassName()).replace('.', '/') + "/record.info";
            try {
                RecordDTOInfo info = RecordDTOInfo.readInfo((File)this.getContainer().getAnalyzeFile(infoName));
                for (RecordDTOInfoParameter parameter : info.getParameters()) {
                    this.properties.add(new Property(parameter));
                }
            }
            catch (IOException ex) {
                if (this.getContainer().getAnalyzeFile("error.log").exists()) {
                    throw new WurbelDiscardException("reading info '" + infoName + "' failed", (Throwable)ex);
                }
                throw new WurbelException("reading info '" + infoName + "' failed (@RecordDTO annotation missing?)", (Throwable)ex);
            }
        }
        if (this.filename == null) {
            throw new WurbelException("usage: @wurblet <guardname> DTO [--builder] <filename>");
        }
        try {
            this.superClass = this.getSuperClassName();
        }
        catch (WurbelException infoName) {
            // empty catch block
        }
        int lineNo = 0;
        try (BufferedReader reader = new BufferedReader(WurbelHelper.openReader((String)this.filename));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#@")) {
                    int lineNdx = line.lastIndexOf(58);
                    if (lineNdx >= "#@".length()) {
                        this.modelSourceName = line.substring("#@".length(), lineNdx);
                        this.modelSourceLine = Integer.parseInt(line.substring(lineNdx + 1));
                    } else {
                        this.modelSourceName = line.substring("#@".length());
                    }
                } else if (line.startsWith("[")) {
                    this.annotations.addAll(this.parseComment((StringBuilder)new StringBuilder((String)line)).annotations);
                } else if (!line.isEmpty() && !line.startsWith("#")) {
                    StringTokenizer stok = new StringTokenizer(line);
                    String type = null;
                    Object name = null;
                    StringBuilder comment = new StringBuilder();
                    while (stok.hasMoreTokens()) {
                        String token = stok.nextToken();
                        if (type == null) {
                            type = token;
                            continue;
                        }
                        if (name == null) {
                            name = token;
                            continue;
                        }
                        if (!comment.isEmpty()) {
                            comment.append(' ');
                        }
                        comment.append(token);
                    }
                    if (type == null || name == null) {
                        throw new WurbelException("property line too short: '" + line + "'");
                    }
                    Property property = new Property(type, (String)name, comment.toString(), this.modelSourceLine + lineNo);
                    if (!property.isMutable()) {
                        this.needConstructor = true;
                    }
                    if (property.isWithFrom()) {
                        this.withFrom = true;
                    }
                    this.properties.add(property);
                }
                ++lineNo;
            }
            for (Property property : this.properties) {
                for (String annotation : this.annotations) {
                    property.addGlobalAnnotation(annotation);
                }
                property.cleanupAnnotations();
            }
            HashMap<String, Property> nameMap = new HashMap<String, Property>();
            for (Property property : this.properties) {
                Property existingProperty;
                if (property.getType().isEmpty()) {
                    throw new WurbelException("missing property type");
                }
                if (!Character.isLetter(property.getType().charAt(0))) {
                    throw new WurbelException("property '" + property.getName() + "' has a malformed Java type '" + property.getType() + "'");
                }
                if (!StringHelper.isValidJavaIdentifier((String)property.getName())) {
                    throw new WurbelException("property '" + property.getName() + "' is not a valid Java identifier");
                }
                if (this.withBuilder) {
                    if (property.isInherited()) {
                        throw new WurbelException("property '" + property.getName() + "': inherit-option not applicable in builder mode");
                    }
                } else if (property.isRequired()) {
                    throw new WurbelException("property '" + property.getName() + "': required-option only applicable in builder mode");
                }
                if ((existingProperty = nameMap.put(property.getName(), property)) == null) continue;
                throw new WurbelException("property '" + property.getName() + "' defined more than once in " + this.modelSourceName + ":" + property.lineNo);
            }
        }
        catch (IOException ex) {
            throw new WurbelException("reading model " + this.filename + " failed", (Throwable)ex);
        }
    }

    private ParseResult parseComment(StringBuilder commentBuf) throws WurbelException {
        String option;
        ArrayList<String> annos = new ArrayList<String>();
        AccessScope scope = AccessScope.PUBLIC;
        String cmt = commentBuf.toString();
        commentBuf.setLength(0);
        OptionParser parser = new OptionParser(cmt, commentBuf);
        while ((option = parser.nextOption()) != null) {
            if (option.startsWith("@") || option.startsWith("-@") || option.startsWith("!@")) {
                annos.add(option);
                continue;
            }
            scope = switch (option.toLowerCase(Locale.ROOT)) {
                case "private" -> AccessScope.PRIVATE;
                case "protected" -> AccessScope.PROTECTED;
                case "public" -> AccessScope.PUBLIC;
                case "package" -> AccessScope.PACKAGE;
                default -> throw new WurbelException("invalid access scope '" + option + "' (valid: public, protected, package, private)");
            };
        }
        return new ParseResult(annos, scope);
    }

    protected class Property {
        private final String type;
        private final String name;
        private final String comment;
        private final int lineNo;
        private final boolean inherited;
        private final boolean mutable;
        private final boolean unserialized;
        private final boolean required;
        private final boolean withFrom;
        private final List<String> annotations;
        private final AccessScope scope;

        public Property(String type, String name, String comment, int lineNo) throws WurbelException {
            char c;
            int i;
            StringBuilder buf = new StringBuilder();
            for (i = 0; i < type.length() && !Character.isJavaIdentifierStart(c = type.charAt(i)); ++i) {
                buf.append(c);
            }
            this.type = type.substring(i);
            this.lineNo = lineNo;
            String options = buf.toString();
            if (options.contains("^")) {
                this.inherited = true;
                this.mutable = false;
                this.required = false;
                this.unserialized = false;
            } else if (options.contains("=")) {
                this.mutable = true;
                this.inherited = false;
                this.required = false;
                this.unserialized = false;
            } else if (options.contains("~")) {
                this.mutable = true;
                this.inherited = false;
                this.required = false;
                this.unserialized = true;
            } else if (options.contains("!")) {
                this.required = true;
                this.mutable = false;
                this.inherited = false;
                this.unserialized = false;
            } else {
                this.inherited = false;
                this.mutable = false;
                this.unserialized = false;
                this.required = false;
            }
            this.withFrom = options.contains("+");
            this.name = name;
            buf = new StringBuilder((String)(comment == null || comment.isEmpty() ? "the " + name + " property" : comment));
            ParseResult parseResult = DTOWurblet.this.parseComment(buf);
            this.annotations = parseResult.annotations;
            this.scope = parseResult.scope;
            this.comment = buf.toString().trim();
        }

        public Property(RecordDTOInfoParameter recordParameter) throws WurbelException {
            this((this$0.withFrom ? "+" : "") + recordParameter.getType(), recordParameter.getName(), null, 0);
        }

        public boolean isPrimitive() {
            return Character.isLowerCase(this.type.charAt(0));
        }

        public String getHashCodeInvocation() {
            Object object;
            if (this.isPrimitive()) {
                switch (this.type) {
                    case "double": {
                        object = "Double.hashCode(" + this.name + ")";
                        break;
                    }
                    case "float": {
                        object = "Float.hashCode(" + this.name + ")";
                        break;
                    }
                    case "long": {
                        object = "Long.hashCode(" + this.name + ")";
                        break;
                    }
                    default: {
                        object = this.name;
                        break;
                    }
                }
            } else {
                object = "Objects.hashCode(" + this.name + ")";
            }
            return object;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public boolean isMutable() {
            return this.mutable;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isTransient() {
            return this.unserialized;
        }

        public boolean isWithFrom() {
            return this.withFrom;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public String getConstant() {
            return "PN_" + this.name.toUpperCase(Locale.ROOT);
        }

        public String getComment() {
            return this.comment;
        }

        public String getGetterName() {
            return ("boolean".equals(this.type) ? "is" : "get") + StringHelper.firstToUpper((String)this.name);
        }

        public String getFromName() {
            return (DTOWurblet.this.asWithers ? "with" : "from") + StringHelper.firstToUpper((String)this.name);
        }

        public String getSetterName() {
            return "set" + StringHelper.firstToUpper((String)this.name);
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public AccessScope getScope() {
            return this.scope;
        }

        public String getScopeAsKeyword() {
            Object keyword = this.scope.toString();
            if (!((String)keyword).isEmpty()) {
                keyword = (String)keyword + " ";
            }
            return keyword;
        }

        public void addGlobalAnnotation(String globalAnnotation) {
            for (String annotation : this.annotations) {
                char c;
                StringBuilder annoName = new StringBuilder();
                for (int i = 0; i < annotation.length() && (c = annotation.charAt(i)) != '('; ++i) {
                    if (Character.isWhitespace(c)) continue;
                    annoName.append(c);
                }
                String anno = annoName.toString();
                if (!anno.equals(globalAnnotation) && !anno.substring(1).equals(globalAnnotation)) continue;
                return;
            }
            this.annotations.add(globalAnnotation);
        }

        public void cleanupAnnotations() {
            this.annotations.removeIf(anno -> anno.startsWith("-@") || anno.startsWith("!@"));
        }
    }

    private record ParseResult(List<String> annotations, AccessScope scope) {
    }
}

