/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tentackle.common.Path;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;
import org.tentackle.wurblet.Join;
import org.tentackle.wurblet.WurbletRelation;
import org.wurbelizer.wurbel.WurbelException;

public class JoinPath
implements Path<JoinPath, Join> {
    private final List<Join> elements;
    private final List<JoinPath> paths;

    public JoinPath(List<Join> elements, List<JoinPath> paths) {
        this.elements = elements == null ? new ArrayList() : elements;
        this.paths = paths == null ? new ArrayList() : paths;
    }

    public JoinPath(Join element, List<JoinPath> paths) {
        this(new ArrayList<Join>(), paths);
        this.elements.add(element);
    }

    public List<Join> getElements() {
        return this.elements;
    }

    public List<JoinPath> getPaths() {
        return this.paths;
    }

    public boolean isFiltered(boolean componentsOnly) {
        for (Join element : this.elements) {
            WurbletRelation wurbletRelation = element.getWurbletRelation();
            Relation relation = wurbletRelation.getRelation();
            if (componentsOnly && !relation.isComposite()) break;
            if (wurbletRelation.getFilter() == null) continue;
            return true;
        }
        return false;
    }

    public Join findJoin(Entity component) throws WurbelException {
        return component == null ? null : this.findJoinImpl(this, component);
    }

    private Join findJoinImpl(JoinPath path, Entity component) throws WurbelException {
        Join join = null;
        JoinPath joinPath = null;
        for (Join jn : path.getElements()) {
            if (!component.equals((Object)jn.getWurbletRelation().getRelation().getForeignEntity())) continue;
            if (join != null) {
                throw new WurbelException("ambiguous path to " + String.valueOf(component) + " in path " + String.valueOf(path));
            }
            join = jn;
            joinPath = path;
        }
        for (JoinPath subPath : path.getPaths()) {
            Join jn = this.findJoinImpl(subPath, component);
            if (jn == null) continue;
            if (join != null) {
                throw new WurbelException("ambiguous path to " + String.valueOf(component) + " in paths " + String.valueOf(joinPath) + " / " + String.valueOf(subPath));
            }
            join = jn;
            joinPath = subPath;
        }
        return join;
    }

    public Join findJoin(List<WurbletRelation> wurbletRelations) {
        return wurbletRelations == null || wurbletRelations.isEmpty() ? null : this.findJoinImpl(this, wurbletRelations);
    }

    private Join findJoinImpl(JoinPath path, List<WurbletRelation> wurbletRelations) {
        Join join;
        block3: {
            JoinPath subPath;
            join = null;
            int depth = 0;
            List<Join> joins = path.getElements();
            int joinCount = joins.size();
            for (WurbletRelation wurbletRelation : wurbletRelations) {
                if (depth >= joinCount) break;
                join = joins.get(depth);
                if (!wurbletRelation.equals(join.getWurbletRelation())) {
                    return null;
                }
                ++depth;
            }
            if (depth >= wurbletRelations.size()) break block3;
            wurbletRelations = wurbletRelations.subList(depth, wurbletRelations.size());
            Iterator<Object> iterator = path.getPaths().iterator();
            while (iterator.hasNext() && (join = this.findJoinImpl(subPath = (JoinPath)iterator.next(), wurbletRelations)) == null) {
            }
        }
        return join;
    }

    public void normalize() {
        int size;
        for (JoinPath subPath : this.getPaths()) {
            subPath.normalize();
        }
        while ((size = this.getElements().size()) > 1) {
            Join last = this.getElements().get(size - 1);
            JoinPath path = new JoinPath(last, new ArrayList<JoinPath>(this.getPaths()));
            this.getElements().remove(size - 1);
            this.getPaths().clear();
            this.getPaths().add(path);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Join join : this.getElements()) {
            buf.append(" * ").append(join);
        }
        for (JoinPath subPath : this.getPaths()) {
            buf.append(" [ ").append(subPath).append(" ]");
        }
        return buf.toString();
    }
}

