/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;
import org.tentackle.wurblet.JoinPath;
import org.tentackle.wurblet.JoinPathFactory;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentExpression;
import org.tentackle.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class WurbletArgumentParser {
    private final Entity entity;
    private final boolean argumentGroupingEnabled;
    private final WurbletArgumentExpression expression;
    private final List<WurbletArgument> expressionArguments;
    private final List<WurbletArgument> sortingArguments;
    private final List<WurbletArgument> extraArguments;
    private final List<WurbletArgument> joinArguments;
    private List<WurbletArgument> methodArguments;
    private List<WurbletArgument> allArguments;
    private List<JoinPath> joinPaths;
    private int parIndex = 0;

    public WurbletArgumentParser(Entity entity, boolean argumentGroupingEnabled, List<String> arguments) throws WurbelException {
        this.entity = entity;
        this.argumentGroupingEnabled = argumentGroupingEnabled;
        this.expression = new WurbletArgumentExpression(null);
        this.expressionArguments = new ArrayList<WurbletArgument>();
        this.sortingArguments = new ArrayList<WurbletArgument>();
        this.joinArguments = new ArrayList<WurbletArgument>();
        this.extraArguments = new ArrayList<WurbletArgument>();
        this.parse(arguments);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.entity).append(": ");
        boolean needComma = false;
        for (WurbletArgument arg : this.getAllArguments()) {
            if (needComma) {
                buf.append(", ");
            } else {
                needComma = true;
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public WurbletArgumentExpression getExpression() {
        return this.expression;
    }

    public List<WurbletArgument> getExpressionArguments() {
        return this.expressionArguments;
    }

    public List<WurbletArgument> getExtraArguments() {
        return this.extraArguments;
    }

    public List<WurbletArgument> getSortingArguments() {
        return this.sortingArguments;
    }

    public List<WurbletArgument> getJoinArguments() {
        return this.joinArguments;
    }

    public List<JoinPath> getJoinPaths() {
        if (this.joinPaths == null) {
            this.joinPaths = JoinPathFactory.getInstance().createPaths(this.joinArguments);
        }
        return this.joinPaths;
    }

    public List<WurbletArgument> getMethodArguments() {
        if (this.methodArguments == null) {
            this.methodArguments = new ArrayList<WurbletArgument>(this.extraArguments.size() + this.expressionArguments.size());
            this.methodArguments.addAll(this.extraArguments);
            this.methodArguments.addAll(this.expressionArguments);
        }
        return this.methodArguments;
    }

    public List<WurbletArgument> getAllArguments() {
        if (this.allArguments == null) {
            this.getMethodArguments();
            this.allArguments = new ArrayList<WurbletArgument>(this.methodArguments.size() + this.sortingArguments.size() + this.joinArguments.size());
            this.allArguments.addAll(this.methodArguments);
            this.allArguments.addAll(this.sortingArguments);
            this.allArguments.addAll(this.joinArguments);
        }
        return this.allArguments;
    }

    public WurbletArgument createArgument(String arg, boolean expressionFinished, boolean argumentGroupingEnabled) throws WurbelException {
        return new WurbletArgument(this.entity, ++this.parIndex, arg, expressionFinished, argumentGroupingEnabled);
    }

    private void parse(List<String> args) throws WurbelException {
        int expressionLevel = 0;
        LinkedList<WurbletArgumentOperator> operators = new LinkedList<WurbletArgumentOperator>();
        WurbletArgumentOperator lastOperator = null;
        WurbletArgument lastExistsArg = null;
        WurbletArgumentExpression expr = this.expression;
        boolean expressionFinished = false;
        LinkedHashSet<Relation> existsRelations = null;
        LinkedHashSet<Entity> existsComponents = null;
        for (String arg : args) {
            if (arg == null) continue;
            if (expressionFinished) {
                WurbletArgument par = this.createArgument(arg, true, this.argumentGroupingEnabled);
                switch (par.getArgumentType()) {
                    case SORT: {
                        this.sortingArguments.add(par);
                        break;
                    }
                    case JOIN: {
                        this.joinArguments.add(par);
                        break;
                    }
                    default: {
                        this.extraArguments.add(par);
                        break;
                    }
                }
                continue;
            }
            block19: for (String subArg : this.splitArg(arg)) {
                boolean match = false;
                switch (subArg) {
                    case "(": {
                        expr = new WurbletArgumentExpression(expr);
                        operators.push(lastOperator);
                        lastOperator = null;
                        ++expressionLevel;
                        match = true;
                        break;
                    }
                    case ")": {
                        if (--expressionLevel < 0) {
                            throw new WurbelException("unbalanced braces: more closed than opened");
                        }
                        WurbletArgumentExpression parent = expr != null ? expr.getParent() : null;
                        lastOperator = (WurbletArgumentOperator)((Object)operators.pop());
                        if (parent != null) {
                            parent.addOperand(lastOperator, expr);
                            lastOperator = null;
                        }
                        expr = parent;
                        match = true;
                        break;
                    }
                    case "|": {
                        if (expressionLevel != 0) {
                            throw new WurbelException("key group separator not allowed in nested expressions");
                        }
                        expressionFinished = true;
                        match = true;
                    }
                }
                if (match) {
                    existsRelations = null;
                    existsComponents = null;
                    if (lastExistsArg == null) continue;
                    lastExistsArg.setEndOfExistsClause(true);
                    lastExistsArg = null;
                    continue;
                }
                WurbletArgumentOperator operator = WurbletArgumentOperator.toInternal(subArg);
                if (operator != null) {
                    if (lastOperator != null) {
                        if (operator == WurbletArgumentOperator.NOT) {
                            if (lastOperator == WurbletArgumentOperator.AND) {
                                lastOperator = WurbletArgumentOperator.ANDNOT;
                                continue;
                            }
                            if (lastOperator == WurbletArgumentOperator.OR) {
                                lastOperator = WurbletArgumentOperator.ORNOT;
                                continue;
                            }
                        }
                        throw new WurbelException(String.valueOf((Object)lastOperator) + " cannot be followed by " + String.valueOf((Object)operator));
                    }
                    lastOperator = operator;
                    continue;
                }
                WurbletArgument operand = this.createArgument(subArg, expressionFinished, this.argumentGroupingEnabled);
                switch (operand.getArgumentType()) {
                    case SORT: {
                        if (expressionLevel == 0) {
                            this.sortingArguments.add(operand);
                            expressionFinished = true;
                            continue block19;
                        }
                        throw new WurbelException("sorting key " + String.valueOf(operand) + " not allowed in nested expressions");
                    }
                    case JOIN: {
                        if (expressionLevel == 0) {
                            this.joinArguments.add(operand);
                            expressionFinished = true;
                            continue block19;
                        }
                        throw new WurbelException("join " + String.valueOf(operand) + " not allowed in nested expressions");
                    }
                }
                lastOperator = expr.addOperand(lastOperator, operand);
                this.expressionArguments.add(operand);
                if (lastOperator != WurbletArgumentOperator.AND) {
                    existsRelations = null;
                    existsComponents = null;
                    if (lastExistsArg != null) {
                        lastExistsArg.setEndOfExistsClause(true);
                        lastExistsArg = null;
                    }
                }
                if (operand.getExpressionRelations() == null) continue;
                if (existsRelations == null) {
                    existsRelations = new LinkedHashSet<Relation>(operand.getExpressionRelations());
                    existsComponents = new LinkedHashSet<Entity>();
                    if (operand.getComponent() != null) {
                        existsComponents.add(operand.getComponent());
                    }
                    operand.setExistsRelations(existsRelations);
                    operand.setExistsComponents(existsComponents);
                } else {
                    existsRelations.addAll(operand.getExpressionRelations());
                    if (operand.getComponent() != null) {
                        existsComponents.add(operand.getComponent());
                    }
                }
                lastExistsArg = operand;
            }
        }
        if (lastExistsArg != null) {
            lastExistsArg.setEndOfExistsClause(true);
        }
        if (expressionLevel > 0) {
            throw new WurbelException("unbalanced braces: more opened than closed");
        }
    }

    private List<String> splitArg(String arg) {
        ArrayList<String> strs = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean quoted = false;
        char c = '\u0000';
        for (int i = 0; i < arg.length(); ++i) {
            char cl = c;
            c = arg.charAt(i);
            if (quoted) {
                buf.append(c);
                quoted = false;
                continue;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (c == '(' && (i >= arg.length() - 1 || arg.charAt(i + 1) != ')') || c == ')' && cl != '(' || c == '|') {
                String str = buf.toString().trim();
                if (!StringHelper.isAllWhitespace((String)str)) {
                    strs.add(str);
                }
                buf.setLength(0);
                buf.append(c);
                strs.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        String str = buf.toString().trim();
        if (!StringHelper.isAllWhitespace((String)str)) {
            strs.add(str);
        }
        return strs;
    }
}

