/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.util.ArrayList;
import java.util.Objects;
import org.tentackle.model.Relation;
import org.tentackle.wurblet.WurbletArgumentParser;
import org.wurbelizer.wurbel.ArgScanner;
import org.wurbelizer.wurbel.WurbelException;

public class WurbletRelation {
    private final Relation relation;
    private final String filter;
    private final WurbletArgumentParser parser;

    public WurbletRelation(Relation relation, String filter) throws WurbelException {
        this.relation = Objects.requireNonNull(relation, "relation");
        this.filter = filter;
        if (filter != null) {
            String filterArg;
            ArgScanner argScanner = new ArgScanner(filter, null);
            ArrayList<String> filterArgs = new ArrayList<String>();
            while ((filterArg = argScanner.next()) != null) {
                filterArgs.add(filterArg);
            }
            this.parser = new WurbletArgumentParser(relation.getForeignEntity(), false, filterArgs);
        } else {
            this.parser = null;
        }
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String getFilter() {
        return this.filter;
    }

    public WurbletArgumentParser getParser() {
        return this.parser;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.relation.getEntity()).append(".").append(this.relation.getName());
        if (this.filter != null) {
            buf.append(" filtered by '").append(this.filter).append("'");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WurbletRelation that = (WurbletRelation)o;
        return this.relation.equals((Object)that.relation);
    }

    public int hashCode() {
        return this.relation.hashCode();
    }
}

