// wurblet generated by Wurbelizer 21.6.3.0, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [options] &lt;filename&gt;
 * <p>
 * <ul>
 * <li><em>--builder:</em> generate code according to the builder pattern.</li>
 * <li><em>--builder[@someAnnotation]:</em> builder pattern with annotated builder class.</li>
 * <li><em>--builderPrefix=&lt;prefix&gt;:</em> prefix builder methods with the given string. Implies --builder. Default is no prefix.</li>
 * <li><em>--equals:</em> generate the equals method.</li>
 * <li><em>--hashCode:</em> generate the hashCode method.</li>
 * <li><em>--validate[=&lt;code&gt;]:</em> perform validation after construction.
 * Requires that the DTO implements <code>Validateable</code>.
 * If the optional &lt;code&gt; is missing, the default <code>"ValidationUtilities.getInstance().validate(this)"</code> will be used.
 * </li>
 * <li><em>--names:</em> generate the name constants for all properties.</li>
 * <li><em>--from:</em> generate methods to create variants from an existing instance. For builders, a toBuilder-method is generated,
 * that creates a builder from an instance. Notice that for frommer/withers to be generated, the '+' option must be set for the corresponding properties
 * (except for records, where this defaults to all)</li>
 * <li><em>--with:</em> same as <code>--from</code>, but the generated methods are prefixed by "with" instead of "from".
 * In TT, the default is to use "frommers" instead of "withers", since builder implementations exist in the wild
 * that use withers for builder methods (which return the builder and not the object to be built!). This may be confusing.
 * TT supports both, though.</li>
 * <li><em>--nott:</em> generate generic code that does not need any Tentackle dependency (such as TentackleRuntimeException)</li>
 * <li><em>filename:</em> the file holding the DTO model. Obsolete if the class is a java record.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed by "^", the property is passed to the super entity within the constructor.<br>
 * In builder pattern mode, standard java inheritance must be used instead.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed by "=" or "~", the property is mutable and a setter is generated. "~" marks
 * the property transient as well.<br>
 * In builder pattern mode, no builder method is generated for this property.<br>
 * Examples:
 * <pre>
 * =String name   the name
 * </pre>
 * Only for builder mode: lines prefixed by "!" are considered as required and a (Tentackle)RuntimeException is
 * thrown by the build-method, if a required attribute was not configured. Notice that a required attribute
 * is always immutable.
 * <pre>
 * !String name   the name
 * </pre>
 * For lines prefixed by "+" a from-Method is generated that creates a new DTO from the current one by replacing the given property.
 * If the option --with is set, the methods are prefixed by <code>with</code> (a.k.a. "withers").
 * <pre>
 * +String name   the name
 * </pre>
 * This would create an instance method "fromName(String name)" that returns a new DTO instance.
 * <p>
 * The comment may contain optional annotations or access scope enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno] [protected]
 * </pre>
 * Can also be written as:
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20), &#64;MyAnno, protected]
 * </pre>
 * <p>
 * Valid access scopes are: public (default), protected, package, private.
 * <p>
 * Global annotations are defined in a single line above the properties, enclosed in square brackets.
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * Global annotations can be removed from a property with a leading dash or exclamation mark.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * String blue   the blue not bindable [-&#64;Bindable]
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 * <p>
 * Important: if <code>--equals</code> or <code>--hashCode</code> is given in a subclass, all superclasses must
 * get those options as well!
 * <p>
 * <br>
 * The wurblet can also be used for the new java record type to generate additional "from" methods and/or a builder.
 * The record declaration must be annotated with <code>&#64;RecordDTO</code> to get the record components from
 * the analyze build phase instead of a DTO model (which is not necessary in that case). Example:
 * <pre>
 * &#64;RecordDTO
 * public record Position3D(&#64;Bindable(options="AUTOSELECT") int x,
 *                          &#64;Bindable(options="AUTOSELECT") int y,
 *                          &#64;Bindable(options="AUTOSELECT") int z) {
 *   ...
 *   // &#064;wurblet dto DTO '--builder[@JsonPOJOBuilder(withPrefix = "")]' --with
 * </pre>
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    String exceptionName = nott ? "RuntimeException" : "TentackleRuntimeException";

    if (withNames) {
      // create name constants
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[0]); // 123:2 = "  /** property name for "
          out.print(property.getComment());
          out.print(source[1]); // 124:49 = ". */  public static final String "
          out.print(property.getConstant());
          out.print(source[2]); // 125:55 = " = ""
          out.print(property.getName());
          out.print(source[3]); // 125:81 = "";"
        }
      }
    }

    if (!isRecord()) {
      // create declarations
      for (Property property: properties) {
        if (!property.isInherited()) {
          String decl = "private";
          if (!property.isMutable()) {
            decl += " final";
          }
          else if (property.isTransient()) {
            decl += " transient";
          }
          out.print(source[4]); // 143:2 = "  /** "
          out.print(property.getComment());
          out.print(source[5]); // 144:31 = ". */  "
          out.print(decl);
          out.print(source[6]); // 145:10 = " "
          out.print(property.getType());
          out.print(source[7]); // 145:33 = " "
          out.print(property.getName());
          out.print(source[8]); // 145:56 = ";"
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[9]); // 154:2 = ""
      if (!withBuilder) {
        out.print(source[10]); // 158:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[11]); // 160:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[12]); // 165:2 = "   * @param "
            out.print(property.getName());
            out.print(source[13]); // 166:35 = " "
            out.print(property.getComment());
            out.print(source[14]); // 166:61 = ""
          }
        }
        out.print(source[15]); // 170:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (validate != null) {
        out.print(source[16]); // 197:2 = "  @SuppressWarnings("this-escape")"
      }

      if (withBuilder) {
        out.print(source[17]); // 203:2 = "  protected "
        out.print(getClassName());
        out.print(source[18]); // 204:30 = "(Builder builder) {"
        if (isRecord()) {
          StringBuilder buf = new StringBuilder();
          buf.append("this(");
          boolean needComma = false;
          for (Property property: properties) {
            if (needComma) {
              buf.append(", ");
            }
            else {
              needComma = true;
            }
            buf.append("builder.").append(property.getName());
          }
          buf.append(")");
          out.print(source[19]); // 220:2 = "    "
          out.print(buf);
          out.print(source[20]); // 221:11 = ";"
        }
        else {
          if (superClass != null) {
            out.print(source[21]); // 226:2 = "    super(builder);"
          }
          for (Property property: properties) {
            if (!property.isInherited() && !property.isMutable()) {
              if (property.isRequired()) {
                out.print(source[22]); // 233:2 = "    if (!builder."
                out.print(property.getName());
                out.print(source[23]); // 234:39 = "Provided) {      throw new "
                out.print(exceptionName);
                out.print(source[24]); // 235:33 = "(""
                out.print(property.getName());
                out.print(source[25]); // 235:57 = " is required");    }"
              }
              out.print(source[26]); // 239:2 = "    this."
              out.print(property.getName());
              out.print(source[27]); // 240:31 = " = builder."
              out.print(property.getName());
              out.print(source[28]); // 240:64 = ";"
            }
          }
          if (validate != null) {
            out.print(source[29]); // 245:2 = "    "
            out.print(validate);
            out.print(source[30]); // 246:16 = ";"
          }
        }
        out.print(source[31]); // 250:2 = "  }"
      }
      else {
        out.print(source[32]); // 255:2 = "  public "
        out.print(getClassName());
        out.print(source[33]); // 256:27 = "("
        out.print(args.toString());
        out.print(source[34]); // 256:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[35]); // 259:2 = "    super("
          out.print(superArgs);
          out.print(source[36]); // 260:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[37]); // 265:2 = "    this."
            out.print(property.getName());
            out.print(source[38]); // 266:31 = " = "
            out.print(property.getName());
            out.print(source[39]); // 266:56 = ";"
          }
        }
        if (validate != null) {
          out.print(source[40]); // 271:2 = "    "
          out.print(validate);
          out.print(source[41]); // 272:16 = ";"
        }
        out.print(source[42]); // 275:2 = "  }"
      }
    }

    if (!isRecord()) {
      // create getter
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[43]); // 285:2 = "  /**   * Gets "
          out.print(property.getComment());
          out.print(source[44]); // 288:35 = ".   *   * @return "
          out.print(property.getComment());
          out.print(source[45]); // 290:39 = "   */"
          for (String anno: property.getAnnotations()) {
            out.print(source[46]); // 294:2 = "  "
            out.print(anno);
            out.print(source[47]); // 295:10 = ""
          }
          out.print(source[48]); // 298:2 = "  "
          out.print(property.getScopeAsKeyword());
          out.print(property.getType());
          out.print(source[49]); // 299:56 = " "
          out.print(property.getGetterName());
          out.print(source[50]); // 299:85 = "() {    return "
          out.print(property.getName());
          out.print(source[51]); // 300:33 = ";  }"
        }
      }

      // create setter
      for (Property property: properties) {
        if (property.isMutable()) {
          out.print(source[52]); // 309:2 = "  /**   * Sets "
          out.print(property.getComment());
          out.print(source[53]); // 312:35 = ".   *   * @param "
          out.print(property.getName());
          out.print(source[54]); // 314:35 = " "
          out.print(property.getComment());
          out.print(source[55]); // 314:61 = "   */"
          for (String anno: property.getAnnotations()) {
            out.print(source[56]); // 318:2 = "  "
            out.print(anno);
            out.print(source[57]); // 319:10 = ""
          }
          out.print(source[58]); // 322:2 = "  "
          out.print(property.getScopeAsKeyword());
          out.print(source[59]); // 323:34 = "void "
          out.print(property.getSetterName());
          out.print(source[60]); // 323:67 = "("
          out.print(property.getType());
          out.print(source[61]); // 323:90 = " "
          out.print(property.getName());
          out.print(source[62]); // 323:113 = ") {    this."
          out.print(property.getName());
          out.print(source[63]); // 324:31 = " = "
          out.print(property.getName());
          out.print(source[64]); // 324:56 = ";  }"
        }
      }
    }

    // create "from" methods
    for (Property property: properties) {
      if (property.isWithFrom()) {
        out.print(source[65]); // 334:2 = "  /**   * Create copy with "
        out.print(property.getComment());
        out.print(source[66]); // 337:47 = " from given "
        out.print(property.getName());
        out.print(source[67]); // 337:81 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[68]); // 339:35 = " "
        out.print(property.getComment());
        out.print(source[69]); // 339:61 = "   * @return the copied "
        out.print(getClassName());
        out.print(source[70]); // 340:43 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[71]); // 344:2 = "  "
          out.print(anno);
          out.print(source[72]); // 345:10 = ""
        }
        out.print(source[73]); // 348:2 = "  "
        out.print(property.getScopeAsKeyword());
        out.print(getClassName());
        out.print(source[74]); // 349:52 = " "
        out.print(property.getFromName());
        out.print(source[75]); // 349:79 = "("
        out.print(property.getType());
        out.print(source[76]); // 349:102 = " "
        out.print(property.getName());
        out.print(source[77]); // 349:125 = ") {"
        if (withBuilder) {
          if (property.isMutable()) {
            out.print(source[78]); // 353:2 = "    "
            out.print(getClassName());
            out.print(source[79]); // 354:22 = " object = toBuilder().build();    objec..."
            out.print(property.getSetterName());
            out.print(source[80]); // 355:39 = "("
            out.print(property.getName());
            out.print(source[81]); // 355:62 = ");    return object;"
          }
          else {
            out.print(source[82]); // 360:2 = "    return toBuilder()."
            out.print(property.getBuilderName());
            out.print(source[83]); // 361:52 = "("
            out.print(property.getName());
            out.print(source[84]); // 361:75 = ").build();"
          }
        }
        else {
          StringBuilder argBuf = new StringBuilder();
          for (Property prop: properties) {
            if (argBuf.length() > 0) {
              argBuf.append(", ");
            }
            if (prop == property) {
              argBuf.append(prop.getName());
            }
            else {
              if (prop.isInherited()) {
                argBuf.append(prop.getGetterName() + "()");
              }
              else {
                argBuf.append("this." + prop.getName());
              }
            }
          }
          out.print(source[85]); // 383:2 = "    return new "
          out.print(getClassName());
          out.print(source[86]); // 384:33 = "("
          out.print(argBuf);
          out.print(source[87]); // 384:44 = ");"
        }
        out.print(source[88]); // 387:2 = "  }"
      }
    }

    if (withEquals) {
      out.print(source[89]); // 394:2 = "  @Override  public boolean equals(Obj..."
      if (superClass != null) {
        out.print(source[90]); // 409:2 = "    if (!super.equals(obj)) {      retu..."
      }
      out.print(source[91]); // 415:2 = "    "
      out.print(getClassName());
      out.print(source[92]); // 416:22 = " other = ("
      out.print(getClassName());
      out.print(source[93]); // 416:50 = ") obj;"
      for (Property property: properties) {
        if (!property.isInherited()) {
          if (property.isPrimitive()) {
            out.print(source[94]); // 421:2 = "    if ("
            out.print(property.getName());
            out.print(source[95]); // 422:30 = " != other."
            out.print(property.getName());
            out.print(source[96]); // 422:62 = ") {      return false;    }"
          }
          else  {
            out.print(source[97]); // 428:2 = "    if (!Objects.equals("
            out.print(property.getName());
            out.print(source[98]); // 429:46 = ", other."
            out.print(property.getName());
            out.print(source[99]); // 429:76 = ")) {      return false;    }"
          }
        }
      }
      out.print(source[100]); // 436:2 = "    return true;  }"
    }


    if (withHashCode) {
      out.print(source[101]); // 444:2 = "  @Override  public int hashCode() {"
      if (superClass != null) {
        out.print(source[102]); // 450:2 = "    int hash = super.hashCode();"
      }
      else {
        out.print(source[103]); // 455:2 = "    int hash = 7;"
      }
      for (Property property: properties) {
        if (!property.isInherited()) {
          out.print(source[104]); // 461:2 = "    hash = 79 * hash + "
          out.print(property.getHashCodeInvocation());
          out.print(source[105]); // 462:59 = ";"
        }
      }
      out.print(source[106]); // 466:2 = "    return hash;  }"
    }

    if (withBuilder) {
      String extendsStr = "";
      if (superClass != null) {
        extendsStr = "extends " + superClass + ".Builder ";
      }
      out.print(source[107]); // 477:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[108]); // 481:33 = " builder.   *   * @return the builder..."
      if (withFrom) {
        out.print(source[109]); // 490:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[110]); // 493:33 = " builder from current object.   *   * ..."
      if (superClass != null) {
        out.print(source[111]); // 499:2 = "  @Override"
      }
      out.print(source[112]); // 503:2 = "  public Builder toBuilder() {    retur..."
      }
      out.print(source[113]); // 509:2 = "  /**   * The "
      out.print(getClassName());
      out.print(source[114]); // 512:27 = " builder.   */"
      if (builderAnnotation != null) {
        out.print(source[115]); // 516:2 = "  "
        out.print(builderAnnotation);
        out.print(source[116]); // 517:23 = ""
      }
      out.print(source[117]); // 520:2 = "  public static class Builder "
      out.print(extendsStr);
      out.print(source[118]); // 521:44 = "{"
      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[119]); // 526:2 = "    /** "
          out.print(property.getComment());
          out.print(source[120]); // 527:33 = ". */    private "
          out.print(property.getType());
          out.print(source[121]); // 528:34 = " "
          out.print(property.getName());
          out.print(source[122]); // 528:57 = ";"
          if (property.isRequired()) {
            out.print(source[123]); // 531:2 = "    /** true if "
            out.print(property.getComment());
            out.print(source[124]); // 532:41 = " was provided. */    private boolean "
            out.print(property.getName());
            out.print(source[125]); // 533:42 = "Provided;"
          }
          out.print(source[126]); // 536:2 = ""
        }
      }
      out.print(source[127]); // 541:2 = "    protected Builder() {}"
      if (withFrom) {
        out.print(source[128]); // 546:2 = "    protected Builder("
        out.print(getClassName());
        out.print(source[129]); // 548:40 = " template) {"
        if (superClass != null) {
          out.print(source[130]); // 551:2 = "      super(template);"
        }
        for (Property property: properties) {
          if (isRecord()) {
            out.print(source[131]); // 557:2 = "      "
            out.print(property.getBuilderName());
            out.print(source[132]); // 558:35 = "(template."
            out.print(property.getName());
            out.print(source[133]); // 558:67 = "());"
          }
          else {
            if (!property.isMutable()) {
              out.print(source[134]); // 563:2 = "      "
              out.print(property.getBuilderName());
              out.print(source[135]); // 564:35 = "(template."
              out.print(property.getGetterName());
              out.print(source[136]); // 564:73 = "());"
            }
          }
        }
        out.print(source[137]); // 569:2 = "    }"
      }

      out.print(source[138]); // 574:2 = "    /**     * Builds a "
      out.print(getClassName());
      out.print(source[139]); // 577:34 = ".     *     * @return the "
      out.print(getClassName());
      out.print(source[140]); // 579:38 = "     */"
      if (superClass != null) {
        out.print(source[141]); // 583:2 = "    @Override"
      }
      out.print(source[142]); // 587:2 = "    public "
      out.print(getClassName());
      out.print(source[143]); // 588:29 = " build() {"
      if (isAbstract()) {
        out.print(source[144]); // 591:2 = "      throw new "
        out.print(exceptionName);
        out.print(source[145]); // 592:33 = "("cannot build abstract "
        out.print(getClassName());
        out.print(source[146]); // 592:75 = "");"
      }
      else {
        out.print(source[147]); // 596:2 = "      return new "
        out.print(getClassName());
        out.print(source[148]); // 597:35 = "(this);"
      }
      out.print(source[149]); // 600:2 = "    }"

      for (Property property: properties) {
        if (!property.isMutable()) {
          out.print(source[150]); // 606:2 = "    /**     * Sets "
          out.print(property.getComment());
          out.print(source[151]); // 609:37 = ".     *     * @param "
          out.print(property.getName());
          out.print(source[152]); // 611:37 = " "
          out.print(property.getComment());
          out.print(source[153]); // 611:63 = "     * @return the builder     */"
          for (String anno: property.getAnnotations()) {
            out.print(source[154]); // 616:2 = "    "
            out.print(anno);
            out.print(source[155]); // 617:12 = ""
          }
          out.print(source[156]); // 620:2 = "    public Builder "
          out.print(property.getBuilderName());
          out.print(source[157]); // 621:48 = "("
          out.print(property.getType());
          out.print(source[158]); // 621:71 = " "
          out.print(property.getName());
          out.print(source[159]); // 621:94 = ") {      this."
          out.print(property.getName());
          out.print(source[160]); // 622:33 = " = "
          out.print(property.getName());
          out.print(source[161]); // 622:58 = ";"
        if (property.isRequired()) {
          out.print(source[162]); // 625:2 = "      "
          out.print(property.getName());
          out.print(source[163]); // 626:28 = "Provided = true;"
        }
        out.print(source[164]); // 629:2 = "      return this;    }"
        }
      }
      out.print(source[165]); // 635:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
