/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeOptions;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendFactory;
import org.tentackle.sql.DataType;
import org.tentackle.wurblet.AnnotationOption;
import org.tentackle.wurblet.ComponentInfo;
import org.tentackle.wurblet.TentackleWurbletsModel;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelTerminationException;
import org.wurbelizer.wurblet.AbstractJavaWurblet;

public class ModelWurblet
extends AbstractJavaWurblet {
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\s*([\\w\\.]+)\\.class");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^\\s*import\\s+([\\w\\.]+)\\s*;");
    private static final Map<String, String> PACKAGE_CACHE = new ConcurrentHashMap<String, String>();
    private String modelDirName;
    private List<String> otherModelDirNames;
    private String modelName;
    private ModelDefaults modelDefaults;
    private Entity entity;
    private List<String> args;
    private List<String> optionArgs;
    private List<String> wurbletArgs;
    private Boolean isPdo;
    private boolean isInterface;
    private boolean remote;
    private String pdoClassName;
    private boolean isOperation;
    private boolean missingModelOk;
    private Collection<Backend> backends;

    public String getModelDirName() {
        return this.modelDirName;
    }

    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    public String getPdoClassName() throws WurbelException {
        if (this.isPdo == null) {
            int ndx;
            String annotation;
            this.isPdo = false;
            int ndx2 = 0;
            while ((annotation = this.getContainer().getProperty("wurblet", "annotation_" + ndx2)) != null) {
                if (annotation.startsWith("@DomainObjectService") || annotation.startsWith("@PersistentObjectService")) {
                    Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
                    if (matcher.find()) {
                        this.pdoClassName = matcher.group(1);
                        if (this.getContainer().getVerbosity().isDebug()) {
                            this.getContainer().getLogger().info("pdo: " + this.pdoClassName);
                        }
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                    throw new WurbelException("malformed annotation: " + annotation);
                }
                if (annotation.startsWith("@DomainOperationService") || annotation.startsWith("@PersistentOperationService")) {
                    Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
                    if (matcher.find()) {
                        this.pdoClassName = matcher.group(1);
                        this.isOperation = true;
                        if (this.getContainer().getVerbosity().isDebug()) {
                            this.getContainer().getLogger().info("operation: " + this.pdoClassName);
                        }
                        return this.pdoClassName;
                    }
                    throw new WurbelException("malformed annotation: " + annotation);
                }
                ++ndx2;
            }
            String persistentIface = this.getContainer().getProperty("wurblet", "extends_0");
            if (persistentIface != null && (ndx = persistentIface.indexOf(60)) > 0 && (ndx = (persistentIface = persistentIface.substring(ndx + 1)).lastIndexOf(62)) > 0) {
                this.pdoClassName = persistentIface.substring(0, ndx);
                if (this.pdoClassName.length() > 1 && this.pdoClassName.indexOf(60) < 0) {
                    this.isPdo = true;
                    this.isInterface = true;
                    return this.pdoClassName;
                }
            }
            this.pdoClassName = this.getContainer().getProperty("wurblet", "definition");
            if (this.pdoClassName != null) {
                int ndx3;
                if (this.getContainer().getVerbosity().isDebug()) {
                    this.getContainer().getLogger().info(this.getContainer().getProperty("wurblet", "classname") + ": definition = '" + this.pdoClassName + "'");
                }
                if ((ndx3 = this.pdoClassName.indexOf("extends")) >= 0) {
                    int ndx1 = this.pdoClassName.indexOf(60);
                    int ndx22 = this.pdoClassName.indexOf(44);
                    if (ndx1 > ndx3 && ndx22 > ndx1) {
                        this.pdoClassName = this.pdoClassName.substring(ndx1 + 1, ndx22).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
                if ((ndx3 = this.pdoClassName.indexOf("T extends")) >= 0) {
                    this.pdoClassName = this.pdoClassName.substring(ndx3 + 9);
                    ndx3 = this.pdoClassName.indexOf(60);
                    if (ndx3 > 0) {
                        this.pdoClassName = this.pdoClassName.substring(0, ndx3).trim();
                        this.isPdo = true;
                        return this.pdoClassName;
                    }
                }
            }
            this.pdoClassName = this.getContainer().getProperty("wurblet", "interfacename");
            if (this.pdoClassName != null) {
                return this.pdoClassName;
            }
            throw new WurbelException("cannot determine the pdo-class from the java-source");
        }
        return this.pdoClassName;
    }

    public boolean isPdo() {
        if (this.isPdo == null) {
            try {
                this.getPdoClassName();
            }
            catch (WurbelException wurbelException) {
                // empty catch block
            }
        }
        return this.isPdo;
    }

    public boolean isOperation() {
        return this.isOperation;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isPartOfInheritanceHierarchy() {
        return this.isPdo() && this.getEntity().getTopSuperEntity().isAbstract();
    }

    public boolean isGenerified() {
        String definition = this.getContainer().getProperty("wurblet", "definition");
        return definition != null && definition.startsWith("<");
    }

    public boolean isMuteOptionSet(Entity entity) {
        boolean mute = false;
        for (Attribute attr : entity.getAttributes()) {
            AttributeOptions options = attr.getOptions();
            if (!options.isMute() || options.isNoConstant() || options.isNoDeclare() || options.isFromSuper()) continue;
            mute = true;
            break;
        }
        return mute;
    }

    public String getMethodName() throws WurbelException {
        String methodName = this.getOption("method");
        if (methodName == null) {
            methodName = this.getGuardName();
        }
        return methodName;
    }

    public String getModelName() throws WurbelException {
        if (this.modelName == null) {
            this.modelName = this.getOption("model");
            if (this.modelName == null) {
                this.modelName = this.getPdoClassName();
            }
            if (this.modelName == null) {
                throw new WurbelException("model not specified");
            }
        }
        return this.modelName;
    }

    public String deriveClassNameForEntity(Entity otherEntity) throws WurbelException {
        String entityName;
        String className = this.getClassName();
        int ndx = className.indexOf(entityName = this.getEntity().getName());
        if (ndx < 0) {
            throw new WurbelException(className + " does not contain the entity name '" + entityName + "' substring");
        }
        String lead = className.substring(0, ndx);
        String tail = className.substring(ndx + entityName.length());
        return lead + otherEntity.getName() + tail;
    }

    public List<Entity> orderByInheritanceLevelAndClassId(List<Entity> entities) {
        entities.sort(Comparator.comparingInt(ModelElement::getOrdinal).thenComparingInt(Entity::getClassId));
        return entities;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getOptionArgs() {
        return this.optionArgs;
    }

    public String getOption(String option) {
        int equalsOffset = option.length();
        for (String arg : this.getOptionArgs()) {
            if (arg.equals(option)) {
                return "";
            }
            if (!arg.startsWith(option) || arg.charAt(equalsOffset) != '=') continue;
            return arg.substring(equalsOffset + 1);
        }
        return null;
    }

    public List<String> getWurbletArgs() {
        return this.wurbletArgs;
    }

    public String createRelationSelectMethodName(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("select");
        if (relation.getMethodName() != null) {
            if (relation.getRelationType() == RelationType.LIST) {
                text.append("By");
            }
            text.append(relation.getMethodName());
        } else if (relation.getRelationType() == RelationType.LIST) {
            text.append("By");
            for (MethodArgument arg : relation.getMethodArgs()) {
                text.append(StringHelper.firstToUpper((String)arg.getForeignAttribute().getName()));
            }
        } else if (relation.isSelectionCached()) {
            text.append("Cached");
        }
        return text.toString();
    }

    public String createListRelationDeleteMethodName(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("deleteBy");
        if (relation.getMethodName() != null) {
            text.append(relation.getMethodName());
        } else {
            for (MethodArgument arg : relation.getMethodArgs()) {
                text.append(StringHelper.firstToUpper((String)arg.getForeignAttribute().getName()));
            }
        }
        return text.toString();
    }

    public String createDeclaredArgsForSelectOrDeleteMethod(Relation relation) throws ModelException {
        StringBuilder text = new StringBuilder();
        for (MethodArgument arg : relation.getMethodArgs()) {
            if (!text.isEmpty()) {
                text.append(", ");
            }
            Attribute attr = arg.getForeignAttribute();
            text.append(attr.getJavaType()).append(' ').append(attr.getName());
        }
        return text.toString();
    }

    public DataType<?> getEffectiveDataType(Attribute attribute) throws WurbelException {
        try {
            return attribute.getEffectiveDataType();
        }
        catch (ModelException e) {
            throw new WurbelException("cannot determine effective datatype for " + String.valueOf(attribute), (Throwable)e);
        }
    }

    public String getColumnName(Attribute attribute, int columnIndex) throws WurbelException {
        try {
            return columnIndex < 0 ? attribute.getColumnName() : attribute.getColumnName(null, columnIndex);
        }
        catch (ModelException e) {
            throw new WurbelException("cannot determine column name for " + String.valueOf(attribute) + ", index " + columnIndex, (Throwable)e);
        }
    }

    public String getColumnNameConstant(Attribute attribute, int columnIndex) throws WurbelException {
        DataType<?> effectiveDataType = this.getEffectiveDataType(attribute);
        if (columnIndex >= 0 && effectiveDataType.isColumnCountBackendSpecific()) {
            throw new WurbelException("backend-specific type " + String.valueOf(effectiveDataType) + " has varying number of columns");
        }
        return "CN_" + (attribute.getName() + (columnIndex < 0 ? "" : this.getEffectiveDataType(attribute).getColumnSuffix(null, columnIndex).orElse(""))).toUpperCase(Locale.ROOT);
    }

    public List<AnnotationOption> getAnnotationOptions(List<String> annotations, String annotationType) {
        ArrayList<AnnotationOption> annotationOptions = new ArrayList<AnnotationOption>();
        for (String annotation : annotations) {
            AnnotationOption annotationOption = new AnnotationOption(annotation);
            String type = annotationOption.getAnnotationType();
            int ndx = type.lastIndexOf(46);
            if (ndx >= 0) {
                type = type.substring(ndx + 1);
            }
            if (!type.equals(annotationType)) continue;
            annotationOptions.add(annotationOption);
        }
        return annotationOptions;
    }

    public List<Attribute> getEmbeddedTableAttributes() throws WurbelException {
        ArrayList<Attribute> embeddedAttributes = new ArrayList<Attribute>();
        try {
            for (Attribute attribute : this.getEntity().getTableAttributes()) {
                if (!attribute.isEmbedded()) continue;
                embeddedAttributes.add(attribute);
            }
        }
        catch (ModelException mx) {
            throw new WurbelException("cannot determine embedded attributes", (Throwable)mx);
        }
        return embeddedAttributes;
    }

    public void run() throws WurbelException {
        ModelException mex;
        Throwable throwable;
        WurbelException wex;
        Object wex2;
        Model model;
        File modelDir;
        block35: {
            String wurbletOptions = this.getConfiguration();
            if (wurbletOptions != null && wurbletOptions.contains("missingModelOk")) {
                this.missingModelOk = true;
            }
            super.run();
            this.args = Arrays.asList(this.container.getArgs());
            this.wurbletArgs = new ArrayList<String>();
            this.optionArgs = new ArrayList<String>();
            for (String arg : this.args) {
                if (arg == null) continue;
                if (arg.startsWith("--")) {
                    this.optionArgs.add(arg.substring(2));
                    continue;
                }
                this.wurbletArgs.add(arg);
            }
            this.modelDirName = this.getContainer().getProperty("extra", "model");
            if (this.modelDirName == null) {
                throw new WurbelException("missing wurblet property 'model'");
            }
            modelDir = new File(this.modelDirName);
            if (!modelDir.exists()) {
                this.getContainer().getLogger().info("creating " + String.valueOf(modelDir));
                modelDir.mkdirs();
            }
            if (!modelDir.isDirectory()) {
                throw new WurbelException(String.valueOf(modelDir) + " is not a directory");
            }
            String otherModels = this.getContainer().getProperty("extra", "otherModels");
            if (otherModels != null) {
                this.otherModelDirNames = new ArrayList<String>();
                StringTokenizer stok = new StringTokenizer(otherModels, " \t\n\r\f,");
                while (stok.hasMoreTokens()) {
                    this.otherModelDirNames.add(stok.nextToken());
                }
            }
            this.backends = BackendFactory.getInstance().getBackends(this.getContainer().getProperty("extra", "backends"));
            Model.getInstance().getEntityFactory().setBackends(this.backends);
            this.modelDefaults = null;
            String modelDefaultsStr = this.getContainer().getProperty("extra", "modelDefaults");
            if (modelDefaultsStr != null) {
                try {
                    this.modelDefaults = new ModelDefaults(modelDefaultsStr);
                }
                catch (ModelException mex2) {
                    throw new WurbelException(mex2.getMessage(), (Throwable)mex2);
                }
            }
            EntityAliases entityAliases = null;
            String entityAliasesStr = this.getContainer().getProperty("extra", "entityAliases");
            if (entityAliasesStr != null) {
                try {
                    entityAliases = new EntityAliases(entityAliasesStr);
                }
                catch (ModelException mex3) {
                    throw new WurbelException(mex3.getMessage(), (Throwable)mex3);
                }
            }
            model = Model.getInstance();
            model.setModelDefaults(this.modelDefaults);
            model.setEntityAliases(entityAliases);
            try {
                if (this.otherModelDirNames != null) {
                    for (String otherModelDirName : this.otherModelDirNames) {
                        model.loadFromDirectory(otherModelDirName, false);
                    }
                }
                model.loadFromDirectory(this.modelDirName, true);
            }
            catch (ModelException mex4) {
                TentackleWurbletsModel tentackleWurbletsModel;
                WurbelException loadingException;
                wex2 = new WurbelTerminationException("errors in model loaded from directory '" + this.modelDirName + "'", true, (Throwable)mex4);
                if (model instanceof TentackleWurbletsModel) {
                    TentackleWurbletsModel tentackleWurbletsModel2 = (TentackleWurbletsModel)model;
                    if (mex4.getElement() != null && tentackleWurbletsModel2.getLoadingException() == null) {
                        tentackleWurbletsModel2.setLoadingException((WurbelException)((Object)wex2));
                    }
                }
                if (model instanceof TentackleWurbletsModel && (loadingException = (tentackleWurbletsModel = (TentackleWurbletsModel)model).getLoadingException()) != null) {
                    wex2 = new WurbelTerminationException(mex4.getMessage(), true, loadingException.getCause());
                }
                throw wex2;
            }
            try {
                if (this.getModelName().indexOf(File.separatorChar) >= 0) {
                    try {
                        this.entity = model.loadFromURL(new File(this.getModelName()).toURI().toURL(), true).getEntity();
                        break block35;
                    }
                    catch (IOException ex) {
                        throw new ModelException("cannot determine canonical path of model " + this.getModelName(), (Throwable)ex);
                    }
                }
                this.entity = model.getByEntityName(this.getModelName());
            }
            catch (ModelException mex5) {
                throw new WurbelTerminationException("errors in model loaded from file '" + this.getModelName() + "'", (Throwable)mex5);
            }
        }
        if (this.entity == null && !this.missingModelOk) {
            Throwable delayedException = null;
            if (model instanceof TentackleWurbletsModel && (wex2 = ((TentackleWurbletsModel)model).getLoadingException()) != null) {
                delayedException = wex2.getCause();
            }
            if (delayedException instanceof ModelException) {
                throw new WurbelTerminationException(delayedException.getMessage(), delayedException);
            }
            throw new WurbelTerminationException("no such entity '" + this.getModelName() + "' in model " + String.valueOf(modelDir), delayedException);
        }
        if (this.entity != null) {
            this.remote = this.entity.getOptions().isRemote();
        } else if (this.modelDefaults != null && this.modelDefaults.getRemote() != null) {
            this.remote = this.modelDefaults.getRemote();
        }
        if (this.getOption("remote") != null) {
            this.remote = true;
        }
        if (this.getOption("noremote") != null) {
            this.remote = false;
        }
        if (model instanceof TentackleWurbletsModel && this.entity != null && (wex = ((TentackleWurbletsModel)model).getLoadingException()) != null && (throwable = wex.getCause()) instanceof ModelException && (mex = (ModelException)throwable).isRelatedTo((ModelElement)this.entity)) {
            throw wex;
        }
    }

    public Collection<Backend> getBackends() {
        return this.backends;
    }

    public void assertSupportedByBackends(String feature, Function<Backend, Boolean> backendValidator) throws WurbelException {
        HashMap<Backend, String> result = new HashMap<Backend, String>();
        for (Backend backend : this.getBackends()) {
            try {
                if (!Boolean.FALSE.equals(backendValidator.apply(backend))) continue;
                result.put(backend, "");
            }
            catch (RuntimeException rx) {
                String msg = rx.getMessage();
                result.put(backend, msg == null ? "" : msg);
            }
        }
        if (result.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        StringBuilder detailMsg = new StringBuilder();
        msg.append(feature).append(" not supported by ");
        boolean needComma = false;
        for (Map.Entry entry : result.entrySet()) {
            if (needComma) {
                msg.append(", ");
            } else {
                needComma = true;
            }
            msg.append(entry.getKey());
            if (((String)entry.getValue()).isBlank()) continue;
            detailMsg.append('\n').append(entry.getKey()).append(": ").append((String)entry.getValue());
        }
        msg.append((CharSequence)detailMsg);
        throw new WurbelException(msg.toString());
    }

    public boolean isIdAttribute(Attribute attribute) {
        return attribute.getName().equals("id");
    }

    public boolean isSerialAttribute(Attribute attribute) {
        return attribute.getName().equals("serial");
    }

    public boolean isIdOrSerialAttribute(Attribute attribute) {
        return this.isIdAttribute(attribute) || this.isSerialAttribute(attribute);
    }

    public boolean isAttributeDerived(Attribute attribute) {
        return attribute.getOptions().isFromSuper() || attribute.getEntity() != this.entity;
    }

    public void appendCommaSeparated(StringBuilder builder, String appendStr) {
        if (!builder.isEmpty()) {
            builder.append(", ");
        }
        builder.append(appendStr);
    }

    public void prependCommaSeparated(StringBuilder builder, String prependStr) {
        if (!builder.isEmpty()) {
            builder.insert(0, ", ");
        }
        builder.insert(0, prependStr);
    }

    public ComponentInfo createComponentInfo(Entity component) throws WurbelException {
        return new ComponentInfo(this, component);
    }

    public String createAccessorCode(Entity entity, String path, boolean createSetter) throws WurbelException {
        StringBuilder buf = new StringBuilder();
        StringTokenizer stok = new StringTokenizer(path, ".");
        int tokenCount = stok.countTokens();
        int tokenIndex = 0;
        while (stok.hasMoreTokens()) {
            String name = stok.nextToken();
            if (tokenIndex < tokenCount - 1) {
                Relation relation = entity.getRelation(name, true);
                if (relation == null) {
                    throw new WurbelException("no such relation '" + name + "' in path '" + path + "'");
                }
                buf.append(relation.getGetterName()).append("().");
                entity = relation.getForeignEntity();
            } else {
                Attribute attribute;
                String column = null;
                int colNdx = name.indexOf(35);
                if (colNdx >= 0 && colNdx < name.length() - 1) {
                    column = name.substring(colNdx + 1);
                    name = name.substring(0, colNdx);
                }
                if ((attribute = entity.getAttributeByJavaName(name, true)) == null) {
                    throw new WurbelException("no such attribute '" + name + "' in path '" + path + "'");
                }
                if (column != null) {
                    buf.append(attribute.getGetterName()).append("().");
                    DataType dataType = attribute.getDataType();
                    int columnCount = dataType.getColumnCount(null);
                    if (columnCount == 1) {
                        throw new WurbelException("datatype '" + String.valueOf(dataType) + "' in path '" + path + "' is not a multi-column type");
                    }
                    if (createSetter) {
                        throw new WurbelException("multi-column datatypes such as '" + String.valueOf(dataType) + "' in path '" + path + "' are immutable");
                    }
                    boolean found = false;
                    for (int i = 0; i < columnCount; ++i) {
                        String columnAlias = dataType.getColumnAlias(i);
                        if (!columnAlias.equalsIgnoreCase(column)) continue;
                        found = true;
                        buf.append(dataType.getColumnGetter(i, column));
                        break;
                    }
                    if (!found) {
                        throw new WurbelException("no such datatype column '" + column + "' in path '" + path + "'");
                    }
                } else if (createSetter) {
                    buf.append(attribute.getSetterName());
                } else {
                    buf.append(attribute.getGetterName());
                }
            }
            ++tokenIndex;
        }
        return buf.toString();
    }

    public String getNonPrimitiveJavaType(Attribute attribute) throws ModelException {
        DataType dataType = attribute.getDataType();
        return dataType.isPrimitive() ? dataType.toNonPrimitive().getJavaType() : attribute.getJavaType();
    }

    public String determinePackageName(String className) throws WurbelException {
        String packageName = this.getPackageName();
        return PACKAGE_CACHE.computeIfAbsent(className, cn -> {
            String sourceText = this.getContainer().getProperty("wurblet", "filecontents");
            if (sourceText != null) {
                String endStr = "." + className;
                for (String line : sourceText.lines().toList()) {
                    String fqcn;
                    Matcher matcher = IMPORT_PATTERN.matcher(line);
                    if (!matcher.find() || !(fqcn = matcher.group(1)).endsWith(endStr)) continue;
                    return fqcn.substring(0, fqcn.length() - endStr.length());
                }
            }
            return packageName;
        });
    }
}

