/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.wurblet;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.common.StringHelper;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelHelper;
import org.wurbelizer.wurblet.AbstractWurblet;

public class DTOWurblet
extends AbstractWurblet {
    protected String filename;
    protected List<Property> properties;
    protected boolean needConstructor;
    protected boolean withBuilder;
    protected boolean withBindable;
    protected String extendsWithBuilder;

    public void run() throws WurbelException {
        super.run();
        for (String arg : this.getContainer().getArgs()) {
            if ("--builder".equals(arg)) {
                this.withBuilder = true;
                continue;
            }
            if ("--bindable".equals(arg)) {
                this.withBindable = true;
                continue;
            }
            if (this.filename != null || arg.startsWith("--")) continue;
            this.filename = arg;
        }
        if (this.filename == null) {
            throw new WurbelException("usage: @wurblet <guardname> DTO [--builder] <filename>");
        }
        if (this.withBuilder) {
            try {
                this.extendsWithBuilder = this.getSuperClassName();
            }
            catch (WurbelException wurbelException) {
                // empty catch block
            }
        }
        this.properties = new ArrayList<Property>();
        try (BufferedReader reader = new BufferedReader(WurbelHelper.openReader((String)this.filename));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (StringHelper.isAllWhitespace((String)line) || line.startsWith("#")) continue;
                StringTokenizer stok = new StringTokenizer(line);
                String type = null;
                String name = null;
                StringBuilder comment = new StringBuilder();
                while (stok.hasMoreTokens()) {
                    String token = stok.nextToken();
                    if (type == null) {
                        type = token;
                        continue;
                    }
                    if (name == null) {
                        name = token;
                        continue;
                    }
                    if (comment.length() > 0) {
                        comment.append(' ');
                    }
                    comment.append(token);
                }
                if (type == null || name == null) {
                    throw new WurbelException("property line too short: '" + line + "'");
                }
                Property property = new Property(type, name, comment.toString());
                if (!property.isMutable()) {
                    this.needConstructor = true;
                }
                this.properties.add(property);
            }
        }
        catch (IOException ex) {
            throw new WurbelException("reading model " + this.filename + " failed", (Throwable)ex);
        }
    }

    protected static class Property {
        private final String type;
        private final String name;
        private final String comment;
        private final boolean inherited;
        private final boolean mutable;
        private final String[] annotations;

        public Property(String type, String name, String comment) {
            if (type.startsWith("^")) {
                this.inherited = true;
                this.mutable = false;
                this.type = type.substring(1);
            } else if (type.startsWith("=")) {
                this.mutable = true;
                this.inherited = false;
                this.type = type.substring(1);
            } else {
                this.type = type;
                this.inherited = false;
                this.mutable = false;
            }
            this.name = name;
            StringBuilder buf = new StringBuilder(comment == null || comment.isEmpty() ? "the " + name + " property" : comment);
            this.annotations = this.parseComment(buf);
            this.comment = buf.toString().trim();
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public boolean isMutable() {
            return this.mutable;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public String getGetterName() {
            return ("boolean".equals(this.type) ? "is" : "get") + StringHelper.firstToUpper((String)this.name);
        }

        public String getSetterName() {
            return "set" + StringHelper.firstToUpper((String)this.name);
        }

        public String[] getAnnotations() {
            return this.annotations;
        }

        public boolean isBindableAnnotationPresent() {
            for (String anno : this.annotations) {
                if (!anno.startsWith("@Bindable")) continue;
                return true;
            }
            return false;
        }

        private String[] parseComment(StringBuilder commentBuf) {
            ArrayList<String> annos = new ArrayList<String>();
            String cmt = commentBuf.toString();
            commentBuf.setLength(0);
            StringBuilder anno = null;
            for (int i = 0; i < cmt.length(); ++i) {
                char c = cmt.charAt(i);
                if (anno == null) {
                    if (c == '[') {
                        anno = new StringBuilder();
                        continue;
                    }
                    commentBuf.append(c);
                    continue;
                }
                if (c == ']') {
                    String an = anno.toString().trim();
                    if (!an.isEmpty()) {
                        annos.add(an);
                    }
                    anno = null;
                    continue;
                }
                anno.append(c);
            }
            return annos.toArray(new String[0]);
        }
    }
}

