// wurblet generated by Wurbelizer 8.2.2.1, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.wurbelizer.wurbel.*;
import org.wurbelizer.wurblet.*;
import org.wurbelizer.misc.*;

/**
 * <strong>({@code @wurblet})</strong> DTO creates code for a data transfer object.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; DTO [--builder] &lt;filename&gt;
 * <p>
 * arguments:
 * <ul>
 * <li><em>--builder:</em> option to generate code according to the builder pattern.</li>
 * <li><em>filename:</em> the file holding the DTO model.</li>
 * </ul>
 * For more options, see {@link AbstractWurblet}.
 * <p>
 * The model is usually stored in a heap-file such as ".$filename" created as a here-document within the leading comment
 * block of the DTO-file.<br>
 * Each line describes a property.<br>
 * Example:
 * <pre>
 * String  name    the object's name
 * int     count   the counter
 * </pre>
 * If the line is prefixed with "^", the property is passed to the super entity within the constructor.<br>
 * This option is ignored in builder pattern mode.<br>
 * Example:
 * <pre>
 * ^String name   the name
 * </pre>
 * If the line is prefixed with "=", the property is mutable and a setter is generated.<br>
 * Example:
 * <pre>
 * =String name   the name
 * </pre>
 * The comment may contain optional annotations enclosed in square brackets.
 * <pre>
 * String name   the name [&#64;Bindable(MAXCOL=20)] [&#64;MyAnno]
 * </pre>
 * <p>
 * Annotations not belonging to a property are applied to all properties, if not already defined in the comment.
 * <pre>
 * [&#64;Bindable]
 * String blah   the blah
 * ...
 * </pre>
 * <p>
 * If the builder pattern is used and the class extends a superclass, the builder is created as an extension
 * of the superclass'es builder.
 */
public class DTO extends DTOWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws WurbelException {

    // create declarations
    for (Property property: properties) {
      if (!property.isInherited()) {
        if (property.isMutable()) {
          out.print(source[0]); // 63:2 = "  private "
          out.print(property.getType());
          out.print(source[1]); // 64:32 = " "
          out.print(property.getName());
          out.print(source[2]); // 64:55 = ";  // "
          out.print(property.getComment());
          out.print(source[3]); // 64:86 = ""
        }
        else {
          out.print(source[4]); // 68:2 = "  private final "
          out.print(property.getType());
          out.print(source[5]); // 69:38 = " "
          out.print(property.getName());
          out.print(source[6]); // 69:61 = ";  // "
          out.print(property.getComment());
          out.print(source[7]); // 69:92 = ""
        }
      }
    }

    // create constructor
    if (needConstructor || withBuilder) {
      out.print(source[8]); // 77:2 = ""
      if (!withBuilder) {
        out.print(source[9]); // 81:2 = "  /**   * Creates a "
        out.print(getClassName());
        out.print(source[10]); // 83:33 = ".   *"
        for (Property property: properties) {
          if (!property.isMutable()) {
            out.print(source[11]); // 88:2 = "   * @param "
            out.print(property.getName());
            out.print(source[12]); // 89:35 = " "
            out.print(property.getComment());
            out.print(source[13]); // 89:61 = ""
          }
        }
        out.print(source[14]); // 93:2 = "   */"
      }
      StringBuilder args = new StringBuilder();
      StringBuilder superArgs = new StringBuilder();
      for (Property property: properties) {
        if (!property.isMutable()) {
          if (property.isInherited()) {
            if (superArgs.length() > 0) {
              superArgs.append(", ");
            }
            if (withBuilder) {
              superArgs.append("builder.");
            }
            superArgs.append(property.getName());
          }
          if (args.length() > 0) {
            args.append(", ");
          }
          if (!withBuilder) {
            args.append(property.getType()).append(' ').append(property.getName());
          }
        }
      }

      if (withBuilder) {
        out.print(source[15]); // 120:2 = "  protected "
        out.print(getClassName());
        out.print(source[16]); // 121:30 = "(Builder builder) {"
        if (extendsWithBuilder != null) {
          out.print(source[17]); // 124:2 = "    super(builder);"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[18]); // 130:2 = "    this."
            out.print(property.getName());
            out.print(source[19]); // 131:31 = " = builder."
            out.print(property.getName());
            out.print(source[20]); // 131:64 = ";"
          }
        }
        out.print(source[21]); // 135:2 = "  }"
      }
      else {
        out.print(source[22]); // 140:2 = "  public "
        out.print(getClassName());
        out.print(source[23]); // 141:27 = "("
        out.print(args.toString());
        out.print(source[24]); // 141:47 = ") {"
        if (superArgs.length() > 0) {
          out.print(source[25]); // 144:2 = "    super("
          out.print(superArgs);
          out.print(source[26]); // 145:23 = ");"
        }
        for (Property property: properties) {
          if (!property.isInherited() && !property.isMutable()) {
            out.print(source[27]); // 150:2 = "    this."
            out.print(property.getName());
            out.print(source[28]); // 151:31 = " = "
            out.print(property.getName());
            out.print(source[29]); // 151:56 = ";"
          }
        }
        out.print(source[30]); // 155:2 = "  }"
      }
    }

    // create getter
    for (Property property: properties) {
      if (!property.isInherited()) {
        out.print(source[31]); // 164:2 = "  /**   * Gets "
        out.print(property.getComment());
        out.print(source[32]); // 167:35 = ".   *   * @return "
        out.print(property.getComment());
        out.print(source[33]); // 169:39 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[34]); // 173:2 = "  "
          out.print(anno);
          out.print(source[35]); // 174:10 = ""
        }
        out.print(source[36]); // 177:2 = "  public "
        out.print(property.getType());
        out.print(source[37]); // 178:31 = " "
        out.print(property.getGetterName());
        out.print(source[38]); // 178:60 = "() {    return "
        out.print(property.getName());
        out.print(source[39]); // 179:33 = ";  }"
      }
    }

    // create setter
    for (Property property: properties) {
      if (property.isMutable()) {
        out.print(source[40]); // 188:2 = "  /**   * Sets "
        out.print(property.getComment());
        out.print(source[41]); // 191:35 = ".   *   * @param "
        out.print(property.getName());
        out.print(source[42]); // 193:35 = " "
        out.print(property.getComment());
        out.print(source[43]); // 193:61 = "   */"
        for (String anno: property.getAnnotations()) {
          out.print(source[44]); // 197:2 = "  "
          out.print(anno);
          out.print(source[45]); // 198:10 = ""
        }
        out.print(source[46]); // 201:2 = "  public void "
        out.print(property.getSetterName());
        out.print(source[47]); // 202:42 = "("
        out.print(property.getType());
        out.print(source[48]); // 202:65 = " "
        out.print(property.getName());
        out.print(source[49]); // 202:88 = ") {    this."
        out.print(property.getName());
        out.print(source[50]); // 203:31 = " = "
        out.print(property.getName());
        out.print(source[51]); // 203:56 = ";  }"
      }
    }

    if (withBuilder) {
      String extendsStr = "";
      if (extendsWithBuilder != null) {
        extendsStr = "extends " + extendsWithBuilder + ".Builder ";
      }
      out.print(source[52]); // 214:2 = "  /**   * Creates a "
      out.print(getClassName());
      out.print(source[53]); // 218:33 = " builder.   *   * @return the builder..."
      out.print(getClassName());
      out.print(source[54]); // 227:27 = " builder.   */  public static class Bu..."
      out.print(extendsStr);
      out.print(source[55]); // 229:44 = "{"
      for (Property property: properties) {
        out.print(source[56]); // 233:2 = "    private "
        out.print(property.getType());
        out.print(source[57]); // 234:34 = " "
        out.print(property.getName());
        out.print(source[58]); // 234:57 = ";  // "
        out.print(property.getComment());
        out.print(source[59]); // 234:88 = ""
      }
      out.print(source[60]); // 237:2 = "    protected Builder() {}"
      if (!isAbstract()) {
        out.print(source[61]); // 243:2 = "    /**     * Builds a "
        out.print(getClassName());
        out.print(source[62]); // 246:34 = ".     *     * @return the "
        out.print(getClassName());
        out.print(source[63]); // 248:38 = "     */    public "
        out.print(getClassName());
        out.print(source[64]); // 250:29 = " build() {      return new "
        out.print(getClassName());
        out.print(source[65]); // 251:35 = "(this);    }"
      }

      for (Property property: properties) {
        out.print(source[66]); // 258:2 = "    /**     * Sets "
        out.print(property.getComment());
        out.print(source[67]); // 261:37 = ".     *     * @param "
        out.print(property.getName());
        out.print(source[68]); // 263:37 = " "
        out.print(property.getComment());
        out.print(source[69]); // 263:63 = "     * @return the builder     */    ..."
        out.print(property.getName());
        out.print(source[70]); // 266:41 = "("
        out.print(property.getType());
        out.print(source[71]); // 266:64 = " "
        out.print(property.getName());
        out.print(source[72]); // 266:87 = ") {      this."
        out.print(property.getName());
        out.print(source[73]); // 267:33 = " = "
        out.print(property.getName());
        out.print(source[74]); // 267:58 = ";      return this;    }"
      }
      out.print(source[75]); // 272:2 = "  }"
    }
  }

  // ----------------- end wurblet code -----------------
}
