// wurblet generated by Wurbelizer 8.2.2.1, see http://www.wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate a comment to document the relations and usage of the entity.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ModelComment
 * <p>
 * For more options, see {@link ModelWurblet}.
 */
public class ModelComment extends ModelWurblet {

  public ModelComment() {
    setPhase(2);
  }

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() {
    // create comment for referencing relations
    List<Relation> referencingRelations = getEntity().getReferencingRelationsIncludingInherited();
    List<Entity> subEntities = getEntity().getSubEntities();
    Set<List<Relation>> compositePaths = getEntity().getTopSuperEntity().getCompositePaths();
    List<Relation> compositeRelations = new ArrayList<>();
    for (Relation relation: getEntity().getRelationsIncludingInherited()) {
      if (relation.isComposite()) {
        compositeRelations.add(relation);
      }
    }
    out.print(source[0]); // 23:2 = "  /*   * ------------------------------..."
    List<Relation> refRels = new ArrayList<>();   // referencing relations without backlinks from components
    for (Relation rel: referencingRelations) {
      Relation foreignRelation = rel.getForeignRelation();
      // don't print composite back-relations
      if (foreignRelation == null || !foreignRelation.getEntity().equals(getEntity()) ||
          !foreignRelation.isComposite()) {
        refRels.add(rel);
      }
      else {
        Relation nmRel = rel.getDefiningNmRelation();
        if (nmRel != null) {
          refRels.add(nmRel);
        }
      }
    }

    if (refRels.isEmpty()) {
      out.print(source[1]); // 45:2 = "   * "
      out.print(getEntity());
      out.print(source[2]); // 46:20 = " is not referenced by any other entity"
    }
    else {
      out.print(source[3]); // 50:2 = "   * "
      out.print(getEntity());
      out.print(source[4]); // 51:20 = " is referenced by:   *"
    }
    for (Relation rel: refRels) {
      ModelCommentSupport.printReferencedBy(getEntity(), rel, "   * ", out);
    }

    if (getEntity().isRootEntity()) {
      out.print(source[5]); // 60:2 = "   *   *   * "
      out.print(getEntity());
      out.print(source[6]); // 63:20 = " is a root entity"
    }

    if (!compositeRelations.isEmpty()) {
      out.print(source[7]); // 68:2 = "   *   *   * "
      out.print(getEntity());
      out.print(source[8]); // 71:20 = " is a composite with the components:"
      Set<Relation> allRelations = new HashSet<>();
      ModelCommentSupport.printComponents(allRelations, compositeRelations, subEntities, "   *    ", out);
    }

    List<Relation> outRels = new ArrayList<>();
    Set<Entity> components = new HashSet<>();
    components.add(getEntity());
    components.addAll(getEntity().getSuperEntities());
    for (Entity component: getEntity().getAllComponents()) {
      components.add(component);
      components.addAll(component.getSuperEntities());
    }
    for (Entity component: components) {
      for (Relation relation: component.getRelationsIncludingSubEntities()) {
        if (!relation.isComposite() && !components.contains(relation.getForeignEntity())) {
          outRels.add(relation);
        }
      }
    }

    if (outRels.isEmpty()) {
      out.print(source[9]); // 94:2 = "   *   *   * "
      out.print(getEntity());
      out.print(source[10]); // 97:20 = " is not referencing other entities"
    }
    else  {
      out.print(source[11]); // 101:2 = "   *   *   * "
      out.print(getEntity());
      out.print(source[12]); // 104:20 = " is referencing the following entities:..."
      ModelCommentSupport.printNonCompositeRelations(getEntity(), outRels, true, "   * ", out);
    }

    if (getEntity().isComposite()) {
      List<Relation> deepRels = getEntity().getDeepReferencesToComponents();
      if (deepRels.isEmpty()) {
        out.print(source[13]); // 113:2 = "   *   *   * Components of "
        out.print(getEntity());
        out.print(source[14]); // 116:34 = " are not deeply referenced"
      }
      else {
        out.print(source[15]); // 120:2 = "   *   *   * The following components ..."
        out.print(getEntity());
        out.print(source[16]); // 123:48 = " are deeply referenced:   *"
        ModelCommentSupport.printNonCompositeRelations(getEntity(), deepRels, false, "   * ", out);
      }
    }

    if (!compositePaths.isEmpty()) {
      out.print(source[17]); // 131:2 = "   *   *"
      Set<Entity> roots = new TreeSet<>();
      Set<Entity> parents = new TreeSet<>();
      for (List<Relation> compositePath: compositePaths) {
        roots.add(compositePath.get(0).getEntity());
        parents.add(compositePath.get(compositePath.size() - 1).getEntity());
      }
      StringBuilder buf = new StringBuilder();
      for (Entity parent: parents) {
        if (buf.length() > 0) {
          buf.append(", ");
        }
        buf.append(parent);
      }
      out.print(source[18]); // 148:2 = "   * "
      out.print(getEntity());
      out.print(source[19]); // 149:20 = " is a component of: "
      out.print(buf);
      out.print(source[20]); // 149:47 = ""
      buf = new StringBuilder();
      for (Entity root: roots) {
        if (buf.length() > 0) {
          buf.append(", ");
        }
        buf.append(root);
      }
      out.print(source[21]); // 158:2 = "   * and belongs to the root "
      out.print(roots.size() > 1 ? "entities" : "entity");
      out.print(source[22]); // 159:73 = ": "
      out.print(buf);
      out.print(source[23]); // 159:82 = ""
    }


    if (subEntities.isEmpty()) {
      out.print(source[24]); // 165:2 = "   *   *   * "
      out.print(getEntity());
      out.print(source[25]); // 168:20 = " is not extended"
    }
    else {
      out.print(source[26]); // 172:2 = "   *   *   * "
      out.print(getEntity());
      out.print(source[27]); // 175:20 = " is extended by:"
      ModelCommentSupport.printSubEntities(subEntities, "   *    ", out);
    }
    out.print(source[28]); // 179:2 = "   *   * ------------------------------..."
  }

  // ----------------- end wurblet code -----------------
}
